/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.measure;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;

public class TGUndoableAddMeasure
extends TGUndoableEditBase {
    private int doAction;
    private int number;

    private TGUndoableAddMeasure(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.addMeasure(actionContext, this.getSong(), this.number);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.removeMeasure(actionContext, this.getSong(), this.number);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableAddMeasure startUndo(TGContext context, int number) {
        TGUndoableAddMeasure undoable = new TGUndoableAddMeasure(context);
        undoable.doAction = 1;
        undoable.number = number;
        return undoable;
    }

    public TGUndoableAddMeasure endUndo() {
        return this;
    }

    public void addMeasure(TGActionContext context, TGSong song, Integer number) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.measure.add");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("measureNumber", number);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void removeMeasure(TGActionContext context, TGSong song, Integer number) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.measure.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("measureNumber", number);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

