/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.song;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;

public class TGUndoableSongGeneric
extends TGUndoableEditBase {
    private int doAction;
    private TGSong undoSong;
    private TGSong redoSong;

    private TGUndoableSongGeneric(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.copySongFrom(actionContext, this.getSong(), this.redoSong);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.copySongFrom(actionContext, this.getSong(), this.undoSong);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableSongGeneric startUndo(TGContext context) {
        TGUndoableSongGeneric undoable = new TGUndoableSongGeneric(context);
        undoable.doAction = 1;
        undoable.undoSong = TGUndoableSongGeneric.getSong(context).clone(new TGFactory());
        return undoable;
    }

    public TGUndoableSongGeneric endUndo() {
        this.redoSong = TGUndoableSongGeneric.getSong(this.getContext()).clone(new TGFactory());
        return this;
    }

    public void copySongFrom(TGActionContext context, TGSong song, TGSong from) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.song.copy.from");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("from", from);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

