/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.track;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGColor;
import app.tuxguitar.song.models.TGLyric;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public abstract class TGUndoableTrackBase
extends TGUndoableEditBase {
    protected TGUndoableTrackBase(TGContext context) {
        super(context);
    }

    public void addTrack(TGActionContext context, TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.add");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void removeTrack(TGActionContext context, TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.remove");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void cloneTrack(TGActionContext context, TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.clone");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void moveTrackUp(TGActionContext context, TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.move-up");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void moveTrackDown(TGActionContext context, TGSong song, TGTrack track) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.move-down");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void copyTrackFrom(TGActionContext context, TGSong song, TGTrack track, TGTrack from) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.copy.from");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute("from", from);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void setTrackSolo(TGActionContext context, TGTrack track, Boolean solo) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-solo");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute("solo", solo);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void setTrackMute(TGActionContext context, TGTrack track, Boolean mute) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-mute");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute("mute", mute);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void setTrackInfo(TGActionContext context, TGTrack track, String name, Integer offset, TGColor color) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-info");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute("name", name);
        tgActionProcessor.setAttribute("offset", offset);
        tgActionProcessor.setAttribute("color", color);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void setTrackChannel(TGActionContext context, TGTrack track, TGChannel channel) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-channel");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, channel);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }

    public void setTrackLyrics(TGActionContext context, TGTrack track, TGLyric lyrics) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.track.set-lyric");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, track);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_LYRIC, lyrics);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

