/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.track;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGColor;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public class TGUndoableTrackInfo
extends TGUndoableTrackBase {
    private int doAction;
    private int trackNumber;
    private String undoName;
    private String redoName;
    private TGColor undoColor;
    private TGColor redoColor;
    private int undoOffset;
    private int redoOffset;

    private TGUndoableTrackInfo(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.setTrackInfo(actionContext, this.getTrack(this.trackNumber), this.redoName, this.redoOffset, this.redoColor);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.setTrackInfo(actionContext, this.getTrack(this.trackNumber), this.undoName, this.undoOffset, this.undoColor);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTrackInfo startUndo(TGContext context, TGTrack track) {
        TGUndoableTrackInfo undoable = new TGUndoableTrackInfo(context);
        undoable.doAction = 1;
        undoable.trackNumber = track.getNumber();
        undoable.undoName = track.getName();
        undoable.undoOffset = track.getOffset();
        undoable.undoColor = track.getColor().clone(new TGFactory());
        return undoable;
    }

    public TGUndoableTrackInfo endUndo(TGTrack track) {
        this.redoName = track.getName();
        this.redoOffset = track.getOffset();
        this.redoColor = track.getColor().clone(new TGFactory());
        return this;
    }

    public TGTrack getTrack(int number) {
        return this.getSongManager().getTrack(this.getSong(), number);
    }
}

