/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.track;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public class TGUndoableTrackSoloMute
extends TGUndoableTrackBase {
    private int doAction;
    private int track;
    private boolean undoSolo;
    private boolean undoMute;
    private boolean redoSolo;
    private boolean redoMute;

    private TGUndoableTrackSoloMute(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        if (this.undoSolo != this.redoSolo) {
            this.setTrackSolo(actionContext, this.getTrack(this.track), this.redoSolo);
        }
        if (this.undoMute != this.redoMute) {
            this.setTrackMute(actionContext, this.getTrack(this.track), this.redoMute);
        }
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        if (this.undoSolo != this.redoSolo) {
            this.setTrackSolo(actionContext, this.getTrack(this.track), this.undoSolo);
        }
        if (this.undoMute != this.redoMute) {
            this.setTrackMute(actionContext, this.getTrack(this.track), this.undoMute);
        }
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTrackSoloMute startUndo(TGContext context, TGTrack track) {
        TGUndoableTrackSoloMute undoable = new TGUndoableTrackSoloMute(context);
        undoable.doAction = 1;
        undoable.track = track.getNumber();
        undoable.undoSolo = track.isSolo();
        undoable.undoMute = track.isMute();
        return undoable;
    }

    public TGUndoableTrackSoloMute endUndo(TGTrack track) {
        this.redoSolo = track.isSolo();
        this.redoMute = track.isMute();
        return this;
    }

    public TGTrack getTrack(int number) {
        return this.getSongManager().getTrack(this.getSong(), number);
    }
}

