/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.midi.synth.ui;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.dialog.channel.TGChannelSettingsDialog;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.util.TGProcess;
import app.tuxguitar.editor.util.TGSyncProcess;
import app.tuxguitar.editor.util.TGSyncProcessLocked;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.midi.synth.TGAudioProcessor;
import app.tuxguitar.midi.synth.TGProgram;
import app.tuxguitar.midi.synth.TGProgramElement;
import app.tuxguitar.midi.synth.TGProgramPropertiesUtil;
import app.tuxguitar.midi.synth.TGSynthChannel;
import app.tuxguitar.midi.synth.TGSynthChannelProperties;
import app.tuxguitar.midi.synth.TGSynthManager;
import app.tuxguitar.midi.synth.TGSynthesizer;
import app.tuxguitar.midi.synth.ui.TGAudioProcessorUI;
import app.tuxguitar.midi.synth.ui.TGAudioProcessorUICallback;
import app.tuxguitar.midi.synth.ui.TGAudioProcessorUIManager;
import app.tuxguitar.midi.synth.ui.TGSynthDialogDelayedCallback;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGChannelParameter;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UICheckTableSelectionEvent;
import app.tuxguitar.ui.event.UICheckTableSelectionListener;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UIMouseDoubleClickListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UICheckTable;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIReadOnlyTextField;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.ui.widget.UITableItem;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGSynchronizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TGSynthDialog
implements TGChannelSettingsDialog,
TGEventListener {
    private TGContext context;
    private TGSynthesizer synthesizer;
    private TGChannel channel;
    private TGSong song;
    private UIWindow dialog;
    private UIButton buttonReceiverAdd;
    private UIButton buttonReceiverEdit;
    private UIButton buttonOutputAdd;
    private UIButton buttonOutputEdit;
    private UIButton buttonOutputDelete;
    private UIButton buttonOutputMoveUp;
    private UIButton buttonOutputMoveDown;
    private UIReadOnlyTextField receiver;
    private UICheckTable<TGProgramElement> outputs;
    private TGProcess loadPropertiesProcess;
    private TGProcess loadIconsProcess;
    private TGProcess updateProcess;
    private Map<TGAudioProcessor, TGAudioProcessorUI> processorsUI;

    public TGSynthDialog(TGContext context, TGSynthesizer synthesizer, TGChannel channel, TGSong song) {
        this.context = context;
        this.synthesizer = synthesizer;
        this.channel = channel;
        this.song = song;
        this.processorsUI = new HashMap<TGAudioProcessor, TGAudioProcessorUI>();
        this.createSyncProcesses();
    }

    public void open(UIWindow parent) {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(parent, false, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        UITableLayout receiverLayout = new UITableLayout();
        UIPanel receiverPanel = uiFactory.createPanel((UIContainer)this.dialog, false);
        receiverPanel.setLayout((UILayout)receiverLayout);
        dialogLayout.set((UIControl)receiverPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.receiver = uiFactory.createReadOnlyTextField((UIContainer)receiverPanel);
        receiverLayout.set((UIControl)this.receiver, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.buttonReceiverAdd = uiFactory.createButton((UIContainer)receiverPanel);
        this.buttonReceiverAdd.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onAddReceiver();
            }
        });
        receiverLayout.set((UIControl)this.buttonReceiverAdd, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        this.buttonReceiverEdit = uiFactory.createButton((UIContainer)receiverPanel);
        this.buttonReceiverEdit.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onEditReceiver();
            }
        });
        receiverLayout.set((UIControl)this.buttonReceiverEdit, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout outputsLayout = new UITableLayout();
        UIPanel compositeTable = uiFactory.createPanel((UIContainer)this.dialog, false);
        compositeTable.setLayout((UILayout)outputsLayout);
        dialogLayout.set((UIControl)compositeTable, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.outputs = uiFactory.createCheckTable((UIContainer)compositeTable, true);
        this.outputs.setColumns(1);
        this.outputs.addCheckSelectionListener((UICheckTableSelectionListener)new UICheckTableSelectionListener<TGProgramElement>(){

            public void onSelect(UICheckTableSelectionEvent<TGProgramElement> event) {
                if (event.getSelectedItem() != null) {
                    TGSynthDialog.this.onEnableOuput((TGProgramElement)event.getSelectedItem().getValue(), TGSynthDialog.this.outputs.isCheckedItem(event.getSelectedItem()));
                }
            }
        });
        this.outputs.addMouseDoubleClickListener(new UIMouseDoubleClickListener(){

            public void onMouseDoubleClick(UIMouseEvent event) {
                TGSynthDialog.this.onEditElement((TGProgramElement)TGSynthDialog.this.outputs.getSelectedValue());
            }
        });
        outputsLayout.set(this.outputs, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        outputsLayout.set(this.outputs, "packed_width", (Object)Float.valueOf(250.0f));
        outputsLayout.set(this.outputs, "packed_height", (Object)Float.valueOf(200.0f));
        UITableLayout outputsButtonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel compositeButtons = uiFactory.createPanel((UIContainer)compositeTable, false);
        compositeButtons.setLayout((UILayout)outputsButtonsLayout);
        outputsLayout.set((UIControl)compositeButtons, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, null, Float.valueOf(0.0f));
        this.buttonOutputAdd = uiFactory.createButton((UIContainer)compositeButtons);
        this.buttonOutputAdd.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onAddOutput();
            }
        });
        this.buttonOutputEdit = uiFactory.createButton((UIContainer)compositeButtons);
        this.buttonOutputEdit.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onEditElement((TGProgramElement)TGSynthDialog.this.outputs.getSelectedValue());
            }
        });
        this.buttonOutputDelete = uiFactory.createButton((UIContainer)compositeButtons);
        this.buttonOutputDelete.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onRemoveOutput((TGProgramElement)TGSynthDialog.this.outputs.getSelectedValue());
            }
        });
        this.buttonOutputMoveUp = uiFactory.createButton((UIContainer)compositeButtons);
        this.buttonOutputMoveUp.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onMoveOutputUp((TGProgramElement)TGSynthDialog.this.outputs.getSelectedValue());
            }
        });
        this.buttonOutputMoveDown = uiFactory.createButton((UIContainer)compositeButtons);
        this.buttonOutputMoveDown.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onMoveOutputDown((TGProgramElement)TGSynthDialog.this.outputs.getSelectedValue());
            }
        });
        outputsButtonsLayout.set((UIControl)this.buttonOutputAdd, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(false), Boolean.valueOf(false));
        outputsButtonsLayout.set((UIControl)this.buttonOutputDelete, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(false), Boolean.valueOf(false));
        outputsButtonsLayout.set((UIControl)this.buttonOutputMoveUp, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(false), Boolean.valueOf(false));
        outputsButtonsLayout.set((UIControl)this.buttonOutputMoveDown, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_TOP, Boolean.valueOf(false), Boolean.valueOf(false));
        outputsButtonsLayout.set((UIControl)this.buttonOutputEdit, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(false), Boolean.valueOf(true));
        this.loadIcons();
        this.loadProperties();
        this.updateItems();
        this.addListeners();
        this.dialog.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGSynthDialog.this.removeListeners();
            }
        });
        TGDialogUtil.openDialog((UIWindow)this.dialog, (int)5);
    }

    public void close() {
        if (this.isOpen()) {
            this.dialog.dispose();
        }
    }

    public boolean isOpen() {
        return this.dialog != null && !this.dialog.isDisposed();
    }

    public void openReceiverSelectionDialog() {
        List<String> supportedTypes = TGSynthManager.getInstance(this.context).getAllSupportedMidiTypes();
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(this.dialog, false, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"synth-host.ui.midi.processor.dialog.title"));
        UITableLayout typeGroupLayout = new UITableLayout();
        UILegendPanel typeGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        typeGroup.setLayout((UILayout)typeGroupLayout);
        typeGroup.setText(TuxGuitar.getProperty((String)"synth-host.ui.midi.processor.tip"));
        dialogLayout.set((UIControl)typeGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel typeLabel = uiFactory.createLabel((UIContainer)typeGroup);
        typeLabel.setText(TuxGuitar.getProperty((String)"synth-host.ui.midi.processor.type") + ":");
        typeGroupLayout.set((UIControl)typeLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect typeCombo = uiFactory.createDropDownSelect((UIContainer)typeGroup);
        typeGroupLayout.set((UIControl)typeCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        for (String supportedType : supportedTypes) {
            typeCombo.addItem(new UISelectItem(supportedType, (Object)supportedType));
        }
        if (supportedTypes.size() > 0) {
            typeCombo.setSelectedValue((Object)supportedTypes.get(0));
        }
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onReceiverSelected((String)typeCombo.getSelectedValue());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public void openOutputSelectionDialog() {
        List<String> supportedTypes = TGSynthManager.getInstance(this.context).getAllSupportedAudioTypes();
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(this.dialog, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty((String)"synth-host.ui.audio.processor.dialog.title"));
        dialog.setImage(TGIconManager.getInstance((TGContext)this.context).getAppIcon());
        UITableLayout typeGroupLayout = new UITableLayout();
        UILegendPanel typeGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        typeGroup.setLayout((UILayout)typeGroupLayout);
        typeGroup.setText(TuxGuitar.getProperty((String)"synth-host.ui.audio.processor.tip"));
        dialogLayout.set((UIControl)typeGroup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel typeLabel = uiFactory.createLabel((UIContainer)typeGroup);
        typeLabel.setText(TuxGuitar.getProperty((String)"synth-host.ui.audio.processor.type") + ":");
        typeGroupLayout.set((UIControl)typeLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UIDropDownSelect typeCombo = uiFactory.createDropDownSelect((UIContainer)typeGroup);
        typeGroupLayout.set((UIControl)typeCombo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        for (String supportedType : supportedTypes) {
            typeCombo.addItem(new UISelectItem(supportedType, (Object)supportedType));
        }
        if (supportedTypes.size() > 0) {
            typeCombo.setSelectedValue((Object)supportedTypes.get(0));
        }
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGSynthDialog.this.onOutputSelected((String)typeCombo.getSelectedValue());
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    public void openProcessorUI(TGProgramElement element) {
        TGAudioProcessorUI ui = this.getProcessorUI(element);
        if (ui != null) {
            if (ui.isOpen()) {
                ui.focus();
            } else {
                ui.open(this.dialog);
            }
        }
    }

    public void addListeners() {
        TuxGuitar.getInstance().getSkinManager().addLoader((TGEventListener)this);
        TuxGuitar.getInstance().getLanguageManager().addLoader((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().addUpdateListener((TGEventListener)this);
    }

    public void removeListeners() {
        TuxGuitar.getInstance().getSkinManager().removeLoader((TGEventListener)this);
        TuxGuitar.getInstance().getLanguageManager().removeLoader((TGEventListener)this);
        TuxGuitar.getInstance().getEditorManager().removeUpdateListener((TGEventListener)this);
    }

    public void onAddReceiver() {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() {
                TGSynthDialog.this.openReceiverSelectionDialog();
            }
        });
    }

    public void onAddOutput() {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() {
                TGSynthDialog.this.openOutputSelectionDialog();
            }
        });
    }

    public void onEditElement(final TGProgramElement element) {
        if (element != null) {
            TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

                @Override
                public void run() {
                    TGSynthDialog.this.openProcessorUI(element);
                }
            });
        }
    }

    public void onRemoveOutput(TGProgramElement output) {
        TGSynthChannel channel;
        if (output != null && (channel = this.synthesizer.getChannelById(this.channel.getChannelId())) != null) {
            TGProgram program = new TGProgram();
            program.copyFrom(channel.getProgram());
            program.removeOutput(output);
            this.onProgramUpdated(program);
        }
    }

    public void onMoveOutputUp(TGProgramElement output) {
        TGSynthChannel channel;
        if (output != null && (channel = this.synthesizer.getChannelById(this.channel.getChannelId())) != null) {
            TGProgram program = new TGProgram();
            program.copyFrom(channel.getProgram());
            program.moveOutputUp(output);
            this.onProgramUpdated(program);
        }
    }

    public void onMoveOutputDown(TGProgramElement output) {
        TGSynthChannel channel;
        if (output != null && (channel = this.synthesizer.getChannelById(this.channel.getChannelId())) != null) {
            TGProgram program = new TGProgram();
            program.copyFrom(channel.getProgram());
            program.moveOutputDown(output);
            this.onProgramUpdated(program);
        }
    }

    public void onOutputSelected(String type) {
        TGSynthChannel channel;
        if (type != null && (channel = this.synthesizer.getChannelById(this.channel.getChannelId())) != null) {
            TGProgramElement element = new TGProgramElement();
            element.setId("custom-" + System.currentTimeMillis());
            element.setType(type);
            element.setEnabled(true);
            TGProgram program = new TGProgram();
            program.copyFrom(channel.getProgram());
            program.addOutput(element);
            this.onProgramUpdated(program);
        }
    }

    public void onEnableOuput(TGProgramElement output, boolean enabled) {
        TGSynthChannel channel;
        if (output != null && (channel = this.synthesizer.getChannelById(this.channel.getChannelId())) != null) {
            TGProgram program = new TGProgram();
            program.copyFrom(channel.getProgram());
            for (int i = 0; i < program.countOutputs(); ++i) {
                TGProgramElement current = program.getOutput(i);
                if (!current.equals(output)) continue;
                current.setEnabled(enabled);
            }
            this.onProgramUpdated(program);
        }
    }

    public void onReceiverSelected(String type) {
        TGSynthChannel channel;
        if (type != null && (channel = this.synthesizer.getChannelById(this.channel.getChannelId())) != null) {
            TGProgramElement element = null;
            if (type != null) {
                element = new TGProgramElement();
                element.setId("custom-" + System.currentTimeMillis());
                element.setType(type);
                element.setEnabled(true);
            }
            TGProgram program = new TGProgram();
            program.copyFrom(channel.getProgram());
            program.setReceiver(element);
            this.onProgramUpdated(program);
        }
    }

    public void onEditReceiver() {
        TGSynthChannel channel = this.synthesizer.getChannelById(this.channel.getChannelId());
        if (channel != null && channel.getProgram().getReceiver() != null) {
            this.onEditElement(channel.getProgram().getReceiver());
        }
    }

    public void onProgramUpdated(TGProgram program) {
        TGSynthChannelProperties properties = new TGSynthChannelProperties();
        TGProgramPropertiesUtil.setProgram(properties, "synth.program", program);
        TGFactory factory = TGDocumentManager.getInstance((TGContext)this.context).getSongManager().getFactory();
        ArrayList<TGChannelParameter> parameters = new ArrayList<TGChannelParameter>();
        for (Map.Entry<String, String> entry : properties.getProperties().entrySet()) {
            TGChannelParameter parameter = factory.newChannelParameter();
            parameter.setKey(entry.getKey());
            parameter.setValue(entry.getValue());
            parameters.add(parameter);
        }
        this.callUpdateChannelParametersAction(parameters);
    }

    public void onProcessorUpdated(TGProgramElement source, TGAudioProcessor processor) {
        TGSynthChannel channel = this.synthesizer.getChannelById(this.channel.getChannelId());
        if (channel != null) {
            TGProgram program = new TGProgram();
            program.copyFrom(channel.getProgram());
            TGProgramElement element = null;
            if (program.getReceiver() != null && program.getReceiver().equals(source)) {
                element = program.getReceiver();
            } else {
                int outputCount = program.countOutputs();
                for (int i = 0; i < outputCount; ++i) {
                    TGProgramElement output = program.getOutput(i);
                    if (!output.equals(source)) continue;
                    element = output;
                }
            }
            if (element != null) {
                processor.storeParameters(element.getParameters());
                this.onProgramUpdated(program);
            }
        }
    }

    public String getProcessorLabel(TGProgramElement element) {
        String label;
        TGAudioProcessorUI ui = this.getProcessorUI(element);
        if (ui != null && (label = ui.getLabel()) != null) {
            return label;
        }
        return element.getType();
    }

    public TGAudioProcessorUI getProcessorUI(TGProgramElement element) {
        TGAudioProcessor processor;
        TGSynthChannel channel = this.synthesizer.getChannelById(this.channel.getChannelId());
        if (channel != null && channel.getProcessor() != null && (processor = channel.getProcessor().getAudioProcessor(element)) != null) {
            return this.getProcessorUI(element, processor);
        }
        return null;
    }

    public TGAudioProcessorUI getProcessorUI(TGProgramElement element, TGAudioProcessor processor) {
        if (this.processorsUI.containsKey(processor)) {
            return this.processorsUI.get(processor);
        }
        TGAudioProcessorUICallback callback = this.createProcessorCallback(element, processor);
        TGAudioProcessorUI ui = TGAudioProcessorUIManager.getInstance(this.context).createUI(element.getType(), processor, callback);
        if (ui != null) {
            this.processorsUI.put(processor, ui);
        }
        return ui;
    }

    public TGAudioProcessorUICallback createProcessorCallback(final TGProgramElement element, final TGAudioProcessor processor) {
        return new TGSynthDialogDelayedCallback(this.context, new Runnable(){

            @Override
            public void run() {
                TGSynthDialog.this.onProcessorUpdated(element, processor);
            }
        });
    }

    public void loadMidiReceiver(TGProgram program) {
        this.receiver.setText(program != null && program.getReceiver() != null ? this.getProcessorLabel(program.getReceiver()) : "");
    }

    public void loadOutputsItems(TGProgram program) {
        TGProgramElement selection = (TGProgramElement)this.outputs.getSelectedValue();
        this.outputs.setIgnoreEvents(true);
        this.outputs.removeItems();
        if (program != null) {
            int outputCount = program.countOutputs();
            for (int i = 0; i < outputCount; ++i) {
                TGProgramElement output = program.getOutput(i);
                UITableItem item = new UITableItem((Object)output);
                item.setText(0, this.getProcessorLabel(output));
                this.outputs.addItem(item);
                this.outputs.setCheckedItem(item, Boolean.TRUE.equals(output.isEnabled()));
            }
        }
        if (selection != null) {
            this.outputs.setSelectedValue((Object)selection);
        }
        this.outputs.setIgnoreEvents(false);
    }

    public void loadChannel() {
        TGProgram program = null;
        TGSynthChannel channel = this.synthesizer.getChannelById(this.channel.getChannelId());
        if (channel != null) {
            program = channel.getProgram();
        }
        this.loadMidiReceiver(program);
        this.loadOutputsItems(program);
    }

    public void loadProperties() {
        if (this.isOpen()) {
            this.dialog.setText(TuxGuitar.getProperty((String)"synth-host.ui.dialog.title"));
            this.buttonReceiverAdd.setToolTipText(TuxGuitar.getProperty((String)"synth-host.ui.midi.receiver.add"));
            this.buttonReceiverEdit.setToolTipText(TuxGuitar.getProperty((String)"synth-host.ui.midi.receiver.edit"));
            this.buttonOutputAdd.setToolTipText(TuxGuitar.getProperty((String)"synth-host.ui.audio.processor.add"));
            this.buttonOutputEdit.setToolTipText(TuxGuitar.getProperty((String)"synth-host.ui.audio.processor.edit"));
            this.buttonOutputDelete.setToolTipText(TuxGuitar.getProperty((String)"synth-host.ui.audio.processor.remove"));
            this.buttonOutputMoveUp.setToolTipText(TuxGuitar.getProperty((String)"synth-host.ui.audio.processor.move-up"));
            this.buttonOutputMoveDown.setToolTipText(TuxGuitar.getProperty((String)"synth-host.ui.audio.processor.move-down"));
        }
    }

    public void loadIcons() {
        if (this.isOpen()) {
            this.dialog.setImage(TGIconManager.getInstance((TGContext)this.synthesizer.getContext()).getAppIcon());
            this.buttonReceiverAdd.setImage(TGIconManager.getInstance((TGContext)this.synthesizer.getContext()).getListAdd());
            this.buttonReceiverEdit.setImage(TGIconManager.getInstance((TGContext)this.synthesizer.getContext()).getListEdit());
            this.buttonOutputAdd.setImage(TGIconManager.getInstance((TGContext)this.synthesizer.getContext()).getListAdd());
            this.buttonOutputEdit.setImage(TGIconManager.getInstance((TGContext)this.synthesizer.getContext()).getListEdit());
            this.buttonOutputDelete.setImage(TGIconManager.getInstance((TGContext)this.synthesizer.getContext()).getImageByName("list_remove.png"));
            this.buttonOutputMoveUp.setImage(TGIconManager.getInstance((TGContext)this.synthesizer.getContext()).getImageByName("arrow_up.png"));
            this.buttonOutputMoveDown.setImage(TGIconManager.getInstance((TGContext)this.synthesizer.getContext()).getImageByName("arrow_down.png"));
        }
    }

    public void updateItems() {
        if (this.isOpen()) {
            this.loadChannel();
        }
    }

    public void createSyncProcesses() {
        this.updateProcess = new TGSyncProcessLocked(this.context, new Runnable(){

            @Override
            public void run() {
                TGSynthDialog.this.updateItems();
            }
        });
        this.loadIconsProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGSynthDialog.this.loadIcons();
            }
        });
        this.loadPropertiesProcess = new TGSyncProcess(this.context, new Runnable(){

            @Override
            public void run() {
                TGSynthDialog.this.loadProperties();
            }
        });
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 1) {
            this.updateProcess.process();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        } else if ("ui-skin".equals(event.getEventType())) {
            this.loadIconsProcess.process();
        } else if ("language".equals(event.getEventType())) {
            this.loadPropertiesProcess.process();
        }
    }

    public void callUpdateChannelParametersAction(List<TGChannelParameter> parameters) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.channel.update");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)this.song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_CHANNEL, (Object)this.channel);
        tgActionProcessor.setAttribute("parameters", parameters);
        tgActionProcessor.process();
    }
}

