/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.effect;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGNoteRange;

public class TGChangeSlappingAction
extends TGActionBase {
    public static final String NAME = "action.note.effect.change-slapping";

    public TGChangeSlappingAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
        TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        if (noteRange != null && !noteRange.isEmpty() && !track.isPercussion()) {
            boolean newValue = true;
            if (noteRange.getNotes().stream().allMatch(n -> n.getEffect().isSlapping())) {
                newValue = false;
            }
            for (TGNote note : noteRange.getNotes()) {
                this.getSongManager(context).getMeasureManager().setSlapping(note, newValue);
            }
        }
    }
}

