/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.measure;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.song.managers.TGMeasureManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.util.TGBeatRange;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.List;

public class TGRemoveUnusedVoiceAction
extends TGActionBase {
    public static final String NAME = "action.measure.general.remove-unused-voice";

    public TGRemoveUnusedVoiceAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        List beats = null;
        TGBeatRange beatRange = (TGBeatRange)context.getAttribute("beat-range");
        if (beatRange != null && !beatRange.isEmpty()) {
            beats = beatRange.getBeats();
        } else {
            beats = new ArrayList<TGBeat>();
            beats.add((TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT));
        }
        if (!beats.isEmpty()) {
            int nbVoices = 2;
            boolean[] unused = new boolean[nbVoices];
            for (int voiceIndex = 0; voiceIndex < nbVoices; ++voiceIndex) {
                unused[voiceIndex] = true;
            }
            for (TGBeat beat : beats) {
                for (int voiceIndex = 0; voiceIndex < nbVoices; ++voiceIndex) {
                    TGVoice voice = beat.getVoice(voiceIndex);
                    int n = voiceIndex;
                    unused[n] = unused[n] & (voice.isEmpty() || voice.isRestVoice());
                }
            }
            int voiceIndexToRemove = -1;
            for (int voiceIndex = 0; voiceIndex < nbVoices; ++voiceIndex) {
                if (!unused[voiceIndex]) continue;
                voiceIndexToRemove = voiceIndex;
            }
            if (voiceIndexToRemove >= 0) {
                TGMeasureManager measureMgr = this.getSongManager(context).getMeasureManager();
                ArrayList<TGMeasure> measuresDone = new ArrayList<TGMeasure>();
                for (TGBeat beat : beats) {
                    TGMeasure measure = beat.getMeasure();
                    if (measuresDone.contains(measure)) continue;
                    measureMgr.removeMeasureVoices(measure, voiceIndexToRemove);
                    measuresDone.add(measure);
                }
            }
        }
    }
}

