/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.note;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.song.managers.TGMeasureManager;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.util.TGBeatRange;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGNoteRange;

public class TGDeleteNoteOrRestAction
extends TGActionBase {
    public static final String NAME = "action.beat.general.delete-note-or-rest";

    public TGDeleteNoteOrRestAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        TGNoteRange noteRange = (TGNoteRange)context.getAttribute("note-range");
        TGBeatRange beats = (TGBeatRange)context.getAttribute("beat-range");
        TGBeat selectedBeat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        if (noteRange != null && !noteRange.isEmpty()) {
            for (TGNote note : noteRange.getNotes()) {
                TGVoice voice = note.getVoice();
                TGBeat beat = voice.getBeat();
                TGMeasure measure = beat.getMeasure();
                this.removeNote(context, measure, beat, voice, note.getString());
            }
        } else if (beats != null && !beats.isEmpty()) {
            TGVoice voice = (TGVoice)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
            TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
            for (TGBeat beat : beats.getBeats()) {
                this.removeNote(context, beat.getMeasure(), beat, voice, string.getNumber());
            }
        } else if (selectedBeat != null) {
            TGVoice voice = (TGVoice)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
            TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
            this.removeNote(context, selectedBeat.getMeasure(), selectedBeat, voice, string.getNumber());
        }
    }

    private void removeNote(TGActionContext context, TGMeasure measure, TGBeat beat, TGVoice voice, int string) {
        TGSongManager songManager = this.getSongManager(context);
        TGMeasureManager measureManager = songManager.getMeasureManager();
        if (beat.isTextBeat() && beat.isRestBeat()) {
            measureManager.removeText(beat);
        } else if (voice.isRestVoice()) {
            if (songManager.isFreeEditionMode(measure) && beat.isRestBeat() && measureManager.getLastBeat(measure.getBeats()) == beat) {
                measureManager.removeBeat(beat);
            } else {
                measureManager.removeVoice(voice, true);
            }
        } else {
            measureManager.removeNote(measure, beat.getStart(), voice.getIndex(), string);
        }
    }
}

