/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.TGUndoableEdit;
import java.util.ArrayList;

public class TGUndoableEditComposite
implements TGUndoableEdit {
    private ArrayList<TGUndoableEdit> edits = new ArrayList();

    public void addEdit(TGUndoableEdit edit) {
        this.edits.add(edit);
    }

    public ArrayList<TGUndoableEdit> getEdits() {
        return this.edits;
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        for (TGUndoableEdit edit : this.edits) {
            edit.redo(actionContext);
        }
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        for (TGUndoableEdit edit : this.edits) {
            edit.undo(actionContext);
        }
    }

    @Override
    public boolean canRedo() {
        for (TGUndoableEdit edit : this.edits) {
            if (edit.canRedo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canUndo() {
        for (TGUndoableEdit edit : this.edits) {
            if (edit.canUndo()) continue;
            return false;
        }
        return true;
    }
}

