/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.channel;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.util.TGContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TGUndoableChannelGeneric
extends TGUndoableEditBase {
    private int doAction;
    private List<TGChannel> undoChannels;
    private List<TGChannel> redoChannels;

    private TGUndoableChannelGeneric(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.setChannels(actionContext, this.getSong(), this.cloneChannels(this.getSongManager().getFactory(), this.redoChannels));
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.setChannels(actionContext, this.getSong(), this.cloneChannels(this.getSongManager().getFactory(), this.undoChannels));
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableChannelGeneric startUndo(TGContext context) {
        TGUndoableChannelGeneric undoable = new TGUndoableChannelGeneric(context);
        undoable.doAction = 1;
        undoable.undoChannels = undoable.getClonedChannels();
        return undoable;
    }

    public TGUndoableChannelGeneric endUndo() {
        this.redoChannels = this.getClonedChannels();
        return this;
    }

    private List<TGChannel> getClonedChannels() {
        ArrayList<TGChannel> channels = new ArrayList<TGChannel>();
        Iterator it = this.getSongManager().getChannels(this.getSong()).iterator();
        while (it.hasNext()) {
            channels.add((TGChannel)it.next());
        }
        return this.cloneChannels(new TGFactory(), channels);
    }

    public List<TGChannel> cloneChannels(TGFactory factory, List<TGChannel> channels) {
        ArrayList<TGChannel> clonedChannels = new ArrayList<TGChannel>();
        for (TGChannel channel : channels) {
            clonedChannels.add(channel.clone(factory));
        }
        return clonedChannels;
    }

    public void setChannels(TGActionContext context, TGSong song, List<TGChannel> channels) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.channel.set-channels");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, song);
        tgActionProcessor.setAttribute("channels", channels);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

