/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.track;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public class TGUndoableAddTrack
extends TGUndoableTrackBase {
    private int doAction;
    private TGTrack redoableTrack;

    private TGUndoableAddTrack(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.addTrack(actionContext, this.getSong(), this.redoableTrack.clone(this.getSongManager().getFactory(), this.getSong()));
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.removeTrack(actionContext, this.getSong(), this.redoableTrack.clone(this.getSongManager().getFactory(), this.getSong()));
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableAddTrack startUndo(TGContext context) {
        TGUndoableAddTrack undoable = new TGUndoableAddTrack(context);
        undoable.doAction = 1;
        return undoable;
    }

    public TGUndoableAddTrack endUndo(TGTrack track) {
        this.redoableTrack = track.clone(new TGFactory(), this.getSong());
        return this;
    }
}

