/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.track;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public class TGUndoableRemoveTrack
extends TGUndoableTrackBase {
    private int doAction;
    private TGTrack undoableTrack;

    private TGUndoableRemoveTrack(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.removeTrack(actionContext, this.getSong(), this.undoableTrack.clone(this.getSongManager().getFactory(), this.getSong()));
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.addTrack(actionContext, this.getSong(), this.undoableTrack.clone(this.getSongManager().getFactory(), this.getSong()));
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableRemoveTrack startUndo(TGContext context, TGTrack track) {
        TGUndoableRemoveTrack undoable = new TGUndoableRemoveTrack(context);
        undoable.doAction = 1;
        undoable.undoableTrack = track.clone(new TGFactory(), TGUndoableRemoveTrack.getSong(context));
        return undoable;
    }

    public TGUndoableRemoveTrack endUndo() {
        return this;
    }
}

