/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.midi;

import app.tuxguitar.gm.GMChannelRoute;
import app.tuxguitar.gm.GMChannelRouter;
import app.tuxguitar.io.midi.MidiFileWriter;
import app.tuxguitar.io.midi.MidiMessageUtils;
import app.tuxguitar.io.midi.base.MidiEvent;
import app.tuxguitar.io.midi.base.MidiSequence;
import app.tuxguitar.io.midi.base.MidiTrack;
import app.tuxguitar.player.base.MidiSequenceHandler;
import app.tuxguitar.song.models.TGTimeSignature;
import java.io.IOException;
import java.io.OutputStream;

public class MidiSequenceHandlerImpl
extends MidiSequenceHandler {
    private OutputStream stream;
    private MidiSequence sequence;
    private GMChannelRouter router;

    public MidiSequenceHandlerImpl(int tracks, GMChannelRouter router, OutputStream stream) {
        super(tracks);
        this.router = router;
        this.stream = stream;
        this.init();
    }

    private void init() {
        this.sequence = new MidiSequence(0.0f, 960);
        for (int i = 0; i < this.getTracks(); ++i) {
            this.sequence.addTrack(new MidiTrack());
        }
    }

    public MidiSequence getSequence() {
        return this.sequence;
    }

    private int resolveChannel(GMChannelRoute gmChannel, boolean bendMode) {
        return bendMode ? gmChannel.getChannel2() : gmChannel.getChannel1();
    }

    public void addEvent(int track, MidiEvent event) {
        if (track >= 0 && track < this.getSequence().countTracks()) {
            this.getSequence().getTrack(track).add(event);
        }
    }

    public void addNoteOff(long tick, int track, int channelId, int note, int velocity, int voice, boolean bendMode) {
        GMChannelRoute gmChannel = this.router.getRoute(channelId);
        if (gmChannel != null) {
            this.addEvent(track, new MidiEvent(MidiMessageUtils.noteOff(this.resolveChannel(gmChannel, bendMode), note, velocity), tick));
        }
    }

    public void addNoteOn(long tick, int track, int channelId, int note, int velocity, int voice, boolean bendMode) {
        GMChannelRoute gmChannel = this.router.getRoute(channelId);
        if (gmChannel != null) {
            this.addEvent(track, new MidiEvent(MidiMessageUtils.noteOn(this.resolveChannel(gmChannel, bendMode), note, velocity), tick));
        }
    }

    public void addPitchBend(long tick, int track, int channelId, int value, int voice, boolean bendMode) {
        GMChannelRoute gmChannel = this.router.getRoute(channelId);
        if (gmChannel != null) {
            this.addEvent(track, new MidiEvent(MidiMessageUtils.pitchBend(this.resolveChannel(gmChannel, bendMode), value), tick));
        }
    }

    public void addControlChange(long tick, int track, int channelId, int controller, int value) {
        GMChannelRoute gmChannel = this.router.getRoute(channelId);
        if (gmChannel != null) {
            this.addEvent(track, new MidiEvent(MidiMessageUtils.controlChange(gmChannel.getChannel1(), controller, value), tick));
            if (gmChannel.getChannel1() != gmChannel.getChannel2()) {
                this.addEvent(track, new MidiEvent(MidiMessageUtils.controlChange(gmChannel.getChannel2(), controller, value), tick));
            }
        }
    }

    public void addProgramChange(long tick, int track, int channelId, int instrument) {
        GMChannelRoute gmChannel = this.router.getRoute(channelId);
        if (gmChannel != null) {
            this.addEvent(track, new MidiEvent(MidiMessageUtils.programChange(gmChannel.getChannel1(), instrument), tick));
            if (gmChannel.getChannel1() != gmChannel.getChannel2()) {
                this.addEvent(track, new MidiEvent(MidiMessageUtils.programChange(gmChannel.getChannel2(), instrument), tick));
            }
        }
    }

    public void addTrackName(long tick, int track, String name) {
        this.addEvent(track, new MidiEvent(MidiMessageUtils.trackName(name), tick));
    }

    public void addTempoInUSQ(long tick, int track, int usq) {
        this.addEvent(track, new MidiEvent(MidiMessageUtils.tempoInUSQ(usq), tick));
    }

    public void addTimeSignature(long tick, int track, TGTimeSignature ts) {
        this.addEvent(track, new MidiEvent(MidiMessageUtils.timeSignature(ts), tick));
    }

    public void notifyFinish() {
        try {
            this.getSequence().finish();
            new MidiFileWriter().write(this.getSequence(), 1, this.stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

