/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app;

import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.action.TGActionAdapterManager;
import app.tuxguitar.app.action.impl.file.TGReadURLAction;
import app.tuxguitar.app.document.TGDocumentListManager;
import app.tuxguitar.app.synchronizer.TGSynchronizerControllerImpl;
import app.tuxguitar.app.system.config.TGConfigManager;
import app.tuxguitar.app.system.error.TGErrorAdapter;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.system.icons.TGSkinManager;
import app.tuxguitar.app.system.keybindings.KeyBindingActionManager;
import app.tuxguitar.app.system.language.TGLanguageManager;
import app.tuxguitar.app.system.properties.TGPropertiesAdapter;
import app.tuxguitar.app.system.variables.TGVarAdapter;
import app.tuxguitar.app.tools.scale.ScaleManager;
import app.tuxguitar.app.transport.TGTransportListener;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.util.TGClassLoader;
import app.tuxguitar.app.util.TGFileUtils;
import app.tuxguitar.app.util.TGSplash;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.component.table.TGTableViewer;
import app.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import app.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import app.tuxguitar.app.view.dialog.chord.TGCustomChordManager;
import app.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import app.tuxguitar.app.view.dialog.lyric.TGLyricEditor;
import app.tuxguitar.app.view.dialog.matrix.TGMatrixEditor;
import app.tuxguitar.app.view.dialog.piano.TGPianoEditor;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.app.view.menu.TGMenuManager;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.editor.TGEditorManager;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGUndoableManager;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.event.TGEventManager;
import app.tuxguitar.io.base.TGFileFormatManager;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.base.MidiSequencerProvider;
import app.tuxguitar.player.impl.sequencer.MidiSequencerProviderImpl;
import app.tuxguitar.resource.TGResourceLoader;
import app.tuxguitar.resource.TGResourceManager;
import app.tuxguitar.song.helpers.tuning.TuningManager;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.thread.TGMultiThreadHandler;
import app.tuxguitar.thread.TGThreadHandler;
import app.tuxguitar.thread.TGThreadManager;
import app.tuxguitar.ui.UIApplication;
import app.tuxguitar.util.TGAbstractContext;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGException;
import app.tuxguitar.util.TGLock;
import app.tuxguitar.util.TGMessagesManager;
import app.tuxguitar.util.TGSynchronizer;
import app.tuxguitar.util.error.TGErrorHandler;
import app.tuxguitar.util.error.TGErrorManager;
import app.tuxguitar.util.plugin.TGPluginManager;
import app.tuxguitar.util.properties.TGPropertiesManager;
import java.net.URL;

public class TuxGuitar {
    private static TuxGuitar instance;
    private boolean initialized = false;
    private TGLock lock;
    private TGContext context = new TGContext();
    private TGLanguageManager languageManager;
    private TGMenuManager itemManager;
    private TGCustomChordManager customChordManager;

    public TuxGuitar() {
        this.lock = new TGLock(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TuxGuitar getInstance() {
        Class<TuxGuitar> clazz = TuxGuitar.class;
        synchronized (TuxGuitar.class) {
            if (instance == null) {
                instance = new TuxGuitar();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void createApplication(URL url) {
        this.createMainContext();
        this.createUIContext(url);
    }

    private void createMainContext() {
        TGThreadManager.getInstance((TGContext)this.context).setThreadHandler((TGThreadHandler)new TGMultiThreadHandler());
        TGResourceManager.getInstance((TGContext)this.context).setResourceLoader((TGResourceLoader)TGClassLoader.getInstance(this.context));
        TGFileUtils.loadLibraries(this.context);
        TGFileUtils.loadClasspath(this.context);
        TGErrorAdapter.initialize(this.context);
        TGPropertiesAdapter.initialize(this.context);
        TGVarAdapter.initialize(this.context);
    }

    private void createUIContext(final URL url) {
        TGSynchronizer.getInstance((TGContext)this.context).setController((TGSynchronizer.TGSynchronizerController)new TGSynchronizerControllerImpl(this.context));
        UIApplication app = TGApplication.getInstance(this.context).getApplication();
        this.getPluginManager().earlyInitPlugins();
        app.start(new Runnable(){

            @Override
            public void run() {
                TGSplash.getInstance(TuxGuitar.this.context).init();
                TGSynchronizer.getInstance((TGContext)TuxGuitar.this.context).executeLater(new Runnable(){

                    @Override
                    public void run() {
                        TuxGuitar.this.startUIContext(url);
                        TGSplash.getInstance(TuxGuitar.this.context).finish();
                    }
                });
            }
        });
    }

    private void startUIContext(URL url) {
        TGWindow.getInstance(this.context).createWindow();
        this.initMidiPlayer();
        this.getEditorManager().setLockControl(this.lock);
        this.getActionAdapterManager().initialize();
        this.getPluginManager().connectEnabled();
        this.restoreControlsConfig();
        this.restorePlayerConfig();
        TGWindow.getInstance(this.context).open();
        this.startSong(url);
        this.setInitialized(true);
    }

    private void startSong(URL url) {
        TGDocumentListManager.getInstance(this.context).findCurrentDocument().setUnwanted(true);
        if (url != null) {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.url.read");
            tgActionProcessor.setAttribute(TGReadURLAction.ATTRIBUTE_URL, (Object)url);
            tgActionProcessor.setAttribute(TGErrorHandler.class.getName(), (Object)new TGErrorHandler(){

                public void handleError(Throwable throwable) {
                    TuxGuitar.this.startDefaultSong();
                    TGErrorManager.getInstance((TGContext)TuxGuitar.this.getContext()).handleError(throwable);
                }
            });
            tgActionProcessor.process();
        } else {
            this.startDefaultSong();
        }
    }

    private void startDefaultSong() {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.song.new");
        tgActionProcessor.setAttribute("unwanted", (Object)true);
        tgActionProcessor.process();
    }

    public void restoreControlsConfig() {
        TGConfigManager config = this.getConfig();
        if (config.getBooleanValue("show.instruments")) {
            new TGActionProcessor(this.context, "action.gui.toggle-channels-dialog").process();
        }
        if (config.getBooleanValue("show.transport")) {
            new TGActionProcessor(this.context, "action.gui.toggle-transport-dialog").process();
        }
        if (config.getBooleanValue("show.matrix")) {
            new TGActionProcessor(this.context, "action.gui.toggle-matrix-editor").process();
        }
        if (config.getBooleanValue("show.piano")) {
            new TGActionProcessor(this.context, "action.gui.toggle-piano-editor").process();
        }
        if (config.getBooleanValue("show.markers")) {
            new TGActionProcessor(this.context, "action.gui.toggle-marker-list").process();
        }
    }

    public TGTableViewer getTable() {
        return TGTableViewer.getInstance(this.context);
    }

    public TablatureEditor getTablatureEditor() {
        return TablatureEditor.getInstance(this.context);
    }

    public TGFretBoardEditor getFretBoardEditor() {
        return TGFretBoardEditor.getInstance(this.context);
    }

    public TGPianoEditor getPianoEditor() {
        return TGPianoEditor.getInstance(this.context);
    }

    public TGMatrixEditor getMatrixEditor() {
        return TGMatrixEditor.getInstance(this.context);
    }

    public TGChannelManagerDialog getChannelManager() {
        return TGChannelManagerDialog.getInstance(this.context);
    }

    public TGEditorManager getEditorManager() {
        return TGEditorManager.getInstance((TGContext)this.context);
    }

    public TGLyricEditor getLyricEditor() {
        return TGLyricEditor.getInstance(this.context);
    }

    public TGBrowserDialog getBrowser() {
        return TGBrowserDialog.getInstance(this.context);
    }

    public TGUndoableManager getUndoableManager() {
        return TGUndoableManager.getInstance((TGContext)this.context);
    }

    public ScaleManager getScaleManager() {
        return ScaleManager.getInstance(this.context);
    }

    public TuningManager getTuningManager() {
        return TuningManager.getInstance((TGContext)this.context);
    }

    public TGSongManager getSongManager() {
        return this.getDocumentManager().getSongManager();
    }

    public TGDocumentManager getDocumentManager() {
        return TGDocumentManager.getInstance((TGContext)this.context);
    }

    public TGPluginManager getPluginManager() {
        return TGPluginManager.getInstance((TGContext)this.context);
    }

    public TGErrorManager getErrorManager() {
        return TGErrorManager.getInstance((TGContext)this.context);
    }

    public TGEventManager getEventManager() {
        return TGEventManager.getInstance((TGContext)this.context);
    }

    public TGPropertiesManager getPropertiesManager() {
        return TGPropertiesManager.getInstance((TGContext)this.context);
    }

    public TGConfigManager getConfig() {
        return TGConfigManager.getInstance(this.context);
    }

    public TGFileFormatManager getFileFormatManager() {
        return TGFileFormatManager.getInstance((TGContext)this.context);
    }

    public TGIconManager getIconManager() {
        return TGIconManager.getInstance(this.context);
    }

    public TGSkinManager getSkinManager() {
        return TGSkinManager.getInstance(this.context);
    }

    public TGCustomChordManager getCustomChordManager() {
        if (this.customChordManager == null) {
            this.customChordManager = new TGCustomChordManager();
        }
        return this.customChordManager;
    }

    public TGMenuManager getItemManager() {
        if (this.itemManager == null) {
            this.itemManager = new TGMenuManager(this.context);
        }
        return this.itemManager;
    }

    public TGActionAdapterManager getActionAdapterManager() {
        return TGActionAdapterManager.getInstance(this.context);
    }

    public TGActionManager getActionManager() {
        return TGActionManager.getInstance((TGContext)this.context);
    }

    public TGLanguageManager getLanguageManager() {
        if (this.languageManager == null) {
            this.languageManager = new TGLanguageManager(this.context);
            this.languageManager.setLanguage(this.getConfig().getStringValue("language"));
        }
        return this.languageManager;
    }

    public KeyBindingActionManager getKeyBindingManager() {
        return KeyBindingActionManager.getInstance(this.context);
    }

    public MidiPlayer getPlayer() {
        return MidiPlayer.getInstance((TGContext)this.context);
    }

    public void initMidiPlayer() {
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)this.context);
        midiPlayer.addListener((TGEventListener)new TGTransportListener(this.context));
        try {
            this.getPlayer().addSequencerProvider((MidiSequencerProvider)new MidiSequencerProviderImpl(this.context), false);
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
    }

    public void restorePlayerConfig() {
        this.getPlayer().setTryOpenFistDevice(true);
        this.getPlayer().openSequencer(this.getConfig().getStringValue("midi.sequencer"), true);
        this.getPlayer().openOutputPort(this.getConfig().getStringValue("midi.port"), true);
    }

    public void updateCache(boolean updateItems) {
        this.updateCache(updateItems, null);
    }

    public void updateCache(boolean updateItems, TGAbstractContext sourceContext) {
        TGEditorManager editorManager = TGEditorManager.getInstance((TGContext)this.context);
        if (updateItems) {
            editorManager.updateSelection(sourceContext);
        }
        editorManager.redraw(sourceContext);
    }

    public static String getProperty(String key) {
        return TGMessagesManager.getProperty((String)key);
    }

    public static String getProperty(String key, String[] arguments) {
        return TGMessagesManager.getProperty((String)key, (Object[])arguments);
    }

    public boolean isDisposed() {
        return TGApplication.getInstance(this.context).isDisposed() || TGWindow.getInstance(this.context).isDisposed();
    }

    public void playBeat(final TGBeat beat) {
        TGEditorManager.getInstance((TGContext)this.context).asyncRunLocked(new Runnable(){

            @Override
            public void run() throws TGException {
                if (!TuxGuitar.this.isDisposed() && !TuxGuitar.this.getPlayer().isRunning()) {
                    TuxGuitar.this.getPlayer().playBeat(beat);
                }
            }
        });
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public TGContext getContext() {
        return this.context;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }
}

