/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.impl.edit;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.view.component.tab.Selector;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.editor.clipboard.TGClipboard;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.helpers.TGStoredBeatList;
import app.tuxguitar.song.managers.TGMeasureManager;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.managers.TGTrackManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGBeatRange;
import app.tuxguitar.util.TGContext;
import java.util.List;

public class TGPasteAction
extends TGActionBase {
    public static final String NAME = "action.edit.paste";

    public TGPasteAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext tgActionContext) {
        TGClipboard clipboard = TGClipboard.getInstance((TGContext)this.getContext());
        TGStoredBeatList beatList = TGClipboard.getInstance((TGContext)this.getContext()).getBeats();
        if (clipboard.getSegment() != null) {
            TGActionManager.getInstance((TGContext)this.getContext()).execute("action.gui.open-measure-paste-dialog", tgActionContext);
        } else if (beatList != null && beatList.getBeats().size() > 0) {
            TGFactory factory = this.getSongManager(tgActionContext).getFactory();
            TGSongManager songManager = this.getSongManager(tgActionContext);
            TGTrackManager trackManager = songManager.getTrackManager();
            TGBeat beat = (TGBeat)tgActionContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
            TGBeatRange beatRange = (TGBeatRange)tgActionContext.getAttribute("beat-range");
            TGTrack destTrack = (TGTrack)tgActionContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
            TGBeat destinationBeat = beat;
            if (beatRange != null && !beatRange.isEmpty()) {
                destinationBeat = (TGBeat)beatRange.getBeats().get(0);
            }
            if (beatList.isPercussionTrack() == destTrack.isPercussion()) {
                TGStoredBeatList beatsListToPaste = beatList.clone(factory);
                trackManager.allocateNotesToStrings(beatsListToPaste.getStringValues(), beatsListToPaste.getBeats(), destTrack.getStrings(), destTrack.getMaxFret());
                List newBeats = trackManager.replaceBeats(destTrack, beatsListToPaste.getBeats(), destinationBeat.getPreciseStart().longValue());
                if (beatsListToPaste.getBeats().size() > newBeats.size()) {
                    TGMeasureManager measureManager = songManager.getMeasureManager();
                    TGSong song = (TGSong)tgActionContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
                    TGMeasureHeader newHeader = songManager.addNewMeasureBeforeEnd(song);
                    TGMeasure newMeasure = destTrack.getMeasure(newHeader.getNumber() - 1);
                    long beatPreciseStart = newHeader.getPreciseStart();
                    for (int i = newBeats.size(); i < beatsListToPaste.getBeats().size(); ++i) {
                        TGBeat beatToInsert = (TGBeat)beatsListToPaste.getBeats().get(i);
                        beatToInsert.setPreciseStart(beatPreciseStart);
                        beatPreciseStart += measureManager.getMinimumDuration(beatToInsert).getPreciseTime();
                        measureManager.addBeat(newMeasure, beatToInsert);
                        newBeats.add(beatToInsert);
                    }
                    trackManager.moveOutOfBoundsBeatsToNewMeasure(destTrack, newHeader.getStart());
                }
                if (newBeats != null && newBeats.size() > 0) {
                    Selector selector = TablatureEditor.getInstance(this.getContext()).getTablature().getSelector();
                    selector.initializeSelection((TGBeat)newBeats.get(0));
                    selector.updateSelection((TGBeat)newBeats.get(newBeats.size() - 1));
                }
            }
        }
    }
}

