/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.impl.selector;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionManager;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.app.view.component.tab.Selector;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.song.managers.TGMeasureManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.util.TGContext;

public class TGExtendSelectionNextAction
extends TGActionBase {
    public static final String NAME = "action.selection.extend-next";

    public TGExtendSelectionNextAction(TGContext context) {
        super(context, NAME);
    }

    protected void processAction(TGActionContext context) {
        Tablature tablature = TablatureEditor.getInstance(this.getContext()).getTablature();
        Selector selector = tablature.getSelector();
        Caret caret = tablature.getCaret();
        if (!selector.isActive()) {
            selector.initializeSelection((TGBeat)caret.getSelectedBeat());
        }
        TGMeasureImpl currentMeasure = caret.getMeasure();
        TGMeasureManager measureManager = this.getSongManager(context).getMeasureManager();
        TGBeat lastBeat = measureManager.getLastBeat(currentMeasure.getBeats());
        TGBeatImpl currentBeat = caret.getSelectedBeat();
        context.setAttribute("keep-selection", (Object)true);
        TGActionManager tgActionManager = TGActionManager.getInstance((TGContext)this.getContext());
        if (currentBeat == lastBeat) {
            tgActionManager.execute("action.measure.go-next", context);
            if (caret.getSelectedBeat().getStart() >= selector.getInitialBeat().getStart()) {
                this.moveToMeasureEnd(context, caret);
            }
        } else {
            this.moveToMeasureEnd(context, caret);
            if (!this.getSongManager(context).getTrackManager().isLastMeasure((TGMeasure)caret.getMeasure()) && caret.getSelectedBeat().getStart() < selector.getInitialBeat().getStart()) {
                caret.moveRight();
            }
        }
        selector.updateSelection((TGBeat)caret.getSelectedBeat());
    }

    private void moveToMeasureEnd(TGActionContext context, Caret caret) {
        TGMeasureImpl measure = caret.getMeasure();
        TGBeat lastBeat = this.getSongManager(context).getMeasureManager().getLastBeat(measure.getBeats());
        caret.moveTo(caret.getTrack(), measure, lastBeat, caret.getSelectedString().getNumber());
    }
}

