/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.action.listener.gui;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.app.view.main.TGWindow;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.util.TGContext;

public class TGActionProcessingListener
implements TGEventListener {
    public static final String ATTRIBUTE_BY_PASS = "byPassProcessingListener";
    private TGContext context;
    private Integer level;

    public TGActionProcessingListener(TGContext context) {
        this.context = context;
        this.resetLevel();
    }

    public void resetLevel() {
        this.level = 0;
    }

    public void increaseLevel() {
        Integer n = this.level;
        this.level = this.level + 1;
    }

    public void decreaseLevel() {
        Integer n = this.level;
        this.level = this.level - 1;
    }

    public void showProcessing() {
        TGWindow.getInstance(this.context).loadBusyCursor();
    }

    public void hideProcessing() {
        TGWindow.getInstance(this.context).loadDefaultCursor();
    }

    public void updateProcessingVisibility(boolean processing) {
        if (processing) {
            this.showProcessing();
        } else {
            this.hideProcessing();
        }
    }

    public boolean isByPassProcessing(TGEvent event) {
        TGActionContext actionContext = (TGActionContext)event.getAttribute("sourceContext");
        return Boolean.TRUE.equals(actionContext.getAttribute(ATTRIBUTE_BY_PASS));
    }

    public void processEvent(boolean processing) {
        if (this.level == 0) {
            this.updateProcessingVisibility(processing);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processEvent(TGEvent event) {
        if (this.isByPassProcessing(event)) return;
        Class<TGActionProcessingListener> clazz = TGActionProcessingListener.class;
        synchronized (TGActionProcessingListener.class) {
            if ("action-pre-execution".equals(event.getEventType())) {
                this.processEvent(true);
                this.increaseLevel();
            } else if ("action-post-execution".equals(event.getEventType())) {
                this.decreaseLevel();
                this.processEvent(false);
            } else {
                if (!"action-error".equals(event.getEventType())) return;
                this.decreaseLevel();
                this.processEvent(false);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

