/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.editor;

import app.tuxguitar.app.editor.TGExternalBeatViewerEvent;
import app.tuxguitar.editor.TGEditorManager;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.event.TGEventManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.util.TGAbstractContext;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;

public class TGExternalBeatViewerManager {
    private TGContext context;

    public TGExternalBeatViewerManager(TGContext context) {
        this.context = context;
    }

    public void showExternalBeat(TGBeat beat) {
        this.showExternalBeat(beat, null);
    }

    public void showExternalBeat(final TGBeat beat, final TGAbstractContext context) {
        this.asyncRunLocked(new Runnable(){

            @Override
            public void run() {
                TGExternalBeatViewerManager.this.doShowExternalBeat(beat, context);
            }
        });
    }

    public void hideExternalBeat() {
        this.hideExternalBeat(null);
    }

    public void hideExternalBeat(final TGAbstractContext context) {
        this.asyncRunLocked(new Runnable(){

            @Override
            public void run() {
                TGExternalBeatViewerManager.this.doHideExternalBeat(context);
            }
        });
    }

    public void addBeatViewerListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("ui-external-beat-viewer", listener);
    }

    public void removeBeatViewerListener(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("ui-external-beat-viewer", listener);
    }

    private void doShowExternalBeat(TGBeat beat, TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGExternalBeatViewerEvent("show", beat, context));
    }

    private void doHideExternalBeat(TGAbstractContext context) {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGExternalBeatViewerEvent("hide", context));
    }

    public void asyncRunLocked(Runnable runnable) {
        TGEditorManager.getInstance((TGContext)this.context).asyncRunLocked(runnable);
    }

    public static TGExternalBeatViewerManager getInstance(TGContext context) {
        return (TGExternalBeatViewerManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGExternalBeatViewerManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGExternalBeatViewerManager>(){

            public TGExternalBeatViewerManager createInstance(TGContext context) {
                return new TGExternalBeatViewerManager(context);
            }
        });
    }
}

