/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.system.config;

import app.tuxguitar.app.system.config.TGConfigDefaults;
import app.tuxguitar.app.system.properties.TGPropertiesUIUtil;
import app.tuxguitar.ui.resource.UIColorModel;
import app.tuxguitar.ui.resource.UIFontModel;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGVersion;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.List;

public class TGConfigManager
extends app.tuxguitar.util.configuration.TGConfigManager {
    public static final String CONFIGURATION_MODULE = "tuxguitar";

    private TGConfigManager(TGContext context, List<String> validKeys) {
        super(context, CONFIGURATION_MODULE, validKeys);
    }

    public void setValue(String key, UIColorModel model) {
        TGPropertiesUIUtil.setValue(this.getProperties(), key, model);
    }

    public void setValue(String key, UIFontModel fm) {
        TGPropertiesUIUtil.setValue(this.getProperties(), key, fm);
    }

    public UIFontModel getFontModelConfigValue(String key) {
        return TGPropertiesUIUtil.getFontModelValue(this.getProperties(), key);
    }

    public UIColorModel getColorModelConfigValue(String key) {
        return TGPropertiesUIUtil.getColorModelValue(this.getContext(), this.getProperties(), key);
    }

    public void save() {
        this.setValue("config.app.version", TGVersion.CURRENT.toString());
        super.save();
    }

    public void load() {
        super.load();
        TGVersion configAppVersion = new TGVersion(this.getStringValue("config.app.version"));
        if (configAppVersion.compareTo(new TGVersion(1, 6, 3)) < 0) {
            int style = this.getIntegerValue("layout.style");
            this.getProperties().setValue("layout.style", String.valueOf(style |= 0x80));
        }
    }

    public static TGConfigManager getInstance(TGContext context) {
        return (TGConfigManager)((Object)TGSingletonUtil.getInstance((TGContext)context, (String)TGConfigManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGConfigManager>(){

            public TGConfigManager createInstance(TGContext context) {
                return new TGConfigManager(context, TGConfigDefaults.getKeys());
            }
        }));
    }
}

