/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.tab;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.document.TGDocument;
import app.tuxguitar.app.document.TGDocumentListManager;
import app.tuxguitar.app.util.MidiTickUtil;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.graphics.control.TGTrackImpl;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.song.managers.TGMeasureManager;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIColorModel;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UIResource;
import app.tuxguitar.util.TGContext;
import java.util.List;

public class Caret {
    private Tablature tablature;
    private TGTrackImpl selectedTrack;
    private TGMeasureImpl selectedMeasure;
    private TGBeat selectedBeat;
    private TGVoice selectedVoice;
    private TGNote selectedNote;
    private TGDuration selectedDuration;
    private TGString selectedString;
    private long position;
    private int string;
    private int voice;
    private int velocity;
    private boolean restBeat;
    private boolean changes;
    private UIColor colorCurrentVoice;
    private UIColor colorOtherVoice;
    private int alpha;

    public Caret(Tablature tablature) {
        this.tablature = tablature;
        this.selectedDuration = this.getSongManager().getFactory().newDuration();
        this.string = 1;
        this.velocity = 95;
        this.changes = false;
    }

    public synchronized void update() {
        int trackNumber = this.selectedTrack != null ? this.selectedTrack.getNumber() : 1;
        this.update(trackNumber, this.position, this.string);
    }

    public synchronized void update(int trackNumber) {
        this.update(trackNumber, this.position, this.string);
    }

    public synchronized void update(int trackNumber, long position, int string) {
        this.update(trackNumber, position, string, this.getVelocity());
    }

    public synchronized void update(int trackNumber, long position, int string, int velocity) {
        TGContext context = this.tablature.getContext();
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)context);
        long realPosition = midiPlayer.isRunning() ? MidiTickUtil.getStart(context, midiPlayer.getTickPosition()) : position;
        TGTrackImpl track = this.findTrack(trackNumber);
        TGMeasureImpl measure = null;
        measure = this.selectedMeasure != null && this.getSongManager().isFreeEditionMode((TGMeasure)this.selectedMeasure) && this.selectedMeasure.getTrack().getNumber() == this.selectedTrack.getNumber() && this.selectedMeasure.getNumber() <= track.countMeasures() ? this.selectedMeasure : this.findMeasure(realPosition, track);
        TGBeat beat = this.findBeat(realPosition, measure);
        if (track != null && measure != null && beat != null) {
            this.moveTo(track, measure, beat, string);
        }
        this.setVelocity(velocity);
    }

    public void moveTo(TGTrackImpl selectedTrack, TGMeasureImpl selectedMeasure, TGBeat selectedBeat, int string) {
        this.selectedTrack = selectedTrack;
        this.selectedMeasure = selectedMeasure;
        this.selectedBeat = selectedBeat;
        this.string = string;
        this.updatePosition();
        this.updateDuration();
        this.updateString();
        this.updateNote();
        this.updateVoice();
        this.updateBeat();
        this.setChanges(true);
        this.saveState();
    }

    private TGTrackImpl findTrack(int number) {
        TGTrackImpl track = (TGTrackImpl)this.getSongManager().getTrack(this.getSong(), number);
        if (track == null) {
            track = (TGTrackImpl)this.getSongManager().getFirstTrack(this.getSong());
        }
        return track;
    }

    private TGMeasureImpl findMeasure(long position, TGTrackImpl track) {
        TGMeasureImpl measure = null;
        if (track != null && (measure = (TGMeasureImpl)this.getSongManager().getTrackManager().getMeasureAt((TGTrack)track, position)) == null) {
            measure = (TGMeasureImpl)this.getSongManager().getTrackManager().getFirstMeasure((TGTrack)track);
        }
        return measure;
    }

    private TGBeat findBeat(long position, TGMeasureImpl measure) {
        TGBeat beat = null;
        if (measure != null) {
            TGMeasureManager manager = this.getSongManager().getMeasureManager();
            TGVoice voice = manager.getVoiceIn((TGMeasure)measure, position, this.getVoice());
            if (voice != null) {
                beat = voice.getBeat();
            }
            if (beat == null) {
                beat = manager.getFirstBeat(measure.getBeats());
            }
        }
        return beat;
    }

    public synchronized void goToTickPosition() {
        TGContext context = this.tablature.getContext();
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)context);
        long start = MidiTickUtil.getStart(context, midiPlayer.getTickPosition());
        this.update(this.selectedTrack.getNumber(), start, this.string);
        this.setChanges(true);
    }

    public void paintCaret(TGLayout layout, UIPainter painter) {
        if (!TuxGuitar.getInstance().getPlayer().isRunning() && this.selectedMeasure != null && !this.selectedMeasure.isOutOfBounds() && this.selectedBeat instanceof TGBeatImpl) {
            TGBeatImpl beat = (TGBeatImpl)this.selectedBeat;
            if ((layout.getStyle() & 8) != 0) {
                boolean expectedVoice = this.getSelectedNote() == null || this.getSelectedNote().getVoice().getIndex() == this.getVoice();
                float stringSpacing = this.tablature.getViewLayout().getStringSpacing();
                float leftSpacing = beat.getMeasureImpl().getHeaderImpl().getLeftSpacing(layout);
                float width = (stringSpacing - 3.0f * layout.getScale()) * 2.0f;
                float height = (stringSpacing - 3.0f * layout.getScale()) * 2.0f;
                float xMargin = width / 2.0f - 2.0f * layout.getScale();
                float yMargin = height / 2.0f;
                float x = this.selectedMeasure.getPosX() + beat.getPosX() + beat.getSpacing(layout) + leftSpacing - xMargin;
                float y = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(15) + ((float)this.string * stringSpacing - stringSpacing) - yMargin;
                this.setPaintStyle(painter, expectedVoice);
                painter.setAntialias(false);
                for (int style : new int[]{2, 1}) {
                    painter.initPath(style);
                    painter.setAlpha(style == 2 ? this.alpha : 255);
                    painter.addRoundedRectangle(x, y, width, height, 2.0f);
                    painter.closePath();
                }
            } else if ((layout.getStyle() & 4) != 0) {
                float line = this.tablature.getViewLayout().getScoreLineSpacing();
                float leftSpacing = beat.getMeasureImpl().getHeaderImpl().getLeftSpacing(layout);
                float xMargin = 2.0f * layout.getScale();
                float x1 = this.selectedMeasure.getPosX() + beat.getPosX() + beat.getSpacing(layout) + leftSpacing - xMargin;
                float x2 = x1 + layout.getScoreNoteWidth() + xMargin;
                float y1 = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(0) - line;
                float y2 = this.selectedMeasure.getPosY() + this.selectedMeasure.getTs().getPosition(17);
                this.setPaintStyle(painter, true);
                painter.initPath();
                painter.moveTo(x1, y1);
                painter.lineTo(x1 + (x2 - x1) / 2.0f, y1 + line / 2.0f);
                painter.lineTo(x2, y1);
                painter.moveTo(x1, y2 + line);
                painter.lineTo(x1 + (x2 - x1) / 2.0f, y2 + line / 2.0f);
                painter.lineTo(x2, y2 + line);
                painter.closePath();
            }
        }
    }

    public void setPaintStyle(UIPainter painter, boolean expectedVoice) {
        UIColor color;
        UIColor uIColor = color = expectedVoice ? this.colorCurrentVoice : this.colorOtherVoice;
        if (color != null) {
            painter.setForeground(color);
            painter.setBackground(color);
        }
    }

    public boolean moveRight() {
        if (this.getSelectedBeat() != null) {
            TGBeat beat;
            TGMeasureImpl measure = this.getMeasure();
            TGVoice voice = this.getSongManager().getMeasureManager().getNextVoice(measure.getBeats(), (TGBeat)this.getSelectedBeat(), this.getVoice());
            TGBeat tGBeat = beat = voice != null ? voice.getBeat() : null;
            if (beat == null) {
                measure = (TGMeasureImpl)this.getSongManager().getTrackManager().getNextMeasure((TGMeasure)this.getMeasure());
                if (measure == null) {
                    return false;
                }
                voice = this.getSongManager().getMeasureManager().getFirstVoice(measure.getBeats(), this.getVoice());
                TGBeat tGBeat2 = beat = voice != null ? voice.getBeat() : null;
                if (beat == null) {
                    beat = this.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
                }
            }
            if (beat != null) {
                this.moveTo(this.getTrack(), measure, beat, this.getStringNumber());
            }
        }
        return true;
    }

    public void moveLeft() {
        if (this.getSelectedBeat() != null) {
            TGBeat beat;
            TGMeasureImpl measure = this.getMeasure();
            TGVoice voice = this.getSongManager().getMeasureManager().getPreviousVoice(measure.getBeats(), (TGBeat)this.getSelectedBeat(), this.getVoice());
            TGBeat tGBeat = beat = voice != null ? voice.getBeat() : null;
            if (beat == null) {
                measure = (TGMeasureImpl)this.getSongManager().getTrackManager().getPrevMeasure((TGMeasure)this.getMeasure());
                if (measure == null) {
                    return;
                }
                voice = this.getSongManager().getMeasureManager().getLastVoice(measure.getBeats(), this.getVoice());
                TGBeat tGBeat2 = beat = voice != null ? voice.getBeat() : null;
                if (beat == null) {
                    beat = this.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
                }
            }
            if (beat != null) {
                this.moveTo(this.getTrack(), measure, beat, this.getStringNumber());
            }
        }
    }

    private void updateDuration() {
        if (this.selectedBeat != null) {
            this.selectedDuration.copyFrom(this.selectedBeat.getVoice(this.getVoice()).getDuration());
        }
    }

    public void moveUp() {
        int stringCount = this.selectedTrack.stringCount();
        int nextString = (this.string - 2 + stringCount) % stringCount + 1;
        this.setStringNumber(nextString);
    }

    public void moveDown() {
        int stringCount = this.selectedTrack.stringCount();
        int nextString = this.string % stringCount + 1;
        this.setStringNumber(nextString);
    }

    public void setStringNumber(int number) {
        this.string = number;
        this.updateNote();
        this.saveState();
    }

    public int getStringNumber() {
        return this.string;
    }

    public long getPosition() {
        return this.position;
    }

    public TGMeasureImpl getMeasure() {
        return this.selectedMeasure;
    }

    public TGTrackImpl getTrack() {
        return this.selectedTrack;
    }

    public TGDuration getDuration() {
        return this.selectedDuration;
    }

    public void setSelectedDuration(TGDuration selectedDuration) {
        this.selectedDuration = selectedDuration;
    }

    public TGString getSelectedString() {
        return this.selectedString;
    }

    private void updatePosition() {
        this.position = this.getSelectedBeat().getStart();
    }

    private void updateString() {
        if (this.string < 1 || this.string > this.getTrack().stringCount()) {
            this.string = 1;
        }
        List strings = this.getTrack().getStrings();
        for (TGString instrumentString : strings) {
            if (instrumentString.getNumber() != this.string) continue;
            this.selectedString = instrumentString;
        }
    }

    public boolean hasChanges() {
        return this.changes;
    }

    public void setChanges(boolean changes) {
        this.changes = changes;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    private void updateNote() {
        this.selectedNote = null;
        TGString string = this.getSelectedString();
        if (string != null) {
            this.selectedNote = this.getSongManager().getMeasureManager().getNote((TGMeasure)this.getMeasure(), this.getPosition(), string.getNumber());
        }
    }

    public TGNote getSelectedNote() {
        return this.selectedNote;
    }

    private void updateBeat() {
        this.restBeat = this.selectedBeat.isRestBeat();
    }

    public TGBeatImpl getSelectedBeat() {
        return (TGBeatImpl)this.selectedBeat;
    }

    public TGSongManager getSongManager() {
        return this.tablature.getSongManager();
    }

    public TGSong getSong() {
        return this.tablature.getSong();
    }

    private void updateVoice() {
        this.selectedVoice = this.getSelectedBeat().getVoice(this.getVoice());
    }

    public TGVoice getSelectedVoice() {
        return this.selectedVoice;
    }

    public int getVoice() {
        return this.voice;
    }

    public void setVoice(int voice) {
        this.voice = voice;
        this.update();
    }

    public boolean isRestBeatSelected() {
        return this.restBeat;
    }

    public void setColorCurrentVoice(UIColorModel cm) {
        this.disposeResource((UIResource)this.colorCurrentVoice);
        this.colorCurrentVoice = this.tablature.getResourceFactory().createColor(cm);
    }

    public void setColorOtherVoice(UIColorModel cm) {
        this.disposeResource((UIResource)this.colorOtherVoice);
        this.colorOtherVoice = this.tablature.getResourceFactory().createColor(cm);
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    private void saveState() {
        TGDocument document = TGDocumentListManager.getInstance(this.tablature.getContext()).findDocument(this.selectedTrack.getSong());
        document.setCaretBeat((TGBeat)this.getSelectedBeat());
        document.setCaretString(this.getStringNumber());
    }

    public void restoreStateFrom(TGDocument document) {
        TGBeat beat = document.getCaretBeat();
        int stringNb = document.getCaretString();
        if (beat != null && stringNb != 0) {
            TGMeasureImpl measure = (TGMeasureImpl)beat.getMeasure();
            this.moveTo((TGTrackImpl)measure.getTrack(), measure, beat, stringNb);
        } else {
            TGTrackImpl track = this.findTrack(1);
            this.selectedMeasure = (TGMeasureImpl)track.getMeasure(0);
            this.update(1, 960L, 1);
        }
    }

    public void disposeResource(UIResource resource) {
        if (resource != null && !resource.isDisposed()) {
            resource.dispose();
        }
    }

    public void dispose() {
        this.disposeResource((UIResource)this.colorCurrentVoice);
        this.disposeResource((UIResource)this.colorOtherVoice);
    }
}

