/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.tab;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.document.TGDocumentManager;
import app.tuxguitar.editor.TGEditorManager;
import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.ui.event.UIMenuHideListener;
import app.tuxguitar.ui.event.UIMenuShowListener;
import app.tuxguitar.ui.menu.UIPopupMenu;
import app.tuxguitar.util.TGAbstractContext;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.List;

public class TablatureEditor
implements TGEventListener {
    private TGContext context;
    private Tablature tablature;

    public TablatureEditor(TGContext context) {
        this.context = context;
        this.initialize();
    }

    public void initialize() {
        this.tablature = new Tablature(this.context, TGDocumentManager.getInstance((TGContext)this.context));
        this.tablature.reloadViewLayout();
        this.tablature.updateTablature();
        this.tablature.resetCaret();
        this.initListener();
        this.initMenu();
    }

    private void initListener() {
        TGEditorManager.getInstance((TGContext)this.context).addUpdateListener((TGEventListener)this);
    }

    private void initMenu() {
        UIPopupMenu uiPopupMenu = TuxGuitar.getInstance().getItemManager().getPopupMenu();
        uiPopupMenu.addMenuShowListener((UIMenuShowListener)this.getTablature().getEditorKit().getMouseKit());
        uiPopupMenu.addMenuHideListener((UIMenuHideListener)this.getTablature().getEditorKit().getMouseKit());
    }

    public void reloadConfig() {
        this.getTablature().reloadStyles();
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public void processUpdateEvent(TGEvent event) {
        int type = (Integer)event.getAttribute("updateMode");
        if (type == 2) {
            Boolean updateCaret = true;
            TGAbstractContext eventContext = (TGAbstractContext)event.getAttribute("sourceContext");
            if (eventContext != null) {
                updateCaret = !Boolean.FALSE.equals(eventContext.getAttribute("updateMeasuresUpdateCaret"));
            }
            this.getTablature().updateMeasures((List)event.getAttribute("measureNumbers"), updateCaret);
        } else if (type == 3) {
            this.getTablature().updateTablature();
        } else if (type == 4) {
            this.getTablature().updateTablature();
        }
    }

    public void processEvent(TGEvent event) {
        if ("ui-update".equals(event.getEventType())) {
            this.processUpdateEvent(event);
        }
    }

    public static TablatureEditor getInstance(TGContext context) {
        return (TablatureEditor)TGSingletonUtil.getInstance((TGContext)context, (String)TablatureEditor.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TablatureEditor>(){

            public TablatureEditor createInstance(TGContext context) {
                return new TablatureEditor(context);
            }
        });
    }
}

