/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.tab.edit;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.component.tab.Caret;
import app.tuxguitar.app.view.component.tab.Tablature;
import app.tuxguitar.app.view.component.tab.edit.MouseKit;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.graphics.control.TGNoteImpl;
import app.tuxguitar.graphics.control.TGTrackImpl;
import app.tuxguitar.graphics.control.TGVoiceImpl;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.util.TGAbstractContext;
import app.tuxguitar.util.TGMusicKeyUtils;
import java.util.ArrayList;
import java.util.Iterator;

public class EditorKit {
    public static final String ATTRIBUTE_X = "editorKit-x";
    public static final String ATTRIBUTE_Y = "editorKit-y";
    public static final int MOUSE_MODE_SELECTION = 1;
    public static final int MOUSE_MODE_EDITION = 2;
    private static final int[] FIRST_LINE_NOTE_INDEX = new int[]{3, 5, 2, 4};
    private static final int[] FIRST_LINE_NOTE_OCTAVE = new int[]{4, 2, 3, 3};
    private int mouseMode;
    private boolean natural;
    private Tablature tablature;
    private MouseKit mouseKit;
    private TGMeasureImpl selectedMeasure;

    public EditorKit(Tablature tablature) {
        this.tablature = tablature;
        this.mouseKit = new MouseKit(this);
        this.setDefaults();
    }

    private void setDefaults() {
        this.setMouseMode(TuxGuitar.getInstance().getConfig().getIntegerValue("editor.mouse.mode", 2));
        this.setNatural(TuxGuitar.getInstance().getConfig().getBooleanValue("editor.natural.key.mode", true));
    }

    public int getMouseMode() {
        return this.mouseMode;
    }

    public void setMouseMode(int mouseMode) {
        this.mouseMode = mouseMode;
    }

    public boolean isNatural() {
        return this.natural;
    }

    public void setNatural(boolean natural) {
        this.natural = natural;
    }

    public Tablature getTablature() {
        return this.tablature;
    }

    public MouseKit getMouseKit() {
        return this.mouseKit;
    }

    public boolean isScoreEnabled() {
        return (this.getTablature().getViewLayout().getStyle() & 4) != 0;
    }

    public boolean isMouseEditionAvailable() {
        return this.isScoreEnabled() && this.getMouseMode() == 2;
    }

    public boolean fillSelection(TGAbstractContext context) {
        return this.fillSelection(context, false);
    }

    public boolean fillSelection(TGAbstractContext context, boolean ignoreVoice) {
        TGBeatImpl beat;
        TGMeasureImpl measure;
        TGTrackImpl track;
        float x = ((Float)context.getAttribute(ATTRIBUTE_X)).floatValue();
        float y = ((Float)context.getAttribute(ATTRIBUTE_Y)).floatValue();
        if (x >= 0.0f && y >= 0.0f && (track = this.findSelectedTrack(y)) != null && (measure = this.findSelectedMeasure(track, x, y)) != null && (beat = this.findSelectedBeat(measure, x, ignoreVoice)) != null) {
            TGString string = this.findSelectedString(measure, y);
            if (string == null) {
                string = this.getTablature().getCaret().getSelectedString();
            }
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK, (Object)track);
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE, (Object)measure);
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)measure.getHeader());
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)beat);
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
            return true;
        }
        return false;
    }

    public boolean isMinDragWidthReached(TGAbstractContext context) {
        Float startPositionX = this.mouseKit.getStartPositionX();
        if (startPositionX != null) {
            float x = ((Float)context.getAttribute(ATTRIBUTE_X)).floatValue();
            TGLayout layout = this.getTablature().getViewLayout();
            float minDistanceX = layout.getMinimumDurationWidth() / 3.0f;
            return Math.abs(x - startPositionX.floatValue()) >= minDistanceX;
        }
        return false;
    }

    private TGTrackImpl findSelectedTrack(float y) {
        TGLayout layout = this.getTablature().getViewLayout();
        int number = layout.getTrackNumberAt(y);
        if (number >= 0) {
            return (TGTrackImpl)layout.getSongManager().getTrack(this.getTablature().getSong(), number);
        }
        return null;
    }

    private TGMeasureImpl findSelectedMeasure(TGTrackImpl track, float x, float y) {
        TGMeasureImpl measure = null;
        float minorDistance = 0.0f;
        Iterator it = track.getMeasures();
        while (it.hasNext()) {
            boolean isAtX;
            TGMeasureImpl m = (TGMeasureImpl)it.next();
            if (m.isOutOfBounds() || m.getTs() == null || !(isAtX = x >= m.getPosX() && x <= m.getPosX() + m.getWidth(this.getTablature().getViewLayout()) + m.getSpacing())) continue;
            float measureHeight = m.getTs().getSize();
            float distanceY = Math.min(Math.abs(y - m.getPosY()), Math.abs(y - (m.getPosY() + measureHeight - 10.0f)));
            if (measure != null && !(distanceY < minorDistance)) continue;
            measure = m;
            minorDistance = distanceY;
        }
        return measure;
    }

    private TGBeatImpl findSelectedBeat(TGMeasureImpl measure, float x, boolean ignoreVoice) {
        TGLayout layout = this.getTablature().getViewLayout();
        int voice = this.getTablature().getCaret().getVoice();
        float posX = measure.getHeaderImpl().getLeftSpacing(layout) + measure.getPosX();
        float bestDiff = -1.0f;
        TGBeatImpl bestBeat = null;
        for (TGBeatImpl beat : measure.getBeats()) {
            if (!ignoreVoice && beat.getVoice(voice).isEmpty()) continue;
            float diff = Math.abs(x - (posX + (beat.getPosX() + beat.getSpacing(layout))));
            if (bestDiff != -1.0f && !(diff < bestDiff)) continue;
            bestBeat = beat;
            bestDiff = diff;
        }
        if (bestBeat == null) {
            bestBeat = (TGBeatImpl)layout.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats());
        }
        return bestBeat;
    }

    private TGString findSelectedString(TGMeasureImpl measure, float y) {
        TGString string = null;
        float stringSpacing = this.getTablature().getViewLayout().getStringSpacing();
        float minorDistance = 0.0f;
        float firstStringY = measure.getPosY() + measure.getTs().getPosition(15);
        for (TGString currString : measure.getTrack().getStrings()) {
            float distanceX = Math.abs(y - (firstStringY + ((float)currString.getNumber() * stringSpacing - stringSpacing)));
            if (string != null && !(distanceX < minorDistance)) continue;
            string = currString;
            minorDistance = distanceX;
        }
        return string;
    }

    private TGString findBestString(TGTrack track, TGVoice voice, int value) {
        ArrayList<TGString> strings = new ArrayList<TGString>();
        for (int number = 1; number <= track.stringCount(); ++number) {
            boolean used = false;
            TGString string = track.getString(number);
            for (TGNote note : voice.getNotes()) {
                if (note.getString() != string.getNumber()) continue;
                used = true;
            }
            if (used) continue;
            strings.add(string);
        }
        int minFret = -1;
        TGString stringForValue = null;
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = (TGString)strings.get(i);
            int fret = value - string.getValue();
            if (fret < 0 || minFret >= 0 && fret >= minFret) continue;
            stringForValue = string;
            minFret = fret;
        }
        return stringForValue;
    }

    private TGVoiceImpl findBestVoice(TGMeasureImpl measure, float x) {
        TGBeatImpl beat2;
        TGLayout layout = this.getTablature().getViewLayout();
        int voiceIndex = this.getTablature().getCaret().getVoice();
        float posX = measure.getHeaderImpl().getLeftSpacing(layout) + measure.getPosX();
        float bestDiff = -1.0f;
        TGVoiceImpl bestVoice = null;
        TGDuration duration = this.getTablature().getCaret().getDuration();
        for (TGBeatImpl beat2 : measure.getBeats()) {
            TGVoiceImpl voice = beat2.getVoiceImpl(voiceIndex);
            if (voice.isEmpty()) continue;
            float x1 = beat2.getPosX() + beat2.getSpacing(layout);
            float x2 = x1 + voice.getWidth();
            float increment = voice.getWidth();
            if (voice.isRestVoice()) {
                increment = (float)duration.getTime() * voice.getWidth() / (float)voice.getDuration().getTime();
            }
            for (float beatX = x1; beatX < x2; beatX += increment) {
                float diff = Math.abs(x - (posX + beatX));
                if (bestDiff != -1.0f && !(diff < bestDiff)) continue;
                bestVoice = voice;
                bestDiff = diff;
            }
        }
        if (bestVoice == null && (beat2 = layout.getSongManager().getMeasureManager().getFirstBeat(measure.getBeats())) != null) {
            bestVoice = (TGVoiceImpl)beat2.getVoice(voiceIndex);
        }
        return bestVoice;
    }

    public boolean fillAddOrRemoveBeat(TGAbstractContext context) {
        float x = ((Float)context.getAttribute(ATTRIBUTE_X)).floatValue();
        float y = ((Float)context.getAttribute(ATTRIBUTE_Y)).floatValue();
        TGLayout.TrackPosition pos = this.getTablature().getViewLayout().getTrackPositionAt(y);
        if (pos != null) {
            TGTrackImpl track = this.getTablature().getCaret().getTrack();
            TGMeasureImpl measure = this.getTablature().getCaret().getMeasure();
            if (measure.getTs() != null) {
                int minValue = track.getString(track.stringCount()).getValue();
                int maxValue = track.getString(1).getValue() + track.getMaxFret();
                float lineSpacing = this.getTablature().getViewLayout().getScoreLineSpacing();
                float topHeight = measure.getTs().getPosition(8);
                float bottomHeight = measure.getTs().getPosition(15) - measure.getTs().getPosition(9);
                float yFirstLine = pos.getPosY() + measure.getTs().getPosition(8);
                float yLastLine = yFirstLine + lineSpacing * 4.0f;
                if (y >= yFirstLine - topHeight && y < yLastLine + bottomHeight) {
                    TGVoiceImpl voice;
                    int keySignature = measure.getKeySignature();
                    int noteIndexFirstLine = FIRST_LINE_NOTE_INDEX[measure.getClef() - 1];
                    int octaveFirstLine = FIRST_LINE_NOTE_OCTAVE[measure.getClef() - 1];
                    int noteIndexOffset = Math.round(2.0f * (yFirstLine - y) / lineSpacing);
                    int noteIndex = TGMusicKeyUtils.noteIndexAddInterval((int)noteIndexFirstLine, (int)noteIndexOffset);
                    int noteOctave = TGMusicKeyUtils.noteOctaveAddInterval((int)noteIndexFirstLine, (int)octaveFirstLine, (int)noteIndexOffset);
                    int noteValue = TGMusicKeyUtils.midiNote((int)noteIndex, (int)noteOctave);
                    int noteAlteration = TGMusicKeyUtils.noteIndexAlteration((int)noteIndex, (int)keySignature);
                    if (this.isNatural()) {
                        if (noteAlteration == 2) {
                            ++noteValue;
                        } else if (noteAlteration == 3) {
                            --noteValue;
                        }
                    } else if (noteAlteration == 1) {
                        noteValue = keySignature <= 7 ? ++noteValue : --noteValue;
                    }
                    if (noteValue >= minValue && noteValue <= maxValue && (voice = this.findBestVoice(measure, x)) != null) {
                        context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE, (Object)voice);
                        context.setAttribute("value", (Object)noteValue);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private long getRealStart(TGVoiceImpl voice, float x) {
        if (voice.isEmpty()) {
            return voice.getBeat().getStart();
        }
        TGLayout layout = this.getTablature().getViewLayout();
        TGMeasureImpl measure = voice.getBeatImpl().getMeasureImpl();
        long beatStart = voice.getBeat().getStart();
        float beatX = measure.getHeaderImpl().getLeftSpacing(layout) + measure.getPosX() + voice.getBeatImpl().getPosX() + voice.getBeatImpl().getSpacing(layout);
        if (x > beatX) {
            long beatLength = voice.getDuration().getTime();
            long beatEnd = beatStart + beatLength;
            return Math.min(beatStart + (long)Math.round(x - beatX) * beatLength / (long)Math.round(voice.getWidth()), beatEnd - 1L);
        }
        return beatStart;
    }

    public boolean fillRemoveNoteContext(TGAbstractContext context) {
        TGLayout layout = this.getTablature().getViewLayout();
        TGVoice voice = (TGVoice)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
        Integer value = (Integer)context.getAttribute("value");
        for (TGNoteImpl note : voice.getNotes()) {
            if (layout.getSongManager().getMeasureManager().getRealNoteValue((TGNote)note) != value.intValue()) continue;
            context.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_NOTE, (Object)note);
            return true;
        }
        return false;
    }

    public boolean fillCreateNoteContext(TGAbstractContext targetContext) {
        TGVoiceImpl voice = (TGVoiceImpl)targetContext.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
        Integer value = (Integer)targetContext.getAttribute("value");
        float x = ((Float)targetContext.getAttribute(ATTRIBUTE_X)).floatValue();
        long start = this.getRealStart(voice, x);
        Caret caret = this.getTablature().getCaret();
        TGTrackImpl track = caret.getTrack();
        TGString string = this.findBestString((TGTrack)track, (TGVoice)voice, value);
        if (string != null) {
            targetContext.setAttribute("position", (Object)start);
            targetContext.setAttribute("fret", (Object)(value - string.getValue()));
            targetContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE, (Object)voice);
            targetContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING, (Object)string);
            targetContext.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT, (Object)voice.getBeat());
            return true;
        }
        return false;
    }

    public boolean updateSelectedMeasure(TGAbstractContext context) {
        boolean selectionUpdated;
        float x = ((Float)context.getAttribute(ATTRIBUTE_X)).floatValue();
        float y = ((Float)context.getAttribute(ATTRIBUTE_Y)).floatValue();
        TGMeasureImpl previousSelection = this.selectedMeasure;
        TGTrackImpl track = this.findSelectedTrack(y);
        if (track != null) {
            this.selectedMeasure = this.findSelectedMeasure(track, x, y);
        }
        if (!(selectionUpdated = false) && this.selectedMeasure == null && previousSelection != null) {
            selectionUpdated = true;
        }
        if (!selectionUpdated && this.selectedMeasure != null && previousSelection == null) {
            selectionUpdated = true;
        }
        if (!selectionUpdated && this.selectedMeasure != null) {
            selectionUpdated = !this.selectedMeasure.equals(previousSelection);
        }
        return selectionUpdated;
    }

    public void resetSelectedMeasure() {
        this.selectedMeasure = null;
    }

    public void paintSelection(TGLayout layout, UIPainter painter) {
        TGMeasureImpl measure;
        if (!TuxGuitar.getInstance().getPlayer().isRunning() && (measure = this.selectedMeasure) != null && measure.getTs() != null && measure.getTrack().stringCount() > 0) {
            float scale = layout.getScale();
            int minValue = measure.getTrack().getString(measure.getTrack().stringCount()).getValue();
            int maxValue = measure.getTrack().getString(1).getValue() + measure.getTrack().getMaxFret();
            float lineSpacing = layout.getScoreLineSpacing();
            float width = (int)(10.0f * scale);
            float topHeight = measure.getTs().getPosition(8);
            float bottomHeight = measure.getTs().getPosition(15) - measure.getTs().getPosition(9);
            float x1 = 0.0f;
            float x2 = 0.0f;
            float yFirstLine = measure.getPosY() + measure.getTs().getPosition(8);
            float yLastLine = yFirstLine + lineSpacing * 4.0f;
            block0: for (int b = 0; b < measure.countBeats(); ++b) {
                float y;
                TGBeatImpl beat = (TGBeatImpl)measure.getBeat(b);
                if (!this.isPaintableBeat((TGBeat)beat)) continue;
                x1 = measure.getHeaderImpl().getLeftSpacing(layout) + measure.getPosX() + beat.getPosX() + beat.getSpacing(layout);
                x2 = x1 + width;
                painter.setForeground(layout.getResources().getLineColor());
                int noteIndex = FIRST_LINE_NOTE_INDEX[measure.getClef() - 1];
                int noteOctave = FIRST_LINE_NOTE_OCTAVE[measure.getClef() - 1];
                for (y = yFirstLine - lineSpacing; y >= yFirstLine - topHeight; y -= lineSpacing) {
                    noteOctave = TGMusicKeyUtils.noteOctaveAddInterval((int)noteIndex, (int)noteOctave, (int)2);
                    if (TGMusicKeyUtils.midiNote((int)(noteIndex = TGMusicKeyUtils.noteIndexAddInterval((int)noteIndex, (int)2)), (int)noteOctave) > maxValue) break;
                    painter.initPath();
                    painter.setAntialias(false);
                    painter.moveTo(x1, y);
                    painter.lineTo(x2, y);
                    painter.closePath();
                }
                noteIndex = TGMusicKeyUtils.noteIndexAddInterval((int)FIRST_LINE_NOTE_INDEX[measure.getClef() - 1], (int)-8);
                noteOctave = TGMusicKeyUtils.noteOctaveAddInterval((int)FIRST_LINE_NOTE_INDEX[measure.getClef() - 1], (int)FIRST_LINE_NOTE_OCTAVE[measure.getClef() - 1], (int)-8);
                for (y = yLastLine + lineSpacing; y <= yLastLine + bottomHeight; y += lineSpacing) {
                    noteOctave = TGMusicKeyUtils.noteOctaveAddInterval((int)noteIndex, (int)noteOctave, (int)-2);
                    if (TGMusicKeyUtils.midiNote((int)(noteIndex = TGMusicKeyUtils.noteIndexAddInterval((int)noteIndex, (int)-2)), (int)noteOctave) < minValue) continue block0;
                    painter.initPath();
                    painter.setAntialias(false);
                    painter.moveTo(x1, y);
                    painter.lineTo(x2, y);
                    painter.closePath();
                }
            }
        }
    }

    private boolean isPaintableBeat(TGBeat beat) {
        if (beat.getStart() == beat.getMeasure().getStart()) {
            return true;
        }
        return !beat.getVoice(this.getTablature().getCaret().getVoice()).isEmpty();
    }
}

