/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.component.tab.edit;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.component.tab.edit.EditorKit;
import app.tuxguitar.editor.TGEditorManager;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.player.base.MidiPlayer;
import app.tuxguitar.ui.event.UIEvent;
import app.tuxguitar.ui.event.UIMenuEvent;
import app.tuxguitar.ui.event.UIMenuHideListener;
import app.tuxguitar.ui.event.UIMenuShowListener;
import app.tuxguitar.ui.event.UIMouseDownListener;
import app.tuxguitar.ui.event.UIMouseDragListener;
import app.tuxguitar.ui.event.UIMouseEvent;
import app.tuxguitar.ui.event.UIMouseExitListener;
import app.tuxguitar.ui.event.UIMouseMoveListener;
import app.tuxguitar.ui.event.UIMouseUpListener;
import app.tuxguitar.ui.event.UIZoomEvent;
import app.tuxguitar.ui.event.UIZoomListener;
import app.tuxguitar.ui.resource.UIPosition;
import app.tuxguitar.util.TGContext;

public class MouseKit
implements UIMouseDownListener,
UIMouseUpListener,
UIMouseDragListener,
UIMouseMoveListener,
UIMouseExitListener,
UIMenuShowListener,
UIMenuHideListener,
UIZoomListener {
    private EditorKit kit;
    private UIPosition position;
    private UIPosition startPosition;
    private boolean menuOpen;

    public MouseKit(EditorKit kit) {
        this.kit = kit;
        this.position = new UIPosition(0.0f, 0.0f);
        this.menuOpen = false;
    }

    public Float getStartPositionX() {
        return this.startPosition == null ? null : Float.valueOf(this.startPosition.getX());
    }

    public boolean isBusy() {
        TGContext context = this.kit.getTablature().getContext();
        return TGEditorManager.getInstance((TGContext)context).isLocked() || MidiPlayer.getInstance((TGContext)context).isRunning();
    }

    public void executeAction(String actionId, UIPosition position, UIEvent event, boolean byPassProcessing) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.kit.getTablature().getContext(), actionId);
        tgActionProcessor.setAttribute("editorKit-x", (Object)Float.valueOf(position.getX()));
        tgActionProcessor.setAttribute("editorKit-y", (Object)Float.valueOf(position.getY()));
        tgActionProcessor.setAttribute("byPassProcessingListener", (Object)byPassProcessing);
        tgActionProcessor.process();
    }

    public void onMouseDown(UIMouseEvent event) {
        if (event.getButton() == 1) {
            this.position.set(event.getPosition());
            this.startPosition = this.position.clone();
            if (event.isShiftDown().booleanValue()) {
                this.executeAction("action.selection.update-drag", this.position.clone(), (UIEvent)event, false);
            } else {
                this.executeAction("action.selection.start-drag", this.position.clone(), (UIEvent)event, false);
            }
        }
    }

    public void onMouseUp(UIMouseEvent event) {
        if (event.getButton() == 1) {
            this.startPosition = null;
            this.executeAction("action.edit.tablature.mouse-click", this.position.clone(), (UIEvent)event, false);
        }
    }

    public void onMouseDrag(UIMouseEvent event) {
        if (this.startPosition != null) {
            this.position.set(this.startPosition);
            this.position.add(event.getPosition());
            this.executeAction("action.selection.update-drag", this.position.clone(), (UIEvent)event, false);
        }
    }

    public void onMouseMove(UIMouseEvent event) {
        if (!this.menuOpen && this.kit.isMouseEditionAvailable() && !this.isBusy()) {
            this.executeAction("action.edit.tablature.mouse-move", event.getPosition().clone(), (UIEvent)event, true);
        }
    }

    public void onMouseExit(UIMouseEvent event) {
        if (!this.menuOpen && this.kit.isMouseEditionAvailable()) {
            this.executeAction("action.edit.tablature.mouse-exit", event.getPosition().clone(), (UIEvent)event, true);
        }
    }

    public void onMenuShow(UIMenuEvent event) {
        this.menuOpen = true;
    }

    public void onMenuHide(UIMenuEvent event) {
        this.menuOpen = false;
        TuxGuitar.getInstance().updateCache(true);
    }

    public void onZoom(UIZoomEvent event) {
        if (event.getValue() > 0) {
            new TGActionProcessor(this.kit.getTablature().getContext(), "action.view.layout-increment-scale").process();
        } else {
            new TGActionProcessor(this.kit.getTablature().getContext(), "action.view.layout-decrement-scale").process();
        }
    }
}

