/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.chord;

import app.tuxguitar.app.view.dialog.chord.TGChordDatabase;
import app.tuxguitar.app.view.dialog.chord.TGChordDialog;
import app.tuxguitar.app.view.dialog.chord.TGChordNamingConvention;
import app.tuxguitar.app.view.dialog.chord.TGChordSettings;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIListBoxSelect;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISelectItem;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGException;
import app.tuxguitar.util.TGSynchronizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TGChordRecognizer {
    public static final int TONIC_INDEX = 0;
    public static final int CHORD_INDEX = 1;
    public static final int ALTERATION_INDEX = 2;
    public static final int PLUSMINUS_INDEX = 3;
    public static final int BASS_INDEX = 4;
    public static final int ADDCHK_INDEX = 5;
    public static final int I5_INDEX = 6;
    public static final int I9_INDEX = 7;
    public static final int I11_INDEX = 8;
    private TGChordDialog dialog;
    private UIPanel control;
    private UIListBoxSelect<Integer> proposalList;
    private List<int[]> proposalParameters;
    private long runningProcess = 0L;

    public TGChordRecognizer(TGChordDialog dialog, UIContainer parent) {
        this.dialog = dialog;
        this.createControl(parent);
    }

    public void createControl(UIContainer parent) {
        UIFactory uiFactory = this.dialog.getUIFactory();
        UITableLayout layout = new UITableLayout(Float.valueOf(0.0f));
        this.control = uiFactory.createPanel(parent, true);
        this.control.setLayout((UILayout)layout);
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = uiFactory.createPanel((UIContainer)this.control, false);
        composite.setLayout((UILayout)compositeLayout);
        layout.set((UIControl)composite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.proposalParameters = new ArrayList<int[]>();
        this.proposalList = uiFactory.createListBoxSelect((UIContainer)composite);
        this.proposalList.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordRecognizer.this.getDialog().getEditor() != null) {
                    TGChordRecognizer.this.showChord();
                }
            }
        });
        compositeLayout.set(this.proposalList, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
    }

    protected void showChord() {
        UISelectItem selectedItem = this.proposalList.getSelectedItem();
        if (selectedItem != null && (Integer)selectedItem.getValue() < this.proposalParameters.size()) {
            int[] params = this.proposalParameters.get((Integer)selectedItem.getValue());
            this.dialog.getSelector().adjustWidgets(params[0], params[1], params[2], params[4], params[3], params[5], params[6], params[7], params[8]);
            String chordName = selectedItem.getText();
            chordName = chordName.substring(0, chordName.indexOf(40) - 1);
            this.dialog.getEditor().getChordName().setText(chordName);
            this.dialog.getEditor().redraw();
        }
    }

    public void recognize(final TGChord chord, final boolean redecorate, final boolean setChordName) {
        final long processId = ++this.runningProcess;
        final boolean sharp = this.dialog.getSelector().getSharpButton().isSelected();
        this.clearProposals();
        new Thread(new Runnable(){

            @Override
            public void run() throws TGException {
                if (!TGChordRecognizer.this.getDialog().isDisposed() && TGChordRecognizer.this.isValidProcess(processId)) {
                    TGChordRecognizer.this.makeProposals(processId, chord, sharp, redecorate, setChordName);
                }
            }
        }).start();
    }

    protected void makeProposals(long processId, TGChord chord, boolean sharp, boolean redecorate, boolean setChordName) {
        int i;
        int i2;
        ArrayList<int[]> proposalParameters = new ArrayList<int[]>();
        ArrayList<String> proposalNames = new ArrayList<String>();
        ArrayList<Integer> notesInside = new ArrayList<Integer>();
        int[] tuning = this.dialog.getSelector().getTuning();
        for (int i3 = 0; i3 < tuning.length; ++i3) {
            int fret = chord.getStrings()[i3];
            if (fret == -1) continue;
            Integer note = (tuning[tuning.length - 1 - i3] + fret) % 12;
            Iterator it = notesInside.iterator();
            boolean found = false;
            while (it.hasNext()) {
                if (!((Integer)it.next()).equals(note)) continue;
                found = true;
            }
            if (found) continue;
            notesInside.add(note);
        }
        ArrayList<Proposal> allProposals = new ArrayList<Proposal>(10);
        for (int tonic = 0; tonic < 12; ++tonic) {
            Proposal currentProp = null;
            for (int chordIndex = 0; chordIndex < TGChordDatabase.length(); ++chordIndex) {
                TGChordDatabase.ChordInfo info = TGChordDatabase.get(chordIndex);
                currentProp = new Proposal(notesInside);
                currentProp.unusualGrade = currentProp.unusualGrade - (chordIndex != TGChordDatabase.length() && chordIndex != 4 ? 2 * chordIndex : 0);
                boolean foundNote = false;
                for (i2 = 0; i2 < info.getRequiredNotes().length; ++i2) {
                    Iterator nit = notesInside.iterator();
                    while (nit.hasNext()) {
                        if ((Integer)nit.next() != (tonic + info.getRequiredNotes()[i2] - 1) % 12) continue;
                        foundNote = true;
                        if (tonic + info.getRequiredNotes()[i2] - 1 == tonic) {
                            currentProp.dontHaveGrade += 15;
                        }
                        currentProp.foundNote(tonic + info.getRequiredNotes()[i2] - 1);
                    }
                }
                if (foundNote) {
                    currentProp.params[0] = tonic;
                    currentProp.params[1] = chordIndex;
                    int foundNotesCount = currentProp.missingNotes.length - currentProp.missingCount;
                    if (!(info.getName().startsWith("dim") || info.getName().startsWith("aug") || currentProp.isFound(tonic + 8 - 1))) {
                        if (currentProp.isNeeded(tonic + 7 - 1) || currentProp.isNeeded(tonic + 9 - 1)) {
                            Proposal branchProp = (Proposal)currentProp.clone();
                            if (branchProp.isNeeded(tonic + 9 - 1)) {
                                branchProp.params[6] = 1;
                                branchProp.foundNote(tonic + 8);
                            } else {
                                branchProp.params[6] = 2;
                                branchProp.foundNote(tonic + 6);
                            }
                            branchProp.unusualGrade -= 35;
                            if (foundNotesCount + 1 >= info.getRequiredNotes().length - 1) {
                                branchProp.dontHaveGrade -= (info.getRequiredNotes().length - (foundNotesCount + 1)) * 50;
                                allProposals.add(branchProp);
                            }
                        } else {
                            currentProp.params[6] = 0;
                            currentProp.dontHaveGrade += 30;
                        }
                    }
                    currentProp.params[6] = 0;
                    if (foundNotesCount >= info.getRequiredNotes().length - 1) {
                        currentProp.dontHaveGrade -= (info.getRequiredNotes().length - foundNotesCount) * 50;
                        allProposals.add(currentProp);
                    }
                }
                currentProp = null;
            }
        }
        Iterator props = allProposals.iterator();
        List<Proposal> unsortedProposals = new ArrayList<Proposal>(5);
        while (props.hasNext()) {
            Proposal current = (Proposal)props.next();
            boolean bassIsOnlyInBass = true;
            for (i = chord.getStrings().length - 1; i >= 0; --i) {
                if (chord.getStrings()[i] == -1) continue;
                if (current.params[4] == -1) {
                    current.params[4] = (tuning[tuning.length - 1 - i] + chord.getStrings()[i]) % 12;
                    if (current.params[4] != current.params[0]) {
                        current.unusualGrade -= 20;
                    }
                }
                if (current.params[4] != (tuning[tuning.length - 1 - i] + chord.getStrings()[i]) % 12) continue;
                bassIsOnlyInBass = false;
            }
            if (current.isNeeded(current.params[4]) && bassIsOnlyInBass) {
                current.foundNote(current.params[4]);
                current.unusualGrade -= 20;
            }
            if (current.missingCount > 0 && current.params[1] <= 11) {
                int seventh = current.params[1] == 2 ? current.params[0] + 12 - 1 : current.params[0] + 11 - 1;
                if (current.isExisting(seventh) && !current.isFound(seventh)) {
                    current.filled[3] = true;
                    current.foundNote(seventh);
                }
                for (int plusminus = 0; plusminus <= 2; ++plusminus) {
                    for (int i4 = 2; i4 >= 0; --i4) {
                        if (!current.isNeeded(current.params[0] + this.getAddNote(i4, plusminus)) || current.filled[i4]) continue;
                        current.filled[i4] = true;
                        current.plusminusValue[i4] = plusminus;
                        if (plusminus != 0) {
                            current.unusualGrade -= 15;
                        }
                        current.foundNote(current.params[0] + this.getAddNote(i4, plusminus));
                    }
                }
            }
            if (current.filled[3] && !current.filled[0] && !current.filled[1] && !current.filled[2] || current.missingCount != 0 || current.dontHaveGrade <= -51) continue;
            this.findChordLogic(current);
            unsortedProposals.add(current);
        }
        this.shellsort(unsortedProposals, 1);
        int cut = -1;
        int howManyIncomplete = TGChordSettings.instance().getIncompleteChords();
        for (i = 0; i < unsortedProposals.size() && cut == -1; ++i) {
            int prior = ((Proposal)unsortedProposals.get((int)i)).dontHaveGrade;
            if (prior >= 0) continue;
            cut = i + howManyIncomplete;
        }
        unsortedProposals = unsortedProposals.subList(0, cut > 0 && cut < unsortedProposals.size() ? cut : unsortedProposals.size());
        this.shellsort(unsortedProposals, 2);
        int firstNegative = 0;
        for (i2 = 0; i2 < unsortedProposals.size(); ++i2) {
            Proposal current = unsortedProposals.get(i2);
            if (firstNegative == 0 && current.unusualGrade < 0) {
                firstNegative = current.unusualGrade;
            }
            if (current.unusualGrade <= (firstNegative >= 0 ? 0 : firstNegative) - 60) continue;
            proposalParameters.add(current.params);
            proposalNames.add(this.getChordName(current.params, sharp) + " (" + Math.round(100 + current.dontHaveGrade * 7 / 10) + "%)");
        }
        this.notifyProposals(processId, sharp, redecorate, setChordName, proposalParameters, proposalNames);
    }

    public void notifyProposals(final long processId, boolean sharp, final boolean redecorate, final boolean setChordName, final List<int[]> proposalParameters, final List<String> proposalNames) {
        final int[] params = !proposalParameters.isEmpty() ? proposalParameters.get(0) : null;
        final String chordName = params != null ? this.getChordName(params, sharp) : "";
        TGSynchronizer.getInstance((TGContext)this.dialog.getContext().getContext()).executeLater(new Runnable(){

            @Override
            public void run() {
                if (!TGChordRecognizer.this.getDialog().isDisposed() && TGChordRecognizer.this.isValidProcess(processId)) {
                    for (int[] currentProposalParameters : proposalParameters) {
                        TGChordRecognizer.this.addProposalParameters(currentProposalParameters);
                    }
                    for (String currentProposalName : proposalNames) {
                        TGChordRecognizer.this.addProposalName(currentProposalName);
                    }
                    if (redecorate && params != null) {
                        TGChordRecognizer.this.redecorate(params);
                    }
                    if (setChordName) {
                        TGChordRecognizer.this.getDialog().getEditor().setChordName(chordName != null ? chordName : "");
                    }
                }
            }
        });
    }

    public void redecorate(int[] params) {
        this.dialog.getSelector().adjustWidgets(params[0], params[1], params[2], params[4], params[3], params[5], params[6], params[7], params[8]);
    }

    public String getChordName(int[] param, boolean sharp) {
        return new TGChordNamingConvention().createChordName(param[0], param[1], param[2], param[3], param[5] != 0, param[6], param[7], param[8], param[4], sharp);
    }

    public int getAddNote(int type, int selectionIndex) {
        int wantedNote = 0;
        switch (type) {
            case 0: {
                wantedNote = 3;
                break;
            }
            case 1: {
                wantedNote = 6;
                break;
            }
            case 2: {
                wantedNote = 10;
            }
        }
        switch (selectionIndex) {
            case 1: {
                ++wantedNote;
                break;
            }
            case 2: {
                --wantedNote;
                break;
            }
        }
        return --wantedNote;
    }

    public void findChordLogic(Proposal current) {
        boolean[] found = current.filled;
        int[] plusMinus = current.plusminusValue;
        current.params[2] = 0;
        current.params[7] = plusMinus[0];
        current.params[8] = plusMinus[1];
        current.params[5] = 0;
        current.params[3] = 0;
        if (found[2]) {
            current.params[2] = 3;
            current.params[3] = plusMinus[2];
            if (!(found[1] && found[0] && found[3])) {
                current.unusualGrade -= 10;
                if (!(found[1] || found[0] || found[3])) {
                    current.params[5] = 1;
                } else {
                    if (!found[3]) {
                        current.dontHaveGrade -= 25;
                    }
                    if (!found[1]) {
                        current.unusualGrade -= 30;
                        current.dontHaveGrade -= 10;
                    }
                    if (!found[0]) {
                        current.unusualGrade -= 30;
                        current.dontHaveGrade -= 10;
                    }
                }
            }
        } else if (found[1]) {
            current.params[2] = 2;
            current.params[3] = plusMinus[1];
            current.params[8] = 0;
            current.unusualGrade -= 10;
            if (!found[0] || !found[3]) {
                if (!found[0] && !found[3]) {
                    current.params[5] = 1;
                } else {
                    if (!found[3]) {
                        current.dontHaveGrade -= 25;
                    }
                    if (!found[0]) {
                        current.unusualGrade -= 30;
                        current.dontHaveGrade -= 10;
                    }
                }
            }
        } else if (found[0]) {
            current.params[2] = 1;
            current.params[7] = 0;
            current.params[8] = 0;
            current.params[3] = plusMinus[0];
            current.unusualGrade -= 10;
            if (!found[3]) {
                current.params[5] = 1;
            }
        }
    }

    public void shellsort(List<Proposal> a, int sortIndex) {
        int length = a.size();
        int gap = length / 2;
        while (gap > 0) {
            for (int i = gap; i < length; ++i) {
                int j;
                Proposal tmp = a.get(i);
                for (j = i; j >= gap && (sortIndex == 1 ? tmp.dontHaveGrade > a.get((int)(j - gap)).dontHaveGrade : tmp.unusualGrade > a.get((int)(j - gap)).unusualGrade); j -= gap) {
                    a.set(j, a.get(j - gap));
                }
                a.set(j, tmp);
            }
            gap = gap == 2 ? 1 : (int)((double)gap / 2.2);
        }
    }

    public void addProposalParameters(int[] params) {
        this.proposalParameters.add(params);
    }

    public void addProposalName(String name) {
        this.proposalList.addItem(new UISelectItem(name, (Object)this.proposalList.getItemCount()));
    }

    public void clearProposals() {
        this.proposalList.removeItems();
        this.proposalParameters.clear();
    }

    public TGChordDialog getDialog() {
        return this.dialog;
    }

    public boolean isValidProcess(long processId) {
        return this.runningProcess == processId;
    }

    public UIPanel getControl() {
        return this.control;
    }

    private class Proposal
    implements Cloneable {
        int[] params;
        int unusualGrade = 0;
        int dontHaveGrade = -15;
        int missingCount;
        int[] missingNotes;
        boolean[] filled = new boolean[]{false, false, false, false};
        int[] plusminusValue = new int[]{0, 0, 0};

        private Proposal() {
            this.params = new int[9];
            for (int i = 0; i < 9; ++i) {
                this.params[i] = -1;
            }
        }

        public Proposal(List<Integer> notes) {
            this.params = new int[9];
            for (int i = 0; i < 9; ++i) {
                this.params[i] = -1;
            }
            int length = notes.size();
            this.missingNotes = new int[length];
            for (int i = 0; i < length; ++i) {
                this.missingNotes[i] = notes.get(i);
            }
            this.missingCount = length;
        }

        void foundNote(int value) {
            int note = value % 12;
            if (this.missingCount != 0) {
                for (int i = 0; i < this.missingCount; ++i) {
                    if (this.missingNotes[i] != note) continue;
                    --this.missingCount;
                    int temp = this.missingNotes[i];
                    this.missingNotes[i] = this.missingNotes[this.missingCount];
                    this.missingNotes[this.missingCount] = temp;
                    return;
                }
            }
        }

        boolean isFound(int value) {
            int note = value % 12;
            for (int i = this.missingCount; i < this.missingNotes.length; ++i) {
                if (this.missingNotes[i] != note) continue;
                return true;
            }
            return false;
        }

        boolean isNeeded(int value) {
            int note = value % 12;
            if (this.missingCount != 0) {
                for (int i = 0; i < this.missingCount; ++i) {
                    if (this.missingNotes[i] != note) continue;
                    return true;
                }
            }
            return false;
        }

        boolean isExisting(int value) {
            int note = value % 12;
            for (int i = 0; i < this.missingNotes.length; ++i) {
                if (this.missingNotes[i] != note) continue;
                return true;
            }
            return false;
        }

        public Object clone() {
            int i;
            Proposal proposal = new Proposal();
            for (i = 0; i < 9; ++i) {
                proposal.params[i] = this.params[i];
            }
            proposal.unusualGrade = this.unusualGrade;
            proposal.dontHaveGrade = this.dontHaveGrade;
            proposal.missingCount = this.missingCount;
            proposal.missingNotes = new int[this.missingNotes.length];
            for (i = 0; i < proposal.missingNotes.length; ++i) {
                proposal.missingNotes[i] = this.missingNotes[i];
            }
            proposal.filled = new boolean[this.filled.length];
            for (i = 0; i < proposal.filled.length; ++i) {
                proposal.filled[i] = this.filled[i];
            }
            proposal.plusminusValue = new int[this.plusminusValue.length];
            for (i = 0; i < proposal.plusminusValue.length; ++i) {
                proposal.plusminusValue[i] = this.plusminusValue[i];
            }
            return proposal;
        }

        public boolean equals(Object o) {
            Proposal another = (Proposal)o;
            for (int i = 0; i < 9; ++i) {
                if (this.params[i] == another.params[i]) continue;
                return false;
            }
            return true;
        }
    }
}

