/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.confirm;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.system.icons.TGIconManager;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UIImageView;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIWindow;

public class TGConfirmDialog {
    public static final String ATTRIBUTE_MESSAGE = "message";
    public static final String ATTRIBUTE_STYLE = "style";
    public static final String ATTRIBUTE_DEFAULT_BUTTON = "defaultButton";
    public static final String ATTRIBUTE_RUNNABLE_YES = "yesRunnable";
    public static final String ATTRIBUTE_RUNNABLE_NO = "noRunnable";
    public static final String ATTRIBUTE_RUNNABLE_CANCEL = "cancelRunnable";
    public static int BUTTON_CANCEL = 1;
    public static int BUTTON_YES = 2;
    public static int BUTTON_NO = 4;

    public void show(TGViewContext context) {
        String message = (String)context.getAttribute(ATTRIBUTE_MESSAGE);
        Integer style = (Integer)context.getAttribute(ATTRIBUTE_STYLE);
        Integer defaultButton = (Integer)context.getAttribute(ATTRIBUTE_DEFAULT_BUTTON);
        Runnable yesRunnable = (Runnable)context.getAttribute(ATTRIBUTE_RUNNABLE_YES);
        Runnable noRunnable = (Runnable)context.getAttribute(ATTRIBUTE_RUNNABLE_NO);
        Runnable cancelRunnable = (Runnable)context.getAttribute(ATTRIBUTE_RUNNABLE_CANCEL);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("confirm"));
        UITableLayout panelLayout = new UITableLayout();
        UIPanel uiPanel = uiFactory.createPanel((UIContainer)dialog, false);
        uiPanel.setLayout((UILayout)panelLayout);
        dialogLayout.set((UIControl)uiPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIImageView uiIcon = uiFactory.createImageView((UIContainer)uiPanel);
        uiIcon.setImage(TGIconManager.getInstance(context.getContext()).getStatusQuestion());
        panelLayout.set((UIControl)uiIcon, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UILabel uiMessage = uiFactory.createLabel((UIContainer)uiPanel);
        uiMessage.setText(message);
        panelLayout.set((UIControl)uiMessage, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_CENTER, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(false));
        UITableLayout buttonsLayout = new UITableLayout();
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        int columns = 0;
        if ((style & BUTTON_YES) != 0) {
            this.addCloseButton(uiFactory, dialog, (UILayoutContainer)buttons, TuxGuitar.getProperty("yes"), yesRunnable, defaultButton == BUTTON_YES, ++columns);
        }
        if ((style & BUTTON_NO) != 0) {
            this.addCloseButton(uiFactory, dialog, (UILayoutContainer)buttons, TuxGuitar.getProperty("no"), noRunnable, defaultButton == BUTTON_NO, ++columns);
        }
        if ((style & BUTTON_CANCEL) != 0) {
            this.addCloseButton(uiFactory, dialog, (UILayoutContainer)buttons, TuxGuitar.getProperty("cancel"), cancelRunnable, defaultButton == BUTTON_CANCEL, ++columns);
        }
        TGDialogUtil.openDialog(dialog, 5);
    }

    private void addCloseButton(UIFactory factory, final UIWindow dialog, UILayoutContainer parent, String text, final Runnable runnable, boolean defaultButton, int column) {
        UIButton uiButton = factory.createButton((UIContainer)parent);
        uiButton.setText(text);
        uiButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        if (defaultButton) {
            uiButton.setDefaultButton();
        }
        UITableLayout uiLayout = (UITableLayout)parent.getLayout();
        uiLayout.set((UIControl)uiButton, Integer.valueOf(1), Integer.valueOf(column), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
    }
}

