/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.info;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UITextArea;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;

public class TGSongInfoDialog {
    private static final float GROUP_WIDTH = 450.0f;

    public void show(final TGViewContext context) {
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("composition.properties"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setText(TuxGuitar.getProperty("composition.properties"));
        group.setLayout((UILayout)groupLayout);
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(450.0f), null, null);
        UILabel nameLabel = uiFactory.createLabel((UIContainer)group);
        nameLabel.setText(TuxGuitar.getProperty("composition.name") + ":");
        groupLayout.set((UIControl)nameLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextField nameText = uiFactory.createTextField((UIContainer)group);
        nameText.setText(song.getName());
        groupLayout.set((UIControl)nameText, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel artistLabel = uiFactory.createLabel((UIContainer)group);
        artistLabel.setText(TuxGuitar.getProperty("composition.artist") + ":");
        groupLayout.set((UIControl)artistLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextField artistText = uiFactory.createTextField((UIContainer)group);
        artistText.setText(song.getArtist());
        groupLayout.set((UIControl)artistText, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel albumLabel = uiFactory.createLabel((UIContainer)group);
        albumLabel.setText(TuxGuitar.getProperty("composition.album") + ":");
        groupLayout.set((UIControl)albumLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextField albumText = uiFactory.createTextField((UIContainer)group);
        albumText.setText(song.getAlbum());
        groupLayout.set((UIControl)albumText, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel authorLabel = uiFactory.createLabel((UIContainer)group);
        authorLabel.setText(TuxGuitar.getProperty("composition.author") + ":");
        groupLayout.set((UIControl)authorLabel, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextField authorText = uiFactory.createTextField((UIContainer)group);
        authorText.setText(song.getAuthor());
        groupLayout.set((UIControl)authorText, Integer.valueOf(4), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel dateLabel = uiFactory.createLabel((UIContainer)group);
        dateLabel.setText(TuxGuitar.getProperty("composition.date") + ":");
        groupLayout.set((UIControl)dateLabel, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextField dateText = uiFactory.createTextField((UIContainer)group);
        dateText.setText(song.getDate());
        groupLayout.set((UIControl)dateText, Integer.valueOf(5), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel copyrightLabel = uiFactory.createLabel((UIContainer)group);
        copyrightLabel.setText(TuxGuitar.getProperty("composition.copyright") + ":");
        groupLayout.set((UIControl)copyrightLabel, Integer.valueOf(6), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextField copyrightText = uiFactory.createTextField((UIContainer)group);
        copyrightText.setText(song.getCopyright());
        groupLayout.set((UIControl)copyrightText, Integer.valueOf(6), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel writerLabel = uiFactory.createLabel((UIContainer)group);
        writerLabel.setText(TuxGuitar.getProperty("composition.writer") + ":");
        groupLayout.set((UIControl)writerLabel, Integer.valueOf(7), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextField writerText = uiFactory.createTextField((UIContainer)group);
        writerText.setText(song.getWriter());
        groupLayout.set((UIControl)writerText, Integer.valueOf(7), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel transcriberLabel = uiFactory.createLabel((UIContainer)group);
        transcriberLabel.setText(TuxGuitar.getProperty("composition.transcriber") + ":");
        groupLayout.set((UIControl)transcriberLabel, Integer.valueOf(8), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextField transcriberText = uiFactory.createTextField((UIContainer)group);
        transcriberText.setText(song.getTranscriber());
        groupLayout.set((UIControl)transcriberText, Integer.valueOf(8), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel commentsLabel = uiFactory.createLabel((UIContainer)group);
        commentsLabel.setText(TuxGuitar.getProperty("composition.comments") + ":");
        groupLayout.set((UIControl)commentsLabel, Integer.valueOf(9), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UITextArea commentsText = uiFactory.createTextArea((UIContainer)group, true, false);
        commentsText.setText(song.getComments());
        groupLayout.set((UIControl)commentsText, Integer.valueOf(9), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), null, Float.valueOf(100.0f), null);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                String name = nameText.getText();
                String artist = artistText.getText();
                String album = albumText.getText();
                String author = authorText.getText();
                String date = dateText.getText();
                String copyright = copyrightText.getText();
                String writer = writerText.getText();
                String transcriber = transcriberText.getText();
                String comments = commentsText.getText();
                TGSongInfoDialog.this.updateSongInfo(context.getContext(), song, name, artist, album, author, date, copyright, writer, transcriber, comments);
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public void updateSongInfo(TGContext context, TGSong song, String name, String artist, String album, String author, String date, String copyright, String writer, String transcriber, String comments) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-info");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute("name", (Object)name);
        tgActionProcessor.setAttribute("artist", (Object)artist);
        tgActionProcessor.setAttribute("album", (Object)album);
        tgActionProcessor.setAttribute("author", (Object)author);
        tgActionProcessor.setAttribute("date", (Object)date);
        tgActionProcessor.setAttribute("copyright", (Object)copyright);
        tgActionProcessor.setAttribute("writer", (Object)writer);
        tgActionProcessor.setAttribute("transcriber", (Object)transcriber);
        tgActionProcessor.setAttribute("comments", (Object)comments);
        tgActionProcessor.processOnNewThread();
    }
}

