/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.marker;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGMarker;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.chooser.UIColorChooser;
import app.tuxguitar.ui.chooser.UIColorChooserHandler;
import app.tuxguitar.ui.event.UIDisposeEvent;
import app.tuxguitar.ui.event.UIDisposeListener;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIColorModel;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UITextField;
import app.tuxguitar.ui.widget.UIWindow;

public class TGMarkerEditor {
    private static final float MINIMUM_CONTROL_WIDTH = 180.0f;
    private static final float MINIMUM_BUTTON_WIDTH = 80.0f;
    private static final float MINIMUM_BUTTON_HEIGHT = 25.0f;
    private TGViewContext context;
    private TGMarker marker;
    private UIWindow dialog;
    private UISpinner measureSpinner;
    private UITextField titleText;
    private UIButton colorButton;
    private UIColor colorButtonValue;

    public TGMarkerEditor(TGViewContext context) {
        this.context = context;
    }

    public void show() {
        this.createEditableMarker();
        final UIFactory uiFactory = TGApplication.getInstance(this.context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)this.context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        this.dialog = uiFactory.createWindow(uiParent, true, false);
        this.dialog.setLayout((UILayout)dialogLayout);
        this.dialog.setText(TuxGuitar.getProperty("marker"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)this.dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("marker"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final int measureCount = TuxGuitar.getInstance().getDocumentManager().getSong().countMeasureHeaders();
        UILabel measureLabel = uiFactory.createLabel((UIContainer)group);
        measureLabel.setText(TuxGuitar.getProperty("measure") + ":");
        groupLayout.set((UIControl)measureLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.measureSpinner = uiFactory.createSpinner((UIContainer)group);
        this.measureSpinner.setMinimum(1);
        this.measureSpinner.setMaximum(measureCount);
        this.measureSpinner.setValue(this.marker.getMeasure());
        this.measureSpinner.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                int selection = TGMarkerEditor.this.measureSpinner.getValue();
                if (selection < 1) {
                    TGMarkerEditor.this.measureSpinner.setValue(1);
                } else if (selection > measureCount) {
                    TGMarkerEditor.this.measureSpinner.setValue(measureCount);
                }
            }
        });
        groupLayout.set((UIControl)this.measureSpinner, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel titleLabel = uiFactory.createLabel((UIContainer)group);
        titleLabel.setText(TuxGuitar.getProperty("title") + ":");
        groupLayout.set((UIControl)titleLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.titleText = uiFactory.createTextField((UIContainer)group);
        this.titleText.setText(this.marker.getTitle());
        groupLayout.set((UIControl)this.titleText, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UILabel colorLabel = uiFactory.createLabel((UIContainer)group);
        colorLabel.setText(TuxGuitar.getProperty("color") + ":");
        groupLayout.set((UIControl)colorLabel, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        this.colorButton = uiFactory.createButton((UIContainer)group);
        this.colorButton.setText(TuxGuitar.getProperty("choose"));
        this.colorButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                UIColorModel colorModel = new UIColorModel();
                colorModel.setRed(TGMarkerEditor.this.marker.getColor().getR());
                colorModel.setGreen(TGMarkerEditor.this.marker.getColor().getG());
                colorModel.setBlue(TGMarkerEditor.this.marker.getColor().getB());
                UIColorChooser colorChooser = uiFactory.createColorChooser(TGMarkerEditor.this.dialog);
                colorChooser.setDefaultModel(colorModel);
                colorChooser.setText(TuxGuitar.getProperty("choose-color"));
                colorChooser.choose(new UIColorChooserHandler(){

                    public void onSelectColor(UIColorModel selection) {
                        if (selection != null) {
                            TGMarkerEditor.this.marker.getColor().setR(selection.getRed());
                            TGMarkerEditor.this.marker.getColor().setG(selection.getGreen());
                            TGMarkerEditor.this.marker.getColor().setB(selection.getBlue());
                            TGMarkerEditor.this.setButtonColor(uiFactory);
                        }
                    }
                });
            }
        });
        this.colorButton.addDisposeListener(new UIDisposeListener(){

            public void onDispose(UIDisposeEvent event) {
                TGMarkerEditor.this.disposeButtonColor();
            }
        });
        this.setButtonColor(uiFactory);
        groupLayout.set((UIControl)this.colorButton, Integer.valueOf(3), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(180.0f), null, null);
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)this.dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMarkerEditor.this.updateMarker();
                TGMarkerEditor.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGMarkerEditor.this.dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(this.dialog, 5);
    }

    private void setButtonColor(UIFactory factory) {
        this.colorButton.setFgColor(null);
        this.disposeButtonColor();
        this.colorButtonValue = factory.createColor(this.marker.getColor().getR(), this.marker.getColor().getG(), this.marker.getColor().getB());
        this.colorButton.setFgColor(this.colorButtonValue);
    }

    private void disposeButtonColor() {
        if (this.colorButtonValue != null && !this.colorButtonValue.isDisposed()) {
            this.colorButton.setFgColor(null);
            this.colorButtonValue.dispose();
            this.colorButtonValue = null;
        }
    }

    private void updateMarker() {
        this.marker.setMeasure(this.measureSpinner.getValue());
        this.marker.setTitle(this.titleText.getText());
        TGSongManager songManager = (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.marker.modify");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER, this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER));
        tgActionProcessor.setAttribute("modifiedMarker", (Object)this.marker.clone(songManager.getFactory()));
        tgActionProcessor.process();
    }

    private void createEditableMarker() {
        TGSongManager songManager = (TGSongManager)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG_MANAGER);
        TGMarker marker = (TGMarker)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MARKER);
        if (marker == null) {
            TGMeasureHeader header = (TGMeasureHeader)this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
            marker = songManager.getFactory().newMarker();
            marker.setMeasure(header.getNumber());
        }
        this.marker = marker.clone(songManager.getFactory());
    }
}

