/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.settings.items;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.dialog.settings.TGSettingsEditor;
import app.tuxguitar.app.view.dialog.settings.items.TGSettingsOption;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILayoutContainer;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UITable;
import app.tuxguitar.ui.widget.UITableItem;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGSynchronizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LanguageOption
extends TGSettingsOption {
    private static final float PACKED_HEIGHT = 10.0f;
    private boolean initialized = false;
    private UITable<String> table;

    public LanguageOption(TGSettingsEditor configEditor, UIToolBar toolBar, UILayoutContainer parent) {
        super(configEditor, toolBar, parent, TuxGuitar.getProperty("settings.config.language"), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL);
    }

    @Override
    public void createOption() {
        UIFactory uiFactory = this.getUIFactory();
        this.getToolItem().setText(TuxGuitar.getProperty("settings.config.language"));
        this.getToolItem().setImage(TuxGuitar.getInstance().getIconManager().getOptionLanguage());
        this.getToolItem().addSelectionListener((UISelectionListener)this);
        this.showLabel((UILayoutContainer)this.getPanel(), TuxGuitar.getProperty("settings.config.language.choose"), true, 1, 1);
        UITableLayout compositeLayout = new UITableLayout();
        UIPanel composite = uiFactory.createPanel((UIContainer)this.getPanel(), false);
        composite.setLayout((UILayout)compositeLayout);
        this.indent((UIControl)composite, 2, 1);
        this.table = uiFactory.createTable((UIContainer)composite, true);
        this.table.setColumns(1);
        this.table.setColumnName(0, TuxGuitar.getProperty("settings.config.language.choose"));
        compositeLayout.set(this.table, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        compositeLayout.set(this.table, "packed_height", (Object)Float.valueOf(10.0f));
        this.loadConfig();
    }

    protected void loadTableItem(String text, String data, boolean selected) {
        UITableItem uiTableItem = new UITableItem((Object)data);
        uiTableItem.setText(0, text);
        this.table.addItem(uiTableItem);
        if (selected) {
            this.table.setSelectedItem(uiTableItem);
        }
    }

    protected List<LanguageItem> getLanguageItems(String[] languages) {
        ArrayList<LanguageItem> list = new ArrayList<LanguageItem>();
        if (languages != null) {
            for (int i = 0; i < languages.length; ++i) {
                list.add(new LanguageItem(languages[i], TuxGuitar.getProperty("locale." + languages[i])));
            }
            Collections.sort(list, new Comparator<LanguageItem>(){

                @Override
                public int compare(LanguageItem l1, LanguageItem l2) {
                    if (l1 != null && l2 != null) {
                        return l1.getValue().compareTo(l2.getValue());
                    }
                    return 0;
                }
            });
        }
        return list;
    }

    protected void loadConfig() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                final String language = LanguageOption.this.getConfig().getStringValue("language");
                final List<LanguageItem> languages = LanguageOption.this.getLanguageItems(TuxGuitar.getInstance().getLanguageManager().getLanguages());
                TGSynchronizer.getInstance((TGContext)LanguageOption.this.getViewContext().getContext()).executeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!LanguageOption.this.isDisposed()) {
                            LanguageOption.this.loadTableItem(TuxGuitar.getProperty("locale.default"), new String(), true);
                            for (int i = 0; i < languages.size(); ++i) {
                                LanguageItem item = (LanguageItem)languages.get(i);
                                LanguageOption.this.loadTableItem(item.getValue(), item.getKey(), language != null && item.getKey().equals(language));
                            }
                            LanguageOption.this.initialized = true;
                            LanguageOption.this.pack();
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    public void updateConfig() {
        if (this.initialized) {
            String language = this.table != null && !this.table.isDisposed() ? (String)this.table.getSelectedValue() : null;
            this.getConfig().setValue("language", language);
        }
    }

    @Override
    public void updateDefaults() {
        if (this.initialized) {
            this.getConfig().setValue("language", this.getDefaults().getValue("language"));
        }
    }

    private class LanguageItem {
        private String key;
        private String value;

        public LanguageItem(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

