/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.dialog.tempo;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.controller.TGViewContext;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTempo;
import app.tuxguitar.song.models.TGTempoBase;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UIRadioButton;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;

public class TGTempoDialog {
    private final TGTempoBase[] tempoBase = TGTempoBase.getTempoBases();
    private int selectedBase;
    private boolean selectedDotted;

    public void show(final TGViewContext context) {
        final TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
        final TGMeasureHeader header = (TGMeasureHeader)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER);
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("composition.tempo"));
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty("composition.tempo"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        TGTempo currentTempo = header.getTempo();
        UITableLayout radioButtonsLayout = new UITableLayout();
        UIPanel radioButtonsPanel = uiFactory.createPanel((UIContainer)group, false);
        radioButtonsPanel.setLayout((UILayout)radioButtonsLayout);
        for (int i = 0; i < this.tempoBase.length; ++i) {
            UIRadioButton button = uiFactory.createRadioButton((UIContainer)radioButtonsPanel);
            button.setImage(TuxGuitar.getInstance().getIconManager().getDuration(this.tempoBase[i].getBase(), this.tempoBase[i].isDotted()));
            if (currentTempo.getBase() == this.tempoBase[i].getBase() && currentTempo.isDotted() == this.tempoBase[i].isDotted()) {
                button.setSelected(true);
                this.selectedBase = this.tempoBase[i].getBase();
                this.selectedDotted = this.tempoBase[i].isDotted();
            } else {
                button.setSelected(false);
            }
            button.addSelectionListener(this.createSelectionListener(this.tempoBase[i].getBase(), this.tempoBase[i].isDotted()));
            radioButtonsLayout.set((UIControl)button, Integer.valueOf(1), Integer.valueOf(i + 1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(60.0f), null, null);
        }
        groupLayout.set((UIControl)radioButtonsPanel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout tempoValueLayout = new UITableLayout();
        UIPanel tempoValuePanel = uiFactory.createPanel((UIContainer)group, false);
        tempoValuePanel.setLayout((UILayout)tempoValueLayout);
        UILabel tempoLabel = uiFactory.createLabel((UIContainer)tempoValuePanel);
        tempoLabel.setText(TuxGuitar.getProperty("composition.tempo") + ":");
        tempoValueLayout.set((UIControl)tempoLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        final UISpinner tempo = uiFactory.createSpinner((UIContainer)tempoValuePanel);
        tempo.setMinimum(1);
        tempo.setMaximum(320);
        tempo.setValue(currentTempo.getRawValue());
        tempoValueLayout.set((UIControl)tempo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(150.0f), null, null);
        groupLayout.set((UIControl)tempoValuePanel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout optionsLayout = new UITableLayout();
        UILegendPanel options = uiFactory.createLegendPanel((UIContainer)dialog);
        options.setLayout((UILayout)optionsLayout);
        options.setText(TuxGuitar.getProperty("options"));
        dialogLayout.set((UIControl)options, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIRadioButton applyToAllMeasures = uiFactory.createRadioButton((UIContainer)options);
        applyToAllMeasures.setText(TuxGuitar.getProperty("composition.tempo.start-to-end"));
        applyToAllMeasures.setSelected(true);
        optionsLayout.set((UIControl)applyToAllMeasures, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIRadioButton applyToEnd = uiFactory.createRadioButton((UIContainer)options);
        applyToEnd.setText(TuxGuitar.getProperty("composition.tempo.position-to-end"));
        optionsLayout.set((UIControl)applyToEnd, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIRadioButton applyToNext = uiFactory.createRadioButton((UIContainer)options);
        applyToNext.setText(TuxGuitar.getProperty("composition.tempo.position-to-next"));
        optionsLayout.set((UIControl)applyToNext, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                Integer value = tempo.getValue();
                Integer applyTo = TGTempoDialog.this.parseApplyTo(applyToAllMeasures, applyToEnd, applyToNext);
                TGTempoDialog.this.changeTempo(context.getContext(), song, header, TGTempoDialog.this.selectedBase, TGTempoDialog.this.selectedDotted, value, applyTo);
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    private Integer parseApplyTo(UIRadioButton applyToAll, UIRadioButton applyToEnd, UIRadioButton applyToNext) {
        if (applyToAll.isSelected()) {
            return 1;
        }
        if (applyToEnd.isSelected()) {
            return 2;
        }
        if (applyToNext.isSelected()) {
            return 3;
        }
        return 0;
    }

    private UISelectionListener createSelectionListener(final int base, final boolean dotted) {
        return new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTempoDialog.this.selectedBase = base;
                TGTempoDialog.this.selectedDotted = dotted;
            }
        };
    }

    public void changeTempo(TGContext context, TGSong song, TGMeasureHeader header, Integer base, Boolean dotted, Integer value, Integer applyTo) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.composition.change-tempo-range");
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG, (Object)song);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, (Object)header);
        tgActionProcessor.setAttribute("tempoValue", (Object)value);
        tgActionProcessor.setAttribute("tempoBase", (Object)base);
        tgActionProcessor.setAttribute("tempoBaseDotted", (Object)dotted);
        tgActionProcessor.setAttribute("applyTo", (Object)applyTo);
        tgActionProcessor.processOnNewThread();
    }
}

