/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.menu.impl;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.action.TGActionProcessorListener;
import app.tuxguitar.app.action.impl.file.TGExportSongAction;
import app.tuxguitar.app.action.impl.file.TGImportSongAction;
import app.tuxguitar.app.action.impl.file.TGReadURLAction;
import app.tuxguitar.app.helper.TGFileHistory;
import app.tuxguitar.app.view.menu.TGMenuItem;
import app.tuxguitar.editor.action.file.TGLoadTemplateAction;
import app.tuxguitar.editor.action.file.TGReadSongAction;
import app.tuxguitar.editor.template.TGTemplate;
import app.tuxguitar.editor.template.TGTemplateManager;
import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatManager;
import app.tuxguitar.io.base.TGSongExporter;
import app.tuxguitar.io.base.TGSongImporter;
import app.tuxguitar.io.base.TGSongReader;
import app.tuxguitar.io.base.TGSongWriter;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuActionItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.menu.UIMenuSubMenuItem;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGUserFileUtils;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem fileMenuItem;
    private UIMenuSubMenuItem newSong;
    private UIMenuActionItem newSongDefault;
    private UIMenuActionItem open;
    private UIMenuActionItem openURL;
    private UIMenuActionItem selectCustomTemplate;
    private UIMenuActionItem deleteCustomTemplate;
    private UIMenuActionItem save;
    private UIMenuActionItem saveAs;
    private UIMenuActionItem close;
    private UIMenuActionItem closeOthers;
    private UIMenuActionItem closeAll;
    private UIMenuSubMenuItem importItem;
    private UIMenuSubMenuItem exportItem;
    private UIMenuActionItem printPreview;
    private UIMenuActionItem print;
    private UIMenuSubMenuItem historyItem;
    private UIMenuActionItem[] historyFiles;
    private UIMenuActionItem exit;
    private List<UIMenuActionItem> readerItems;
    private List<UIMenuActionItem> writerItems;
    private List<UIMenuActionItem> importItems;
    private List<UIMenuActionItem> exportItems;

    public FileMenuItem(UIMenu parent) {
        this.fileMenuItem = parent.createSubMenuItem();
        this.readerItems = new ArrayList<UIMenuActionItem>();
        this.writerItems = new ArrayList<UIMenuActionItem>();
        this.importItems = new ArrayList<UIMenuActionItem>();
        this.exportItems = new ArrayList<UIMenuActionItem>();
    }

    @Override
    public void showItems() {
        this.newSong = this.fileMenuItem.getMenu().createSubMenuItem();
        this.newSongDefault = this.newSong.getMenu().createActionItem();
        this.newSongDefault.addSelectionListener((UISelectionListener)this.createNewSongFromTemplateActionProcessor(null));
        this.addNewSongTemplates();
        this.open = this.fileMenuItem.getMenu().createActionItem();
        this.open.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.open"));
        this.openURL = this.fileMenuItem.getMenu().createActionItem();
        this.openURL.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-url-dialog"));
        this.fileMenuItem.getMenu().createSeparator();
        this.selectCustomTemplate = this.fileMenuItem.getMenu().createActionItem();
        this.selectCustomTemplate.addSelectionListener((UISelectionListener)this.createActionProcessor("action.custom-template.select"));
        this.deleteCustomTemplate = this.fileMenuItem.getMenu().createActionItem();
        this.deleteCustomTemplate.addSelectionListener((UISelectionListener)this.createActionProcessor("action.custom-template.delete"));
        this.fileMenuItem.getMenu().createSeparator();
        this.close = this.fileMenuItem.getMenu().createActionItem();
        this.close.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.close-current"));
        this.closeOthers = this.fileMenuItem.getMenu().createActionItem();
        this.closeOthers.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.close-others"));
        this.closeAll = this.fileMenuItem.getMenu().createActionItem();
        this.closeAll.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.close-all"));
        this.fileMenuItem.getMenu().createSeparator();
        this.save = this.fileMenuItem.getMenu().createActionItem();
        this.save.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.save"));
        this.saveAs = this.fileMenuItem.getMenu().createActionItem();
        this.saveAs.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.save-as"));
        TGFileFormatManager fileFormatManager = TGFileFormatManager.getInstance((TGContext)this.findContext());
        List readers = fileFormatManager.findSongReaders(Boolean.valueOf(false));
        List writers = fileFormatManager.findSongWriters(Boolean.valueOf(false));
        List importers = fileFormatManager.getImporters();
        List exporters = fileFormatManager.getExporters();
        int countImporters = readers.size() + importers.size();
        int countExporters = writers.size() + exporters.size();
        if (countImporters + countExporters > 0) {
            this.fileMenuItem.getMenu().createSeparator();
            this.readerItems.clear();
            this.importItems.clear();
            if (countImporters > 0) {
                this.importItem = this.fileMenuItem.getMenu().createSubMenuItem();
                this.addImporters(readers, importers);
            }
            this.writerItems.clear();
            this.exportItems.clear();
            if (countExporters > 0) {
                this.exportItem = this.fileMenuItem.getMenu().createSubMenuItem();
                this.addExporters(writers, exporters);
            }
        }
        this.fileMenuItem.getMenu().createSeparator();
        this.printPreview = this.fileMenuItem.getMenu().createActionItem();
        this.printPreview.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.print-preview"));
        this.print = this.fileMenuItem.getMenu().createActionItem();
        this.print.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.print"));
        this.fileMenuItem.getMenu().createSeparator();
        this.historyItem = this.fileMenuItem.getMenu().createSubMenuItem();
        this.updateHistoryFiles();
        this.fileMenuItem.getMenu().createSeparator();
        this.exit = this.fileMenuItem.getMenu().createActionItem();
        this.exit.addSelectionListener((UISelectionListener)this.createActionProcessor("action.file.exit"));
        this.loadIcons();
        this.loadProperties();
    }

    private void addNewSongTemplates() {
        TGTemplateManager templateManager = TGTemplateManager.getInstance((TGContext)this.findContext());
        if (templateManager.countTemplates() > 0) {
            this.newSong.getMenu().createSeparator();
            Iterator it = templateManager.getTemplates();
            while (it.hasNext()) {
                TGTemplate tgTemplate = (TGTemplate)it.next();
                UIMenuActionItem uiMenuItem = this.newSong.getMenu().createActionItem();
                uiMenuItem.setText(tgTemplate.getName());
                uiMenuItem.addSelectionListener((UISelectionListener)this.createNewSongFromTemplateActionProcessor(tgTemplate));
            }
        }
    }

    private void addImporters(List<TGSongReader> readers, List<TGSongImporter> importers) {
        UIMenuActionItem uiMenuItem;
        for (TGSongReader reader : readers) {
            uiMenuItem = this.importItem.getMenu().createActionItem();
            uiMenuItem.setData(TGFileFormat.class.getName(), (Object)reader.getFileFormat());
            uiMenuItem.addSelectionListener((UISelectionListener)this.createOpenFileActionProcessor(reader.getFileFormat()));
            this.readerItems.add(uiMenuItem);
        }
        if (!readers.isEmpty() && !importers.isEmpty()) {
            this.importItem.getMenu().createSeparator();
        }
        for (TGSongImporter importer : importers) {
            uiMenuItem = this.importItem.getMenu().createActionItem();
            uiMenuItem.setData(TGSongImporter.class.getName(), (Object)importer);
            uiMenuItem.addSelectionListener((UISelectionListener)this.createImportSongActionProcessor(importer));
            this.importItems.add(uiMenuItem);
        }
    }

    private void addExporters(List<TGSongWriter> writers, List<TGSongExporter> exporters) {
        UIMenuActionItem uiMenuItem;
        for (TGSongWriter writer : writers) {
            uiMenuItem = this.exportItem.getMenu().createActionItem();
            uiMenuItem.setData(TGFileFormat.class.getName(), (Object)writer.getFileFormat());
            uiMenuItem.addSelectionListener((UISelectionListener)this.createSaveAsFileActionProcessor(writer.getFileFormat()));
            this.writerItems.add(uiMenuItem);
        }
        if (!writers.isEmpty() && !exporters.isEmpty()) {
            this.exportItem.getMenu().createSeparator();
        }
        for (TGSongExporter exporter : exporters) {
            uiMenuItem = this.exportItem.getMenu().createActionItem();
            uiMenuItem.setData(TGSongExporter.class.getName(), (Object)exporter);
            uiMenuItem.addSelectionListener((UISelectionListener)this.createExportSongActionProcessor(exporter));
            this.exportItems.add(uiMenuItem);
        }
    }

    private void disposeHistoryFiles() {
        for (int i = 0; i < this.historyFiles.length; ++i) {
            this.historyFiles[i].dispose();
        }
    }

    private void updateHistoryFiles() {
        List<URL> urls = TGFileHistory.getInstance(this.findContext()).getURLs();
        this.historyFiles = new UIMenuActionItem[urls.size()];
        for (int i = 0; i < this.historyFiles.length; ++i) {
            URL url = urls.get(i);
            this.historyFiles[i] = this.historyItem.getMenu().createActionItem();
            this.historyFiles[i].setText(this.decode(url.toString()));
            this.historyFiles[i].addSelectionListener((UISelectionListener)this.createOpenUrlActionProcessor(url));
        }
        this.historyItem.setEnabled(this.historyFiles.length > 0);
    }

    public TGActionProcessorListener createOpenUrlActionProcessor(URL url) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.url.read");
        tgActionProcessorListener.setAttribute(TGReadURLAction.ATTRIBUTE_URL, url);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createNewSongFromTemplateActionProcessor(TGTemplate template) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.new");
        tgActionProcessorListener.setAttribute(TGLoadTemplateAction.ATTRIBUTE_TEMPLATE, template);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createOpenFileActionProcessor(TGFileFormat fileFormat) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.file.open");
        tgActionProcessorListener.setAttribute(TGReadSongAction.ATTRIBUTE_FORMAT, fileFormat);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createSaveAsFileActionProcessor(TGFileFormat fileFormat) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.file.save-as");
        tgActionProcessorListener.setAttribute(TGReadSongAction.ATTRIBUTE_FORMAT, fileFormat);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createImportSongActionProcessor(TGSongImporter importer) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.import");
        tgActionProcessorListener.setAttribute(TGImportSongAction.ATTRIBUTE_PROVIDER, importer);
        return tgActionProcessorListener;
    }

    public TGActionProcessorListener createExportSongActionProcessor(TGSongExporter exporter) {
        TGActionProcessorListener tgActionProcessorListener = this.createActionProcessor("action.song.export");
        tgActionProcessorListener.setAttribute(TGExportSongAction.ATTRIBUTE_PROVIDER, exporter);
        return tgActionProcessorListener;
    }

    private String decode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return url;
        }
    }

    @Override
    public void update() {
        TGFileHistory fileHistory = TGFileHistory.getInstance(this.findContext());
        if (fileHistory.isChanged()) {
            this.disposeHistoryFiles();
            this.updateHistoryFiles();
            fileHistory.setChanged(false);
        }
        this.deleteCustomTemplate.setEnabled(TGUserFileUtils.isUserTemplateReadable());
    }

    @Override
    public void loadProperties() {
        TGFileFormat fileFormat;
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.fileMenuItem, "file", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.newSong, "file.new", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.newSongDefault, "file.new-song.default-template", "action.song.new");
        this.selectCustomTemplate.setText(TuxGuitar.getProperty("file.custom-template.select"));
        this.deleteCustomTemplate.setText(TuxGuitar.getProperty("file.custom-template.delete"));
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.open, "file.open", "action.file.open");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.openURL, "file.open-url", "action.gui.open-url-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.close, "file.close", "action.file.close-current");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.closeOthers, "file.close-others", "action.file.close-others");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.closeAll, "file.close-all", "action.file.close-all");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.save, "file.save", "action.file.save");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.saveAs, "file.save-as", "action.file.save-as");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.printPreview, "file.print-preview", "action.file.print-preview");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.print, "file.print", "action.file.print");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.historyItem, "file.history", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.exit, "file.exit", "action.file.exit");
        if (this.importItem != null) {
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.importItem, "file.import", null);
            for (UIMenuActionItem item : this.readerItems) {
                fileFormat = (TGFileFormat)item.getData(TGFileFormat.class.getName());
                item.setText(TuxGuitar.getProperty("file.import") + " " + fileFormat.getName());
            }
            for (UIMenuActionItem item : this.importItems) {
                TGSongImporter itemImporter = (TGSongImporter)item.getData(TGSongImporter.class.getName());
                item.setText(itemImporter.getImportName());
            }
        }
        if (this.exportItem != null) {
            this.setMenuItemTextAndAccelerator((UIMenuItem)this.exportItem, "file.export", null);
            for (UIMenuActionItem item : this.writerItems) {
                fileFormat = (TGFileFormat)item.getData(TGFileFormat.class.getName());
                item.setText(TuxGuitar.getProperty("file.export") + " " + fileFormat.getName());
            }
            for (UIMenuActionItem item : this.exportItems) {
                TGSongExporter itemExporter = (TGSongExporter)item.getData(TGSongExporter.class.getName());
                item.setText(itemExporter.getExportName());
            }
        }
    }

    public void loadIcons() {
        this.newSong.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("new.png"));
        this.open.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("open.png"));
        this.close.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("close.png"));
        this.save.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("save.png"));
        this.saveAs.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("save-as.png"));
        if (this.importItem != null) {
            this.importItem.setImage(TuxGuitar.getInstance().getIconManager().getFileImport());
        }
        if (this.exportItem != null) {
            this.exportItem.setImage(TuxGuitar.getInstance().getIconManager().getFileExport());
        }
        this.printPreview.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("print-preview.png"));
        this.print.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("print.png"));
        this.historyItem.setImage(TuxGuitar.getInstance().getIconManager().getFileHistory());
        this.exit.setImage(TuxGuitar.getInstance().getIconManager().getFileExit());
    }
}

