/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.menu.impl;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.component.tab.TablatureEditor;
import app.tuxguitar.app.view.menu.TGMenuItem;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.menu.UIMenu;
import app.tuxguitar.ui.menu.UIMenuCheckableItem;
import app.tuxguitar.ui.menu.UIMenuItem;
import app.tuxguitar.ui.menu.UIMenuSubMenuItem;
import app.tuxguitar.util.TGNoteRange;

public class NoteEffectsMenuItem
extends TGMenuItem {
    private UIMenuSubMenuItem noteEffectsMenuItem;
    private UIMenuCheckableItem vibrato;
    private UIMenuCheckableItem bend;
    private UIMenuCheckableItem tremoloBar;
    private UIMenuCheckableItem deadNote;
    private UIMenuCheckableItem slide;
    private UIMenuCheckableItem hammer;
    private UIMenuCheckableItem ghostNote;
    private UIMenuCheckableItem accentuatedNote;
    private UIMenuCheckableItem heavyAccentuatedNote;
    private UIMenuCheckableItem letRing;
    private UIMenuCheckableItem harmonicNote;
    private UIMenuCheckableItem graceNote;
    private UIMenuCheckableItem trill;
    private UIMenuCheckableItem tremoloPicking;
    private UIMenuCheckableItem palmMute;
    private UIMenuCheckableItem staccato;
    private UIMenuCheckableItem tapping;
    private UIMenuCheckableItem slapping;
    private UIMenuCheckableItem popping;
    private UIMenuCheckableItem fadeIn;

    public NoteEffectsMenuItem(UIMenuSubMenuItem noteEffectsMenuItem) {
        this.noteEffectsMenuItem = noteEffectsMenuItem;
    }

    public NoteEffectsMenuItem(UIMenu parent) {
        this(parent.createSubMenuItem());
    }

    @Override
    public void showItems() {
        this.vibrato = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.vibrato.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-vibrato"));
        this.bend = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.bend.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-bend-dialog"));
        this.tremoloBar = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.tremoloBar.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-tremolo-bar-dialog"));
        this.slide = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.slide.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-slide"));
        this.deadNote = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.deadNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-dead"));
        this.hammer = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.hammer.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-hammer"));
        this.noteEffectsMenuItem.getMenu().createSeparator();
        this.ghostNote = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.ghostNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-ghost"));
        this.accentuatedNote = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.accentuatedNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-accentuated"));
        this.heavyAccentuatedNote = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.heavyAccentuatedNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-heavy-accentuated"));
        this.letRing = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.letRing.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-let-ring"));
        this.harmonicNote = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.harmonicNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-harmonic-dialog"));
        this.graceNote = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.graceNote.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-grace-dialog"));
        this.noteEffectsMenuItem.getMenu().createSeparator();
        this.trill = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.trill.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-trill-dialog"));
        this.tremoloPicking = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.tremoloPicking.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-tremolo-picking-dialog"));
        this.palmMute = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.palmMute.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-palm-mute"));
        this.staccato = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.staccato.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-staccato"));
        this.noteEffectsMenuItem.getMenu().createSeparator();
        this.tapping = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.tapping.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-tapping"));
        this.slapping = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.slapping.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-slapping"));
        this.popping = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.popping.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-popping"));
        this.noteEffectsMenuItem.getMenu().createSeparator();
        this.fadeIn = this.noteEffectsMenuItem.getMenu().createCheckItem();
        this.fadeIn.addSelectionListener((UISelectionListener)this.createActionProcessor("action.note.effect.change-fade-in"));
        this.loadIcons();
        this.loadProperties();
    }

    public void setEnabled(boolean enabled) {
        this.noteEffectsMenuItem.setEnabled(enabled);
    }

    @Override
    public void update() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        TGNoteRange noteRange = TablatureEditor.getInstance(this.findContext()).getTablature().getCurrentNoteRange();
        boolean isPercussion = TablatureEditor.getInstance(this.findContext()).getTablature().getCaret().getTrack().isPercussion();
        this.vibrato.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isVibrato()));
        this.vibrato.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.bend.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isBend()));
        this.bend.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.tremoloBar.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isTremoloBar()));
        this.tremoloBar.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.deadNote.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isDeadNote()));
        this.deadNote.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.slide.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isSlide()));
        this.slide.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.hammer.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isHammer()));
        this.hammer.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.ghostNote.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isGhostNote()));
        this.ghostNote.setEnabled(!running && !noteRange.isEmpty());
        this.accentuatedNote.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isAccentuatedNote()));
        this.accentuatedNote.setEnabled(!running && !noteRange.isEmpty());
        this.heavyAccentuatedNote.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isHeavyAccentuatedNote()));
        this.heavyAccentuatedNote.setEnabled(!running && !noteRange.isEmpty());
        this.letRing.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isLetRing()));
        this.letRing.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.harmonicNote.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isHarmonic()));
        this.harmonicNote.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.graceNote.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isGrace()));
        this.graceNote.setEnabled(!running && !noteRange.isEmpty());
        this.trill.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isTrill()));
        this.trill.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.tremoloPicking.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isTremoloPicking()));
        this.tremoloPicking.setEnabled(!running && !noteRange.isEmpty());
        this.palmMute.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isPalmMute()));
        this.palmMute.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.staccato.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isStaccato()));
        this.staccato.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.tapping.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isTapping()));
        this.tapping.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.slapping.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isSlapping()));
        this.slapping.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.popping.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isPopping()));
        this.popping.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
        this.fadeIn.setChecked(!noteRange.isEmpty() && noteRange.getNotes().stream().allMatch(n -> n.getEffect().isFadeIn()));
        this.fadeIn.setEnabled(!running && !noteRange.isEmpty() && !isPercussion);
    }

    @Override
    public void loadProperties() {
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.noteEffectsMenuItem, "effects", null);
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.vibrato, "effects.vibrato", "action.note.effect.change-vibrato");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.bend, "effects.bend", "action.gui.open-bend-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.tremoloBar, "effects.tremolo-bar", "action.gui.open-tremolo-bar-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.deadNote, "effects.deadnote", "action.note.effect.change-dead");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.slide, "effects.slide", "action.note.effect.change-slide");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.hammer, "effects.hammer", "action.note.effect.change-hammer");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.ghostNote, "effects.ghostnote", "action.note.effect.change-ghost");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.accentuatedNote, "effects.accentuatednote", "action.note.effect.change-accentuated");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.heavyAccentuatedNote, "effects.heavyaccentuatednote", "action.note.effect.change-heavy-accentuated");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.letRing, "effects.let-ring", "action.note.effect.change-let-ring");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.harmonicNote, "effects.harmonic", "action.gui.open-harmonic-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.graceNote, "effects.grace", "action.gui.open-grace-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.trill, "effects.trill", "action.gui.open-trill-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.tremoloPicking, "effects.tremolo-picking", "action.gui.open-tremolo-picking-dialog");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.palmMute, "effects.palm-mute", "action.note.effect.change-palm-mute");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.staccato, "effects.staccato", "action.note.effect.change-staccato");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.tapping, "effects.tapping", "action.note.effect.change-tapping");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.slapping, "effects.slapping", "action.note.effect.change-slapping");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.popping, "effects.popping", "action.note.effect.change-popping");
        this.setMenuItemTextAndAccelerator((UIMenuItem)this.fadeIn, "effects.fade-in", "action.note.effect.change-fade-in");
    }

    public void loadIcons() {
        this.vibrato.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_vibrato.png"));
        this.bend.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_bend.png"));
        this.tremoloBar.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_tremolo_bar.png"));
        this.deadNote.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_dead.png"));
        this.slide.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_slide.png"));
        this.hammer.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_hammer.png"));
        this.ghostNote.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_ghost.png"));
        this.accentuatedNote.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_accentuated.png"));
        this.heavyAccentuatedNote.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_heavy_accentuated.png"));
        this.letRing.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_let_ring.png"));
        this.harmonicNote.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_harmonic.png"));
        this.graceNote.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_grace.png"));
        this.trill.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_trill.png"));
        this.tremoloPicking.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_tremolo_picking.png"));
        this.palmMute.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_palm_mute.png"));
        this.staccato.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_staccato.png"));
        this.tapping.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_tapping.png"));
        this.slapping.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_slapping.png"));
        this.popping.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_popping.png"));
        this.fadeIn.setImage(TuxGuitar.getInstance().getIconManager().getImageByName("effect_fade_in.png"));
    }
}

