/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.view.toolbar.edit;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBar;
import app.tuxguitar.app.view.toolbar.edit.TGEditToolBarSection;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.toolbar.UIToolActionItem;
import app.tuxguitar.ui.toolbar.UIToolBar;
import app.tuxguitar.ui.toolbar.UIToolCheckableItem;

public class TGEditToolBarSectionComposition
extends TGEditToolBarSection {
    private static final String SECTION_TITLE = "composition";
    private UIToolActionItem timeSignature;
    private UIToolActionItem tempo;
    private UIToolCheckableItem repeatOpen;
    private UIToolCheckableItem repeatClose;
    private UIToolCheckableItem repeatAlternative;

    public TGEditToolBarSectionComposition(TGEditToolBar toolBar) {
        super(toolBar, SECTION_TITLE);
    }

    @Override
    public void createSectionToolBars() {
        UIToolBar toolBar = this.createToolBar();
        this.timeSignature = toolBar.createActionItem();
        this.timeSignature.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-time-signature-dialog"));
        this.tempo = toolBar.createActionItem();
        this.tempo.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-tempo-dialog"));
        toolBar.createSeparator();
        this.repeatOpen = toolBar.createCheckItem();
        this.repeatOpen.addSelectionListener((UISelectionListener)this.createActionProcessor("action.insert.open-repeat"));
        this.repeatClose = toolBar.createCheckItem();
        this.repeatClose.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-repeat-close-dialog"));
        this.repeatAlternative = toolBar.createCheckItem();
        this.repeatAlternative.addSelectionListener((UISelectionListener)this.createActionProcessor("action.gui.open-repeat-alternative-dialog"));
    }

    @Override
    public void updateSectionItems() {
        boolean running = TuxGuitar.getInstance().getPlayer().isRunning();
        TGMeasureImpl measure = this.getTablature().getCaret().getMeasure();
        this.timeSignature.setEnabled(!running);
        this.tempo.setEnabled(!running);
        this.repeatOpen.setEnabled(!running);
        this.repeatOpen.setChecked(measure != null && measure.isRepeatOpen());
        this.repeatClose.setEnabled(!running);
        this.repeatClose.setChecked(measure != null && measure.getRepeatClose() > 0);
        this.repeatAlternative.setEnabled(!running);
        this.repeatAlternative.setChecked(measure != null && measure.getHeader().getRepeatAlternative() > 0);
    }

    @Override
    public void loadSectionProperties() {
        this.timeSignature.setToolTipText(this.getText("composition.timesignature"));
        this.tempo.setToolTipText(this.getText("composition.tempo"));
        this.repeatOpen.setToolTipText(this.getText("repeat.open"));
        this.repeatClose.setToolTipText(this.getText("repeat.close"));
        this.repeatAlternative.setToolTipText(this.getText("repeat.alternative"));
    }

    @Override
    public void loadSectionIcons() {
        this.timeSignature.setImage(this.getIconManager().getImageByName("timesignature.png"));
        this.tempo.setImage(this.getIconManager().getImageByName("tempoicon.png"));
        this.repeatOpen.setImage(this.getIconManager().getImageByName("openrepeat.png"));
        this.repeatClose.setImage(this.getIconManager().getImageByName("closerepeat.png"));
        this.repeatAlternative.setImage(this.getIconManager().getImageByName("repeat_alternative.png"));
    }
}

