/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.ptb;

import app.tuxguitar.io.ptb.base.PTBar;
import app.tuxguitar.io.ptb.base.PTComponent;
import app.tuxguitar.io.ptb.base.PTDirection;
import app.tuxguitar.io.ptb.base.PTPosition;
import app.tuxguitar.io.ptb.base.PTSection;
import app.tuxguitar.io.ptb.base.PTSong;
import app.tuxguitar.io.ptb.base.PTSongInfo;
import app.tuxguitar.io.ptb.base.PTSymbol;
import app.tuxguitar.io.ptb.base.PTTrack;
import app.tuxguitar.io.ptb.base.PTTrackInfo;
import java.util.ArrayList;
import java.util.List;

public class PTSongSynchronizerUtil {
    public static void synchronizeTracks(PTSong src, PTSong dst) {
        PTSongSynchronizerUtil.applyInfo(src.getInfo(), dst.getInfo());
        PTSongSynchronizerUtil.synchronizeTrack(src.getTrack1(), dst.getTrack1());
        PTSongSynchronizerUtil.synchronizeTrack(src.getTrack2(), dst.getTrack2());
    }

    private static void synchronizeTrack(PTTrack src, PTTrack dst) {
        PTSongSynchronizerUtil.applyRepeats(src, dst);
        PTSongSynchronizerUtil.applyInfos(src, dst);
    }

    private static void applyInfo(PTSongInfo src, PTSongInfo dst) {
        src.copy(dst);
    }

    private static void applyInfos(PTTrack src, PTTrack dst) {
        for (PTTrackInfo srcInfo : src.getInfos()) {
            dst.getInfos().add(srcInfo.getClone());
        }
    }

    private static void applyRepeats(PTTrack src, PTTrack dst) {
        PTSongSynchronizerUtil.applyRepeats(src, dst, new PTIndex(0, 0, 0), new PTSongSynchronizerData(), new ArrayList<PTDirection>());
    }

    private static void applyRepeats(PTTrack src, PTTrack dst, PTIndex index, PTSongSynchronizerData rd, List<PTDirection> useds) {
        for (int s = index.s; s < src.getSections().size(); ++s) {
            int p;
            PTSection srcSection = src.getSections().get(s);
            srcSection.sort();
            PTSection dstSection = new PTSection(srcSection.getNumber());
            dstSection.setStaffs(srcSection.getStaffs());
            dst.getSections().add(dstSection);
            int n = p = s == index.s ? index.p : 0;
            while (p < srcSection.getPositions().size()) {
                int c;
                PTPosition srcPosition = srcSection.getPositions().get(p);
                srcPosition.sort();
                PTPosition dstPosition = new PTPosition(srcPosition.getPosition());
                dstSection.getPositions().add(dstPosition);
                int n2 = c = s == index.s && p == index.p ? index.c : 0;
                while (c < srcPosition.getComponents().size()) {
                    PTComponent component = srcPosition.getComponents().get(c);
                    if (!rd.skip) {
                        dstPosition.addComponent(component.getClone());
                    }
                    if (component instanceof PTBar) {
                        PTBar bar = (PTBar)component;
                        if (bar.getRepeatClose() > 0 && rd.repeatStart != null) {
                            ++rd.repeatNumber;
                            rd.repeatInProgress = true;
                            rd.repeatAlternative = false;
                            rd.skip = false;
                            if (rd.repeatNumber < bar.getRepeatClose()) {
                                PTSongSynchronizerUtil.applyRepeats(src, dst, rd.repeatStart, rd, useds);
                                return;
                            }
                            rd.repeatStart = null;
                            rd.repeatNumber = 0;
                        }
                        if (bar.isRepeatStart()) {
                            rd.repeatStart = new PTIndex(s, p, c);
                            if (!rd.repeatInProgress) {
                                rd.repeatNumber = 0;
                            }
                            rd.repeatInProgress = false;
                        }
                    } else if (component instanceof PTSymbol) {
                        PTSymbol symbol = (PTSymbol)component;
                        rd.skip = false;
                        if (!rd.repeatAlternative && (symbol.getEndNumber() & 1) != 0) {
                            boolean validEnding;
                            boolean bl = validEnding = (symbol.getEndNumber() & 1 << rd.repeatNumber) != 0;
                            if (rd.repeatNumber > 0 && !validEnding) {
                                rd.skip = true;
                            }
                            rd.repeatAlternative = true;
                        }
                    } else if (component instanceof PTDirection) {
                        boolean validDirection;
                        PTDirection direction = (PTDirection)component;
                        boolean validRepeat = direction.getRepeat() == 0 || rd.repeatStart != null && rd.repeatNumber + 1 == direction.getRepeat();
                        boolean bl = validDirection = direction.getActiveSymbol() == rd.findActiveSymbol;
                        if (validDirection && validRepeat) {
                            PTIndex coda;
                            PTIndex segno;
                            rd.findActiveSymbol = 0;
                            if (direction.getDirection() == 4) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds)) {
                                    return;
                                }
                            } else if (direction.getDirection() == 5) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds)) {
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, new PTIndex(0, 0, 0), rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 6) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds) && (segno = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 2, s, p)) != null) {
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, segno, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 7) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds) && (segno = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 3, s, p)) != null) {
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, segno, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 8) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds) && (coda = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 0, -1, -1)) != null) {
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, coda, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 9) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds) && (coda = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 1, -1, -1)) != null) {
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, coda, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 10) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds)) {
                                    rd.findActiveSymbol = 1;
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, new PTIndex(0, 0, 0), rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 11) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds)) {
                                    rd.findActiveSymbol = 1;
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, new PTIndex(0, 0, 0), rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 12) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds) && (segno = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 2, s, p)) != null) {
                                    rd.findActiveSymbol = 2;
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, segno, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 13) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds) && (segno = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 2, s, p)) != null) {
                                    rd.findActiveSymbol = 2;
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, segno, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 14) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds) && (segno = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 3, s, p)) != null) {
                                    rd.findActiveSymbol = 3;
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, segno, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 15) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds) && (segno = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 3, s, p)) != null) {
                                    rd.findActiveSymbol = 3;
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, segno, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 16) {
                                if (PTSongSynchronizerUtil.canUseDirection(direction, useds)) {
                                    rd.findActiveSymbol = 1;
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, new PTIndex(0, 0, 0), rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 17) {
                                segno = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 2, s, p);
                                if (segno != null) {
                                    rd.findActiveSymbol = 2;
                                    PTSongSynchronizerUtil.applyRepeats(src, dst, segno, rd, useds);
                                    return;
                                }
                            } else if (direction.getDirection() == 18 && (segno = PTSongSynchronizerUtil.findUnusedDirection(src, useds, 3, s, p)) != null) {
                                rd.findActiveSymbol = 3;
                                PTSongSynchronizerUtil.applyRepeats(src, dst, segno, rd, useds);
                                return;
                            }
                        }
                    }
                    ++c;
                }
                ++p;
            }
        }
    }

    private static boolean canUseDirection(PTDirection direction, List<PTDirection> useds) {
        boolean inUse = false;
        for (int i = 0; i < useds.size() && !inUse; ++i) {
            PTDirection used = useds.get(i);
            if (!used.equals(direction)) continue;
            return false;
        }
        useds.add(direction);
        return true;
    }

    private static PTIndex findUnusedDirection(PTTrack src, List<PTDirection> useds, int value, int sEndIndex, int pEndIndex) {
        return PTSongSynchronizerUtil.findUnusedDirection(src, useds, value, sEndIndex, pEndIndex, 0);
    }

    private static PTIndex findUnusedDirection(PTTrack src, List<PTDirection> useds, int value, int sEndIndex, int pEndIndex, int activeSymbol) {
        for (int s = 0; s < (sEndIndex >= 0 ? sEndIndex + 1 : src.getSections().size()); ++s) {
            PTSection section = src.getSections().get(s);
            for (int p = 0; p < (s == sEndIndex ? pEndIndex + 1 : section.getPositions().size()); ++p) {
                PTPosition position = section.getPositions().get(p);
                for (int c = 0; c < position.getComponents().size(); ++c) {
                    PTDirection direction;
                    PTComponent component = position.getComponents().get(c);
                    if (!(component instanceof PTDirection) || (direction = (PTDirection)component).getDirection() != value || activeSymbol != 0 && direction.getActiveSymbol() != activeSymbol || !PTSongSynchronizerUtil.canUseDirection(direction, useds)) continue;
                    return new PTIndex(s, p, 0);
                }
            }
        }
        return null;
    }

    private static class PTIndex {
        protected int s;
        protected int p;
        protected int c;

        protected PTIndex(int s, int p, int c) {
            this.s = s;
            this.p = p;
            this.c = c;
        }
    }

    private static class PTSongSynchronizerData {
        protected PTIndex repeatStart = null;
        protected boolean repeatInProgress;
        protected int repeatNumber = 0;
        protected boolean repeatAlternative = false;
        protected boolean skip = false;
        protected int findActiveSymbol;

        protected PTSongSynchronizerData() {
        }
    }
}

