/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.svg;

import app.tuxguitar.graphics.control.TGController;
import app.tuxguitar.graphics.control.TGFactoryImpl;
import app.tuxguitar.graphics.control.TGLayoutStyles;
import app.tuxguitar.graphics.control.TGLayoutVertical;
import app.tuxguitar.graphics.control.TGResourceBuffer;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.svg.SVGPainter;
import app.tuxguitar.io.svg.SVGResourceFactory;
import app.tuxguitar.io.svg.SVGStyles;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIFont;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UIRectangle;
import app.tuxguitar.ui.resource.UIResourceFactory;
import app.tuxguitar.util.TGMessagesManager;

public class SVGController
implements TGController {
    private SVGStyles tgStyles;
    private TGSong tgSong;
    private TGSongManager tgSongManager;
    private TGResourceBuffer tgResourceBuffer;
    private UIResourceFactory tgResourceFactory;
    private TGLayoutVertical tgLayout;

    public SVGController(SVGStyles tgStyles) {
        this.tgStyles = tgStyles;
        this.tgSongManager = new TGSongManager();
        this.tgSongManager.setFactory((TGFactory)new TGFactoryImpl());
        this.tgResourceFactory = new SVGResourceFactory();
        this.tgResourceBuffer = new TGResourceBuffer();
        this.tgLayout = new TGLayoutVertical((TGController)this, this.tgStyles.getFlags());
    }

    public TGSongManager getSongManager() {
        return this.tgSongManager;
    }

    public TGSong getSong() {
        return this.tgSong;
    }

    public UIResourceFactory getResourceFactory() {
        return this.tgResourceFactory;
    }

    public TGResourceBuffer getResourceBuffer() {
        return this.tgResourceBuffer;
    }

    public void load(TGSong song) throws TGFileFormatException {
        this.tgSong = song;
        this.tgLayout.loadStyles();
        this.tgLayout.updateSong();
    }

    public void write(StringBuffer svgBuffer) throws Throwable {
        if (this.tgSong != null) {
            UIRectangle svgBounds = new UIRectangle(0.0f, 0.0f, 960.0f, 0.0f);
            SVGPainter svgPainter = new SVGPainter(new StringBuffer());
            this.tgLayout.paint((UIPainter)svgPainter, svgBounds, 0.0f, 0.0f);
            svgBounds.getSize().setHeight(this.tgLayout.getHeight());
            svgBuffer.append("<svg width=\"" + svgBounds.getWidth() + "px\" height=\"" + svgBounds.getHeight() + "px\" xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\">");
            svgBuffer.append("\r\n");
            svgPainter = new SVGPainter(svgBuffer);
            UIColor svgBackground = this.tgResourceFactory.createColor(this.tgStyles.getStyles().getBackgroundColor());
            svgPainter.setBackground(svgBackground);
            svgPainter.initPath(2);
            svgPainter.addRectangle(0.0f, 0.0f, svgBounds.getWidth(), svgBounds.getHeight());
            svgPainter.closePath();
            svgBackground.dispose();
            float headerOffset = 0.0f;
            this.tgLayout.paint((UIPainter)svgPainter, svgBounds, 0.0f, headerOffset += this.paintHeader(svgPainter, svgBounds, 0.0f, 10.0f));
            svgPainter.dispose();
            svgBuffer.append("\r\n");
            svgBuffer.append("</svg>");
        }
    }

    public float paintHeader(UIPainter svgPainter, UIRectangle svgBounds, float startX, float startY) {
        float headerOffset = 0.0f;
        float marginLeft = this.tgLayout.getFirstMeasureSpacing();
        float marginRight = 5.0f;
        float widthMinusMargin = svgBounds.getWidth() - (marginLeft + marginRight);
        float fmTopLine = Math.round(svgPainter.getFMTopLine());
        String songName = this.getSong().getName();
        Object songAuthor = this.getSong().getAuthor();
        String artistName = this.getSong().getArtist();
        String albumName = this.getSong().getAlbum();
        String releaseYear = this.getSong().getDate();
        Object copyright = this.getSong().getCopyright();
        Object transcriber = this.getSong().getTranscriber();
        Object tabCreator = this.getSong().getWriter();
        if (songName != null && songName.length() > 0) {
            svgPainter.setFont(this.getSongNameFont());
            ((SVGPainter)svgPainter).drawString(songName, widthMinusMargin / 2.0f, fmTopLine + startY + (float)Math.round(headerOffset), "middle");
            headerOffset += 20.0f * this.tgLayout.getScale();
        }
        if (artistName != null && artistName.length() > 0) {
            svgPainter.setFont(this.getArtistFont());
            ((SVGPainter)svgPainter).drawString(artistName, widthMinusMargin / 2.0f, fmTopLine + startY + (float)Math.round(headerOffset), "middle");
            headerOffset += 20.0f * this.tgLayout.getScale();
        }
        if (albumName != null && albumName.length() > 0 || releaseYear != null && releaseYear.length() > 0) {
            Object albumNameReleaseYear = "";
            if (albumName != null && albumName.length() > 0) {
                albumNameReleaseYear = (String)albumNameReleaseYear + TGMessagesManager.getProperty((String)"composition.album") + " " + albumName + " ";
            }
            if (releaseYear != null && releaseYear.length() > 0) {
                albumNameReleaseYear = (String)albumNameReleaseYear + "(" + releaseYear + ")";
            }
            svgPainter.setFont(this.getAlbumNameYearFont());
            ((SVGPainter)svgPainter).drawString((String)albumNameReleaseYear, widthMinusMargin / 2.0f, startY + fmTopLine + (float)Math.round(headerOffset), "middle");
            headerOffset += 20.0f * this.tgLayout.getScale();
        }
        if (songAuthor != null && ((String)songAuthor).length() > 0) {
            songAuthor = TGMessagesManager.getProperty((String)"composition.author") + " " + (String)songAuthor;
            svgPainter.setFont(this.getSongAuthorFont());
            ((SVGPainter)svgPainter).drawString((String)songAuthor, widthMinusMargin, fmTopLine + startY + (float)Math.round(headerOffset), "end");
            headerOffset += 10.0f * this.tgLayout.getScale();
        }
        if (copyright != null && ((String)copyright).length() > 0) {
            copyright = TGMessagesManager.getProperty((String)"composition.copyright") + " " + (String)copyright;
            svgPainter.setFont(this.getSongAuthorFont());
            ((SVGPainter)svgPainter).drawString((String)copyright, widthMinusMargin, fmTopLine + startY + (float)Math.round(headerOffset), "end");
            headerOffset += 10.0f * this.tgLayout.getScale();
        }
        if (transcriber != null && ((String)transcriber).length() > 0) {
            transcriber = TGMessagesManager.getProperty((String)"composition.transcriber") + " " + (String)transcriber;
            svgPainter.setFont(this.getSongAuthorFont());
            ((SVGPainter)svgPainter).drawString((String)transcriber, widthMinusMargin, fmTopLine + startY + (float)Math.round(headerOffset), "end");
            headerOffset += 10.0f * this.tgLayout.getScale();
        }
        if (tabCreator != null && ((String)tabCreator).length() > 0) {
            tabCreator = TGMessagesManager.getProperty((String)"composition.writer") + " " + (String)tabCreator;
            svgPainter.setFont(this.getSongAuthorFont());
            ((SVGPainter)svgPainter).drawString((String)tabCreator, widthMinusMargin, fmTopLine + startY + (float)Math.round(headerOffset), "end");
            headerOffset += 20.0f * this.tgLayout.getScale();
        }
        return headerOffset;
    }

    public TGLayoutStyles getStyles() {
        return this.tgStyles.getStyles();
    }

    public int getTrackSelection() {
        return this.tgStyles.getTrack();
    }

    public boolean isRunning(TGBeat beat) {
        return false;
    }

    public boolean isRunning(TGMeasure measure) {
        return false;
    }

    public boolean isLoopSHeader(TGMeasureHeader measureHeader) {
        return false;
    }

    public boolean isLoopEHeader(TGMeasureHeader measureHeader) {
        return false;
    }

    private UIFont getSongNameFont() {
        String textFont = this.tgStyles.getStyles().getTextFont().getName();
        UIFont songNameFont = this.tgResourceFactory.createFont(textFont, 16.0f * this.tgLayout.getFontScale(), true, false);
        return songNameFont;
    }

    private UIFont getArtistFont() {
        String textFont = this.tgStyles.getStyles().getTextFont().getName();
        UIFont artistFont = this.tgResourceFactory.createFont(textFont, 12.0f * this.tgLayout.getFontScale(), true, false);
        return artistFont;
    }

    private UIFont getAlbumNameYearFont() {
        String textFont = this.tgStyles.getStyles().getTextFont().getName();
        UIFont albumNameYearFont = this.tgResourceFactory.createFont(textFont, 10.0f * this.tgLayout.getFontScale(), true, false);
        return albumNameYearFont;
    }

    private UIFont getSongAuthorFont() {
        String textFont = this.tgStyles.getStyles().getTextFont().getName();
        UIFont songAuthorFont = this.tgResourceFactory.createFont(textFont, 8.0f * this.tgLayout.getFontScale(), true, false);
        return songAuthorFont;
    }
}

