/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.pdf;

import app.tuxguitar.app.TuxGuitar;
import app.tuxguitar.app.ui.TGApplication;
import app.tuxguitar.app.view.util.TGDialogUtil;
import app.tuxguitar.io.pdf.PDFSettings;
import app.tuxguitar.io.pdf.PDFSettingsManager;
import app.tuxguitar.ui.UIFactory;
import app.tuxguitar.ui.event.UISelectionEvent;
import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.layout.UILayout;
import app.tuxguitar.ui.layout.UITableLayout;
import app.tuxguitar.ui.widget.UIButton;
import app.tuxguitar.ui.widget.UIContainer;
import app.tuxguitar.ui.widget.UIControl;
import app.tuxguitar.ui.widget.UILabel;
import app.tuxguitar.ui.widget.UILegendPanel;
import app.tuxguitar.ui.widget.UIPanel;
import app.tuxguitar.ui.widget.UISpinner;
import app.tuxguitar.ui.widget.UIWindow;
import app.tuxguitar.util.TGContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFSettingsDialog {
    private TGContext context;
    private PDFSettings settings;
    private int nbSettings;
    private Map<String, UISpinner> spinnerMap;

    public PDFSettingsDialog(TGContext context) {
        this.context = context;
        this.settings = PDFSettingsManager.getInstance((TGContext)context).getSettings();
        this.spinnerMap = new HashMap<String, UISpinner>();
    }

    public void configure(UIWindow parent) {
        if (this.settings != null) {
            UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
            UITableLayout dialogLayout = new UITableLayout();
            final UIWindow dialog = uiFactory.createWindow(parent, true, false);
            dialog.setLayout((UILayout)dialogLayout);
            dialog.setText(TuxGuitar.getProperty((String)"pdf.advanced-settings-dialog"));
            UITableLayout settingsLayout = new UITableLayout();
            UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
            group.setLayout((UILayout)settingsLayout);
            group.setText(TuxGuitar.getProperty((String)"pdf.settings"));
            dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            this.nbSettings = 0;
            List keys = this.settings.getOrderedKeys();
            for (String key : keys) {
                String name;
                if (key == (name = TuxGuitar.getProperty((String)key))) continue;
                this.addSetting(key, name, settingsLayout, uiFactory, group);
            }
            this.populateValues();
            UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
            UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
            buttons.setLayout((UILayout)buttonsLayout);
            dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
            UIButton buttonDefault = uiFactory.createButton((UIContainer)buttons);
            buttonDefault.setText(TuxGuitar.getProperty((String)"defaults"));
            buttonDefault.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    PDFSettingsDialog.this.settings = new PDFSettings();
                    PDFSettingsDialog.this.populateValues();
                }
            });
            buttonsLayout.set((UIControl)buttonDefault, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
            buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
            buttonOK.setDefaultButton();
            buttonOK.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    PDFSettingsDialog.this.saveSettings();
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
            buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
            buttonCancel.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    dialog.dispose();
                }
            });
            buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
            buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
            TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
        }
    }

    private void addSetting(String key, String settingName, UITableLayout layout, UIFactory uiFactory, UILegendPanel panel) {
        ++this.nbSettings;
        UILabel label = uiFactory.createLabel((UIContainer)panel);
        label.setText(settingName + ":");
        layout.set((UIControl)label, Integer.valueOf(this.nbSettings), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(true));
        UISpinner spinner = uiFactory.createSpinner((UIContainer)panel);
        spinner.setMinimum(0);
        layout.set((UIControl)spinner, Integer.valueOf(this.nbSettings), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.spinnerMap.put(key, spinner);
    }

    private void populateValues() {
        Map configMap = this.settings.getSettingsMap();
        for (String key : this.spinnerMap.keySet()) {
            this.spinnerMap.get(key).setValue(Math.round(((Float)configMap.get(key)).floatValue()));
        }
    }

    private void saveSettings() {
        PDFSettingsManager mgr = PDFSettingsManager.getInstance((TGContext)this.context);
        for (String key : this.spinnerMap.keySet()) {
            mgr.setSetting(key, (float)this.spinnerMap.get(key).getValue());
        }
        mgr.saveSettings();
    }
}

