/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.jack.synthesizer.settings;

import app.tuxguitar.event.TGEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.jack.synthesizer.settings.JackChannelSettingsDialog;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.TGException;
import app.tuxguitar.util.TGSynchronizer;

public class JackMidiPlayerListener
implements TGEventListener {
    private TGContext context;
    private JackChannelSettingsDialog jackChannelSettingsDialog;

    public JackMidiPlayerListener(TGContext context, JackChannelSettingsDialog jackChannelSettingsDialog) {
        this.context = context;
        this.jackChannelSettingsDialog = jackChannelSettingsDialog;
    }

    public void updateControls() {
        this.jackChannelSettingsDialog.updateControls();
    }

    public void updateControlsSynchronized() {
        TGSynchronizer.getInstance((TGContext)this.context).executeLater(new Runnable(){

            @Override
            public void run() throws TGException {
                JackMidiPlayerListener.this.updateControls();
            }
        });
    }

    public void processStarted() {
        this.updateControlsSynchronized();
    }

    public void processStopped() {
        this.updateControlsSynchronized();
    }

    public void processEvent(TGEvent event) {
        if ("midi-player-notification".equals(event.getEventType())) {
            int type = (Integer)event.getAttribute("notificationType");
            if (type == 1) {
                this.processStarted();
            } else if (type == 2) {
                this.processStopped();
            }
        }
    }
}

