/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.resource;

import app.tuxguitar.ui.resource.UIKey;
import app.tuxguitar.util.TGKeyBindFormatter;
import java.util.ArrayList;
import java.util.List;

public class UIKeyCombination {
    private List<UIKey> keys = new ArrayList<UIKey>();

    public UIKeyCombination(List<UIKey> keys) {
        if (keys != null) {
            this.keys.addAll(keys);
        }
    }

    public UIKeyCombination() {
        this(new ArrayList<UIKey>());
    }

    public List<UIKey> getKeys() {
        return this.keys;
    }

    public List<String> getKeyStrings() {
        ArrayList<String> keyStrings = new ArrayList<String>();
        for (UIKey key : this.keys) {
            keyStrings.add(key.toString());
        }
        return keyStrings;
    }

    public boolean contains(UIKey key) {
        return this.keys.contains(key);
    }

    public boolean equals(Object o) {
        UIKeyCombination keyCombination;
        if (o instanceof UIKeyCombination && (keyCombination = (UIKeyCombination)o).getKeys().size() == this.getKeys().size()) {
            for (UIKey key : keyCombination.getKeys()) {
                if (this.contains(key)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return TGKeyBindFormatter.defaultTranslate(this.getKeyStrings());
    }

    public Object clone() {
        return new UIKeyCombination(this.getKeys());
    }
}

