/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.app.tools.custom.tuner;

public class TGTunerQueue {
    int QUEUE_SIZE = 5;
    protected int head = 0;
    protected double[] queue = new double[this.QUEUE_SIZE];
    private double[] similars = new double[this.QUEUE_SIZE];
    private final double upperTolerance = 1.05;
    private final double lowerTolerance = 0.95;

    public TGTunerQueue() {
        this.clear();
    }

    public void add(double newValue) {
        ++this.head;
        this.head %= this.QUEUE_SIZE;
        this.queue[this.head] = newValue;
    }

    public double getFreqApproximation() {
        int i;
        for (i = 0; i < this.QUEUE_SIZE; ++i) {
            this.similars[i] = -2.0;
        }
        for (i = 0; i < this.QUEUE_SIZE; ++i) {
            if (this.queue[i] == -1.0) continue;
            for (int j = 0; j < this.QUEUE_SIZE; ++j) {
                if (this.queue[i] > this.queue[j] * this.lowerTolerance && this.queue[i] < this.queue[j] * this.upperTolerance) {
                    this.similars[i] = this.similars[i] + 2.0;
                }
                if (this.queue[i] / 2.0 > this.queue[j] * this.lowerTolerance && this.queue[i] / 2.0 < this.queue[j] * this.upperTolerance) {
                    int n = i;
                    this.similars[n] = this.similars[n] + 1.0;
                }
                if (!(this.queue[i] * 2.0 > this.queue[j] * this.lowerTolerance) || !(this.queue[i] * 2.0 < this.queue[j] * this.upperTolerance)) continue;
                int n = i;
                this.similars[n] = this.similars[n] + 1.0;
            }
        }
        int maxIndex = 0;
        for (int i2 = 1; i2 < this.QUEUE_SIZE; ++i2) {
            if (!(this.similars[i2] >= this.similars[maxIndex])) continue;
            maxIndex = i2;
        }
        return this.queue[maxIndex];
    }

    public void clear() {
        for (int i = 0; i < this.QUEUE_SIZE; ++i) {
            this.queue[i] = -1.0;
        }
        this.head = 0;
    }
}

