/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.action;

import app.tuxguitar.action.TGAction;
import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.action.TGActionContextFactory;
import app.tuxguitar.action.TGActionErrorEvent;
import app.tuxguitar.action.TGActionException;
import app.tuxguitar.action.TGActionInterceptor;
import app.tuxguitar.action.TGActionPostExecutionEvent;
import app.tuxguitar.action.TGActionPreExecutionEvent;
import app.tuxguitar.event.TGEventListener;
import app.tuxguitar.event.TGEventManager;
import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TGActionManager {
    private TGContext context;
    private Map<String, TGAction> actions;
    private List<TGActionInterceptor> interceptors;
    private TGActionContextFactory actionContextFactory;

    private TGActionManager(TGContext context) {
        this.context = context;
        this.actions = new HashMap<String, TGAction>();
        this.interceptors = new ArrayList<TGActionInterceptor>();
        this.actionContextFactory = null;
    }

    public void mapAction(String id, TGAction action) {
        this.actions.put(id, action);
    }

    public void unmapAction(String id) {
        if (this.actions.containsKey(id)) {
            this.actions.remove(id);
        }
    }

    public TGAction getAction(String id) {
        if (this.actions.containsKey(id)) {
            return this.actions.get(id);
        }
        return null;
    }

    public Map<String, TGAction> getActions() {
        return this.actions;
    }

    public TGActionContext createActionContext() throws TGActionException {
        if (this.actionContextFactory != null) {
            return this.actionContextFactory.createActionContext();
        }
        return null;
    }

    public void execute(String id) throws TGActionException {
        this.execute(id, this.createActionContext());
    }

    public void execute(String id, TGActionContext context) throws TGActionException {
        try {
            TGAction action = this.getAction(id);
            if (action != null && !this.intercept(id, context)) {
                this.doPreExecution(id, context);
                action.execute(context);
                this.doPostExecution(id, context);
            }
        }
        catch (TGActionException tgActionException) {
            this.fireErrorEvent(id, context, tgActionException);
            throw tgActionException;
        }
        catch (Throwable throwable) {
            this.fireErrorEvent(id, context, throwable);
            throw new TGActionException(throwable);
        }
    }

    public boolean intercept(String id, TGActionContext context) throws TGActionException {
        for (TGActionInterceptor interceptor : this.interceptors) {
            if (!interceptor.intercept(id, context)) continue;
            return true;
        }
        return false;
    }

    public void doPreExecution(String id, TGActionContext context) throws TGActionException {
        TGEventManager.getInstance(this.context).fireEvent(new TGActionPreExecutionEvent(id, context));
    }

    public void doPostExecution(String id, TGActionContext context) throws TGActionException {
        TGEventManager.getInstance(this.context).fireEvent(new TGActionPostExecutionEvent(id, context));
    }

    public void fireErrorEvent(String id, TGActionContext context, Throwable throwable) throws TGActionException {
        TGEventManager.getInstance(this.context).fireEvent(new TGActionErrorEvent(id, context, throwable));
    }

    public void addPreExecutionListener(TGEventListener listener) {
        TGEventManager.getInstance(this.context).addListener("action-pre-execution", listener);
    }

    public void removePreExecutionListener(TGEventListener listener) {
        TGEventManager.getInstance(this.context).removeListener("action-pre-execution", listener);
    }

    public void addPostExecutionListener(TGEventListener listener) {
        TGEventManager.getInstance(this.context).addListener("action-post-execution", listener);
    }

    public void removePostExecutionListener(TGEventListener listener) {
        TGEventManager.getInstance(this.context).removeListener("action-post-execution", listener);
    }

    public void addErrorListener(TGEventListener listener) {
        TGEventManager.getInstance(this.context).addListener("action-error", listener);
    }

    public void removeErrorListener(TGEventListener listener) {
        TGEventManager.getInstance(this.context).removeListener("action-error", listener);
    }

    public void addInterceptor(TGActionInterceptor interceptor) {
        if (!this.interceptors.contains(interceptor)) {
            this.interceptors.add(interceptor);
        }
    }

    public void removeInterceptor(TGActionInterceptor interceptor) {
        if (this.interceptors.contains(interceptor)) {
            this.interceptors.remove(interceptor);
        }
    }

    public void setActionContextFactory(TGActionContextFactory actionContextFactory) {
        this.actionContextFactory = actionContextFactory;
    }

    public static TGActionManager getInstance(TGContext context) {
        return TGSingletonUtil.getInstance(context, TGActionManager.class.getName(), new TGSingletonFactory<TGActionManager>(){

            @Override
            public TGActionManager createInstance(TGContext context) {
                return new TGActionManager(context);
            }
        });
    }
}

