/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.graphics.control;

import app.tuxguitar.graphics.control.TGBeatImpl;
import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGResourceBuffer;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.resource.UIColor;
import app.tuxguitar.ui.resource.UIFont;
import app.tuxguitar.ui.resource.UIImage;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UIResourceFactory;

public class TGChordImpl
extends TGChord {
    public static final int MAX_FRETS = 6;
    private int style;
    private float posX;
    private float posY;
    private float width;
    private float height;
    private int tonic;
    private float diagramWidth;
    private float diagramHeight;
    private float nameWidth;
    private float nameHeight;
    private UIImage diagram;
    private UIColor foregroundColor;
    private UIColor backgroundColor;
    private UIColor noteColor;
    private UIColor tonicColor;
    private UIColor color;
    private UIFont font;
    private UIFont firstFretFont;
    private float firstFretSpacing;
    private float stringSpacing;
    private float fretSpacing;
    private float noteSize;
    private float lineWidth;
    private boolean editing;
    private Object registryKey;

    public TGChordImpl(int length) {
        super(length);
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean editing) {
        this.editing = editing;
    }

    public void setPosX(float posX) {
        this.posX = posX;
    }

    public void setPosY(float posY) {
        this.posY = posY;
    }

    public float getPosY() {
        return this.posY;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setTonic(int tonic) {
        if (!this.isDisposed() && this.tonic != tonic) {
            this.dispose();
        }
        this.tonic = tonic;
    }

    public UIColor getForegroundColor() {
        return this.foregroundColor;
    }

    public void setForegroundColor(UIColor foregroundColor) {
        if (!this.isDisposed() && !this.isSameColor(this.foregroundColor, foregroundColor)) {
            this.dispose();
        }
        this.foregroundColor = foregroundColor;
    }

    public UIColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(UIColor backgroundColor) {
        if (!this.isDisposed() && !this.isSameColor(this.backgroundColor, backgroundColor)) {
            this.dispose();
        }
        this.backgroundColor = backgroundColor;
    }

    public UIColor getColor() {
        return this.color;
    }

    public void setColor(UIColor color) {
        if (!this.isDisposed() && !this.isSameColor(this.color, color)) {
            this.dispose();
        }
        this.color = color;
    }

    public UIColor getNoteColor() {
        return this.noteColor;
    }

    public void setNoteColor(UIColor noteColor) {
        if (!this.isDisposed() && !this.isSameColor(this.noteColor, noteColor)) {
            this.dispose();
        }
        this.noteColor = noteColor;
    }

    public UIColor getTonicColor() {
        return this.tonicColor;
    }

    public void setTonicColor(UIColor tonicColor) {
        if (!this.isDisposed() && !this.isSameColor(this.tonicColor, tonicColor)) {
            this.dispose();
        }
        this.tonicColor = tonicColor;
    }

    public float getFirstFretSpacing() {
        return this.firstFretSpacing;
    }

    public void setFirstFretSpacing(float firstFretSpacing) {
        if (!this.isDisposed() && this.firstFretSpacing != firstFretSpacing) {
            this.dispose();
        }
        this.firstFretSpacing = firstFretSpacing;
    }

    public float getFretSpacing() {
        return this.fretSpacing;
    }

    public void setFretSpacing(float fretSpacing) {
        if (!this.isDisposed() && this.fretSpacing != fretSpacing) {
            this.dispose();
        }
        this.fretSpacing = fretSpacing;
    }

    public float getStringSpacing() {
        return this.stringSpacing;
    }

    public void setStringSpacing(float stringSpacing) {
        if (!this.isDisposed() && this.stringSpacing != stringSpacing) {
            this.dispose();
        }
        this.stringSpacing = stringSpacing;
    }

    public float getNoteSize() {
        return this.noteSize;
    }

    public void setNoteSize(float noteSize) {
        if (!this.isDisposed() && this.noteSize != noteSize) {
            this.dispose();
        }
        this.noteSize = noteSize;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float lineWidth) {
        if (!this.isDisposed() && this.lineWidth != lineWidth) {
            this.dispose();
        }
        this.lineWidth = lineWidth;
    }

    public UIFont getFont() {
        return this.font;
    }

    public void setFont(UIFont font) {
        if (!this.isDisposed() && !this.isSameFont(this.font, font)) {
            this.dispose();
        }
        this.font = font;
    }

    public UIFont getFirstFretFont() {
        return this.firstFretFont;
    }

    public void setFirstFretFont(UIFont firstFretFont) {
        if (!this.isDisposed() && !this.isSameFont(this.firstFretFont, firstFretFont)) {
            this.dispose();
        }
        this.firstFretFont = firstFretFont;
    }

    public void paint(TGLayout layout, UIPainter painter, float fromX, float fromY) {
        layout.setChordStyle(this, this.getBeatImpl().getMeasureImpl().isPlaying(layout));
        this.setPosY(this.getPaintPosition(6));
        this.setEditing(false);
        this.update(painter, layout.getComponent().getResourceFactory(), layout.isBufferEnabled() ? layout.getResourceBuffer() : null);
        this.paint(painter, this.getBeatImpl().getSpacing(layout) + fromX + (float)Math.round(4.0f * layout.getScale()), fromY);
    }

    public void paint(UIPainter painter, float fromX, float fromY) {
        float x = fromX + this.getPosX();
        float y = fromY + this.getPosY();
        if ((this.style & 0x20) != 0) {
            if (this.diagram != null) {
                painter.drawImage(this.diagram, x - (this.diagramWidth - this.getFirstFretSpacing()) / 2.0f - this.getFirstFretSpacing(), y);
            } else {
                this.paintDiagram(painter, x - (this.diagramWidth - this.getFirstFretSpacing()) / 2.0f - this.getFirstFretSpacing(), y);
            }
            y += this.diagramHeight;
        }
        if ((this.style & 0x10) != 0 && this.getName() != null && this.getName().length() > 0) {
            painter.setFont(this.getFont());
            painter.setForeground(this.getForegroundColor());
            painter.setBackground(this.getBackgroundColor());
            painter.drawString(this.getName(), x - this.nameWidth / 2.0f, y + painter.getFMTopLine());
        }
    }

    public void update(UIPainter painter, UIResourceFactory factory, TGResourceBuffer buffer) {
        this.width = 0.0f;
        this.height = 0.0f;
        if (this.getFirstFret() <= 0) {
            this.calculateFirstFret();
        }
        if ((this.style & 0x10) != 0) {
            this.updateName(painter);
            this.width = Math.max(this.width, this.nameWidth);
            this.height += this.nameHeight;
        }
        if ((this.style & 0x20) != 0) {
            this.updateDiagram(buffer != null ? factory : null, buffer);
            this.width = Math.max(this.width, this.diagramWidth);
            this.height += this.diagramHeight;
        }
    }

    protected void updateName(UIPainter painter) {
        String name = this.getName();
        if (painter == null || name == null || name.length() == 0) {
            this.nameWidth = 0.0f;
            this.nameHeight = 0.0f;
            return;
        }
        this.nameWidth = painter.getFMWidth(name);
        this.nameHeight = painter.getFMHeight();
    }

    protected void updateDiagram(UIResourceFactory bufferFactory, TGResourceBuffer resourceBuffer) {
        UIFont font = this.getFirstFretFont();
        this.diagramWidth = this.getStringSpacing() + this.getStringSpacing() * (float)this.countStrings() + (font != null ? this.getFirstFretSpacing() : 0.0f);
        this.diagramHeight = this.getFretSpacing() + this.getFretSpacing() * 6.0f;
        if (bufferFactory != null && (this.diagram == null || this.diagram.isDisposed())) {
            this.diagram = bufferFactory.createImage(this.diagramWidth, this.diagramHeight);
            UIPainter painterBuffer = this.diagram.createPainter();
            this.paintDiagram(painterBuffer, 0.0f, 0.0f);
            painterBuffer.dispose();
            if (this.registryKey == null) {
                this.registerBuffer(resourceBuffer);
            }
            resourceBuffer.setResource(this.registryKey, this.diagram);
        }
    }

    protected void paintDiagram(UIPainter painter, float fromX, float fromY) {
        float y2;
        float y1;
        float x2;
        float x1;
        int i;
        UIFont font = this.getFirstFretFont();
        painter.setBackground(this.getBackgroundColor());
        painter.setLineWidth(this.getLineWidth());
        painter.initPath(2);
        painter.addRectangle(fromX, fromY, this.diagramWidth, this.diagramHeight);
        painter.closePath();
        painter.setForeground(this.getColor());
        float x = fromX + this.getStringSpacing();
        float y = fromY + this.getFretSpacing();
        if (font != null) {
            String firstFretString = Integer.toString(this.getFirstFret());
            painter.setFont(font);
            painter.drawString(firstFretString, fromX + (this.getFirstFretSpacing() - painter.getFMWidth(firstFretString)), y + (this.getFretSpacing() / 2.0f + painter.getFMMiddleLine()));
            x += this.getFirstFretSpacing();
        }
        painter.initPath();
        painter.setAntialias(false);
        for (i = 0; i < this.getStrings().length; ++i) {
            x1 = x + (float)i * this.getStringSpacing();
            x2 = x + (float)i * this.getStringSpacing();
            y1 = y;
            y2 = y + this.getFretSpacing() * 5.0f;
            painter.moveTo(x1, y1);
            painter.lineTo(x2, y2);
        }
        painter.closePath();
        painter.initPath();
        painter.setAntialias(false);
        for (i = 0; i < 6; ++i) {
            x1 = x;
            x2 = x + this.getStringSpacing() * (float)(this.countStrings() - 1);
            y1 = y + (float)i * this.getFretSpacing();
            y2 = y + (float)i * this.getFretSpacing();
            painter.moveTo(x1, y1);
            painter.lineTo(x2, y2);
        }
        painter.closePath();
        for (i = 0; i < this.getStrings().length; ++i) {
            int fret = this.getFretValue(i);
            float noteX = x + (this.getStringSpacing() * (float)(this.countStrings() - 1) - this.getStringSpacing() * (float)i);
            if (fret < 0) {
                painter.initPath();
                painter.moveTo(noteX - this.getNoteSize() / 2.0f, fromY);
                painter.lineTo(noteX + this.getNoteSize() / 2.0f, fromY + this.getNoteSize());
                painter.moveTo(noteX + this.getNoteSize() / 2.0f, fromY);
                painter.lineTo(noteX - this.getNoteSize() / 2.0f, fromY + this.getNoteSize());
                painter.closePath();
                continue;
            }
            if (fret == 0) {
                painter.initPath();
                painter.addCircle(noteX, fromY + this.getNoteSize() / 2.0f, this.getNoteSize());
                painter.closePath();
                continue;
            }
            painter.setBackground(this.isTonicFret(i, fret) ? this.getTonicColor() : this.getNoteColor());
            painter.initPath(2);
            float noteY = y + (this.getFretSpacing() * (float)(fret -= this.getFirstFret() - 1) - this.getFretSpacing() / 2.0f);
            painter.addCircle(noteX, noteY, this.getNoteSize() + 1.0f);
            painter.closePath();
        }
    }

    public void calculateFirstFret() {
        int minimum = -1;
        int maximum = -1;
        boolean zero = false;
        for (int i = 0; i < this.getStrings().length; ++i) {
            int fretValue = this.getFretValue(i);
            boolean bl = zero = zero || fretValue == 0;
            if (fretValue <= 0) continue;
            minimum = minimum < 0 ? fretValue : Math.min(minimum, fretValue);
            maximum = Math.max(maximum, fretValue);
        }
        int firstFret = zero && maximum < 6 ? 1 : minimum;
        this.setFirstFret(Math.max(firstFret, 1));
        for (int i = 0; i < this.getStrings().length; ++i) {
            int fretValue = this.getFretValue(i);
            if (fretValue - firstFret < 5) continue;
            this.getStrings()[i] = -1;
        }
    }

    private boolean isTonicFret(int stringIndex, int fret) {
        TGString string;
        TGTrack track;
        if (this.tonic >= 0 && (track = this.getBeat().getMeasure().getTrack()) != null && track.stringCount() > stringIndex && (string = track.getString(stringIndex + 1)) != null) {
            return (string.getValue() + fret) % 12 == this.tonic;
        }
        return false;
    }

    public void registerBuffer(TGResourceBuffer resourceBuffer) {
        this.registerBuffer(resourceBuffer, this);
    }

    public void registerBuffer(TGResourceBuffer resourceBuffer, Object registryKey) {
        this.registryKey = registryKey;
        resourceBuffer.register(this.registryKey);
    }

    public boolean isDisposed() {
        return this.diagram == null || this.diagram.isDisposed();
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.diagram.dispose();
        }
    }

    public float getPosX() {
        return this.isEditing() ? this.posX : this.getBeatImpl().getPosX();
    }

    public float getPaintPosition(int index) {
        return this.getBeatImpl().getMeasureImpl().getTs().getPosition(index);
    }

    public TGBeatImpl getBeatImpl() {
        return (TGBeatImpl)this.getBeat();
    }

    private boolean isSameFont(UIFont f1, UIFont f2) {
        if (f1 == null && f2 == null) {
            return true;
        }
        if (f1 != null && f2 != null && !f1.isDisposed() && !f2.isDisposed()) {
            boolean sameName = f1.getName().equals(f2.getName());
            boolean sameBold = f1.isBold() == f2.isBold();
            boolean sameItalic = f1.isItalic() == f2.isItalic();
            boolean sameHeight = f1.getHeight() == f2.getHeight();
            return sameName && sameBold && sameItalic && sameHeight;
        }
        return false;
    }

    private boolean isSameColor(UIColor c1, UIColor c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 != null && c2 != null && !c1.isDisposed() && !c2.isDisposed()) {
            return c1.getRed() == c2.getRed() && c1.getGreen() == c2.getGreen() && c1.getBlue() == c2.getBlue();
        }
        return false;
    }

    @Override
    public void addFretValue(int string, int fret) {
        if (!this.isDisposed() && this.getFretValue(string) != fret) {
            this.dispose();
        }
        super.addFretValue(string, fret);
    }

    @Override
    public void setFirstFret(int firstFret) {
        if (!this.isDisposed() && this.getFirstFret() != firstFret) {
            this.dispose();
        }
        super.setFirstFret(firstFret);
    }
}

