/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.graphics.control;

import app.tuxguitar.graphics.control.TGController;
import app.tuxguitar.graphics.control.TGLayout;
import app.tuxguitar.graphics.control.TGLyricImpl;
import app.tuxguitar.graphics.control.TGMeasureImpl;
import app.tuxguitar.graphics.control.TGTrackImpl;
import app.tuxguitar.graphics.control.TGTrackSpacing;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.ui.resource.UIPainter;
import app.tuxguitar.ui.resource.UIRectangle;
import java.util.Iterator;

public class TGLayoutHorizontal
extends TGLayout {
    public TGLayoutHorizontal(TGController controller, int style) {
        super(controller, style);
    }

    @Override
    public int getMode() {
        return 2;
    }

    @Override
    public void paintSong(UIPainter painter, UIRectangle clientArea, float fromX, float fromY) {
        this.setWidth(0.0f);
        this.setHeight(0.0f);
        this.clearTrackPositions();
        int style = this.getStyle();
        int number = this.getComponent().getTrackSelection();
        float posY = Math.round(fromY + this.getFirstTrackSpacing());
        float height = this.getFirstTrackSpacing();
        Iterator<TGTrack> tracks = this.getSong().getTracks();
        while (tracks.hasNext()) {
            TGTrackImpl track = (TGTrackImpl)tracks.next();
            if (number >= 0 && track.getNumber() != number) continue;
            TGTrackSpacing ts = new TGTrackSpacing(this);
            ts.setSize(8, (style & 4) != 0 ? this.getScoreLineSpacing() * 5.0f : 0.0f);
            ((TGLyricImpl)track.getLyrics()).start();
            float maxY = 0.0f;
            float minY = 0.0f;
            if ((style & 8) == 0 && (style & 4) != 0) {
                maxY = this.getScoreLineSpacing() * 4.0f + this.getScoreLineSpacing() * 4.0f;
                minY = -(this.getScoreLineSpacing() * 3.0f);
            }
            Iterator<TGMeasure> measures = track.getMeasures();
            while (measures.hasNext()) {
                TGMeasureImpl measure = (TGMeasureImpl)measures.next();
                maxY = measure.getMaxY() > maxY ? measure.getMaxY() : maxY;
                minY = measure.getMinY() < minY ? measure.getMinY() : minY;
                measure.registerSpacing(this, ts);
            }
            ts.setSize(7, (style & 4) != 0 ? Math.abs(minY) : 0.0f);
            if ((style & 4) != 0 && maxY > track.getScoreHeight()) {
                ts.setSize(9, maxY - track.getScoreHeight());
            }
            if ((style & 8) != 0) {
                ts.setSize(14, (style & 4) != 0 ? this.getMinScoreTabSpacing() : Math.max(Math.abs(minY), this.getStringSpacing()));
                ts.setSize(15, (style & 4) != 0 ? track.getTabHeight() + this.getStringSpacing() + 1.0f : Math.max(maxY, track.getTabHeight() + this.getStringSpacing() + 1.0f));
            }
            ts.setSize(16, 10.0f);
            this.checkDefaultSpacing(ts);
            this.paintMeasures(track, painter, fromX, posY, ts, clientArea);
            this.paintLines(track, ts, painter, fromX + (this.getWidth() + 2.0f * this.getScale()), posY, clientArea.getWidth() - (fromX + this.getWidth()));
            float trackHeight = ts.getSize();
            this.addTrackPosition(track.getNumber(), posY, trackHeight);
            float trackHeightWithSpacing = Math.round(trackHeight + this.getTrackSpacing() + 0.5f);
            posY += trackHeightWithSpacing;
            height += trackHeightWithSpacing;
        }
        if (this.getWidth() > clientArea.getWidth()) {
            this.setWidth(this.getWidth() + this.getFirstMeasureSpacing());
        }
        this.setHeight(height);
    }

    public void paintMeasures(TGTrackImpl track, UIPainter painter, float fromX, float fromY, TGTrackSpacing ts, UIRectangle clientArea) {
        float posX = Math.round(fromX + this.getFirstMeasureSpacing());
        float posY = fromY;
        float width = this.getFirstMeasureSpacing();
        Iterator<TGMeasure> measures = track.getMeasures();
        while (measures.hasNext()) {
            boolean isAtY;
            TGMeasureImpl measure = (TGMeasureImpl)measures.next();
            measure.setPosX(posX);
            measure.setPosY(posY);
            measure.setTs(ts);
            ((TGLyricImpl)track.getLyrics()).setCurrentMeasure(measure);
            float measureWidth = measure.getWidth(this);
            float measureWidthRounded = this.isBufferEnabled() ? (float)Math.round(measureWidth) : measureWidth;
            float measureSpacing = measureWidthRounded - measureWidth;
            boolean isAtX = posX + measure.getWidth(this) > clientArea.getX() - 100.0f && posX < clientArea.getX() + clientArea.getWidth() + measure.getWidth(this) + 100.0f;
            boolean bl = isAtY = posY + ts.getSize() > clientArea.getY() && posY < clientArea.getY() + clientArea.getHeight() + 80.0f;
            if (isAtX && isAtY) {
                this.paintMeasure(measure, painter, measureSpacing);
                ((TGLyricImpl)track.getLyrics()).paintCurrentNoteBeats(painter, this, measure, posX, posY);
            } else {
                measure.setOutOfBounds(true);
            }
            posX += measureWidthRounded;
            width += measureWidthRounded;
        }
        this.setWidth(Math.max(this.getWidth(), width));
    }
}

