/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.sequencer;

import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.impl.sequencer.MidiEvent;
import app.tuxguitar.player.impl.sequencer.MidiSequencerImpl;
import java.util.ArrayList;
import java.util.List;

public class MidiEventPlayer {
    private MidiSequencerImpl sequencer;
    private List<MidiEvent> events;
    private long tick;
    private long lastTick;
    private boolean reset;

    public MidiEventPlayer(MidiSequencerImpl sequencer) {
        this.sequencer = sequencer;
        this.events = new ArrayList<MidiEvent>();
        this.reset();
    }

    public void process() throws MidiPlayerException {
        this.lastTick = this.tick;
        this.tick = this.sequencer.getTickPosition();
        for (int i = 0; i < this.events.size(); ++i) {
            MidiEvent event = this.events.get(i);
            if (!this.shouldSend(event, this.tick, this.lastTick)) continue;
            this.sequencer.sendEvent(event);
        }
        this.reset = false;
    }

    private boolean shouldSend(MidiEvent event, long tick, long lastTick) {
        if (event.getTick() > tick) {
            return false;
        }
        if (event.getTick() > lastTick) {
            if (event.getTrack() != -1) {
                if (this.sequencer.getMidiTrackController().isMute(event.getTrack())) {
                    return false;
                }
                if (this.sequencer.getMidiTrackController().isAnySolo() && !this.sequencer.getMidiTrackController().isSolo(event.getTrack())) {
                    return false;
                }
            }
            return true;
        }
        if (this.reset) {
            if (event.getType() == 1) {
                return true;
            }
            if (event.getType() == 5) {
                return true;
            }
            if (event.getType() == 4) {
                return true;
            }
        }
        return false;
    }

    public void addEvent(MidiEvent event) {
        this.events.add(event);
    }

    public void clearEvents() {
        this.events.clear();
    }

    public void reset() {
        this.tick = this.sequencer.getTickPosition() - 1L;
        this.reset = true;
    }
}

