/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.managers;

import app.tuxguitar.song.helpers.TGMeasureError;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGText;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.song.models.effects.TGEffectBend;
import app.tuxguitar.song.models.effects.TGEffectGrace;
import app.tuxguitar.song.models.effects.TGEffectHarmonic;
import app.tuxguitar.song.models.effects.TGEffectTremoloBar;
import app.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import app.tuxguitar.song.models.effects.TGEffectTrill;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class TGMeasureManager {
    private TGSongManager songManager;

    public TGMeasureManager(TGSongManager songManager) {
        this.songManager = songManager;
    }

    public TGSongManager getSongManager() {
        return this.songManager;
    }

    public void orderBeats(TGMeasure measure) {
        Collections.sort(measure.getBeats());
    }

    public void addBeat(TGMeasure measure, TGBeat beat) {
        measure.addBeat(beat);
    }

    public void removeBeat(TGBeat beat) {
        beat.getMeasure().removeBeat(beat);
    }

    public void removeBeat(TGMeasure measure, long start, boolean moveNextComponents) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            this.removeBeat(beat, moveNextComponents);
        }
    }

    public void removeBeat(TGBeat beat, boolean moveNextBeats) {
        TGMeasure measure = beat.getMeasure();
        this.removeBeat(beat);
        if (moveNextBeats) {
            TGDuration minimumDuration = this.getMinimumDuration(beat);
            long preciseStart = beat.getPreciseStart();
            long preciseLength = minimumDuration != null ? minimumDuration.getPreciseTime() : 0L;
            TGBeat next = this.getNextBeat(measure.getBeats(), beat);
            if (next != null) {
                preciseLength = next.getPreciseStart() - preciseStart;
            }
            this.moveBeatsInMeasurePrecise(beat.getMeasure(), preciseStart + preciseLength, -preciseLength, minimumDuration);
        }
    }

    public void removeEmptyBeats(TGMeasure measure) {
        ArrayList<TGBeat> beats = new ArrayList<TGBeat>();
        for (TGBeat beat : measure.getBeats()) {
            boolean emptyBeat = true;
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                if (voice.isEmpty()) continue;
                emptyBeat = false;
            }
            if (!emptyBeat) continue;
            beats.add(beat);
        }
        for (TGBeat beat : beats) {
            this.removeBeat(beat);
        }
    }

    public void removeBeatsBeforeEnd(TGMeasure measure, long fromStart) {
        List<TGBeat> beats = this.getBeatsBeforeEnd(measure.getBeats(), fromStart);
        for (TGBeat beat : beats) {
            this.removeBeat(beat);
        }
    }

    public void removeBeatsBetween(TGMeasure measure, long p1, long p2) {
        List<TGBeat> beats = this.getBeatsBeetween(measure.getBeats(), p1, p2);
        for (TGBeat beat : beats) {
            this.removeBeat(beat);
        }
    }

    public void addNote(TGMeasure measure, long start, TGNote note, TGDuration duration, int voice) {
        TGBeat beat = this.getBeatIn(measure, start);
        if (beat != null) {
            this.addNote(beat, note, duration, start, voice);
        }
    }

    public void addNote(TGBeat beat, TGNote note, TGDuration duration, int voice) {
        this.addNote(beat, note, duration, beat.getStart(), voice);
    }

    public void addNote(TGBeat beat, TGNote note, TGDuration duration, long start, int voice) {
        boolean emptyVoice = beat.getVoice(voice).isEmpty();
        if (emptyVoice) {
            beat.getVoice(voice).setEmpty(false);
        }
        if (this.validateDuration(beat.getMeasure(), beat, voice, duration, true, true)) {
            TGVoice beatIn;
            for (int v = 0; v < beat.countVoices(); ++v) {
                this.removeNote(beat.getMeasure(), beat.getStart(), v, note.getString(), false);
            }
            beat.getVoice(voice).getDuration().copyFrom(duration);
            this.tryChangeSilenceAfter(beat.getMeasure(), beat.getVoice(voice));
            TGVoice realVoice = beat.getVoice(voice);
            if (realVoice.getBeat().getStart() != start && (beatIn = this.getVoiceIn(realVoice.getBeat().getMeasure(), start, voice)) != null) {
                realVoice = beatIn;
            }
            realVoice.addNote(note);
        } else {
            beat.getVoice(voice).setEmpty(emptyVoice);
        }
    }

    public void addNoteWithoutControl(TGBeat beat, TGNote note, TGDuration duration, int voiceIndex) {
        TGVoice voice = beat.getVoice(voiceIndex);
        boolean emptyVoice = voice.isEmpty();
        if (emptyVoice) {
            voice.setEmpty(false);
        }
        for (int v = 0; v < beat.countVoices(); ++v) {
            this.removeNote(beat.getMeasure(), beat.getStart(), v, note.getString(), false);
        }
        voice.getDuration().copyFrom(duration);
        voice.addNote(note);
    }

    public void removeNote(TGNote note, boolean checkRestBeat) {
        TGVoice voice = note.getVoice();
        if (voice != null) {
            voice.removeNote(note);
            TGBeat beat = voice.getBeat();
            if (checkRestBeat && beat.isRestBeat()) {
                beat.getStroke().setDirection(0);
                beat.getPickStroke().setDirection(0);
                if (beat.getMeasure() != null) {
                    this.removeChord(beat.getMeasure(), beat.getStart());
                }
            }
        }
    }

    public void removeNote(TGNote note) {
        this.removeNote(note, true);
    }

    public void removeNote(TGMeasure measure, long start, int voiceIndex, int string) {
        this.removeNote(measure, start, voiceIndex, string, true);
    }

    public void removeNote(TGMeasure measure, long start, int voiceIndex, int string, boolean checkRestBeat) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            TGVoice voice = beat.getVoice(voiceIndex);
            for (int i = 0; i < voice.countNotes(); ++i) {
                TGNote note = voice.getNote(i);
                if (note.getString() != string) continue;
                this.removeNote(note, checkRestBeat);
                return;
            }
        }
    }

    public void removeNotesAfterString(TGMeasure measure, int string) {
        ArrayList<TGNote> notesToRemove = new ArrayList<TGNote>();
        for (TGBeat beat : measure.getBeats()) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    if (note.getString() <= string) continue;
                    notesToRemove.add(note);
                }
            }
        }
        for (TGNote note : notesToRemove) {
            this.removeNote(note);
        }
    }

    public void removeNotesAfterFret(TGMeasure measure, int fret) {
        ArrayList<TGNote> notesToRemove = new ArrayList<TGNote>();
        for (TGBeat beat : measure.getBeats()) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    if (note.getValue() <= fret) continue;
                    notesToRemove.add(note);
                }
            }
        }
        for (TGNote note : notesToRemove) {
            this.removeNote(note);
        }
    }

    public List<TGNote> getNotes(TGMeasure measure, long start) {
        ArrayList<TGNote> notes = new ArrayList<TGNote>();
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                for (TGNote note : voice.getNotes()) {
                    notes.add(note);
                }
            }
        }
        return notes;
    }

    public List<TGNote> getNotes(TGBeat beat) {
        ArrayList<TGNote> notes = new ArrayList<TGNote>();
        if (beat != null) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                if (voice.isEmpty() || voice.isRestVoice()) continue;
                for (TGNote note : voice.getNotes()) {
                    notes.add(note);
                }
            }
        }
        return notes;
    }

    public TGNote getNote(TGMeasure measure, long start, int string) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            return this.getNote(beat, string);
        }
        return null;
    }

    public TGNote getNote(TGBeat beat, int string) {
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGNote note;
            TGVoice voice = beat.getVoice(v);
            if (voice.isEmpty() || (note = this.getNote(voice, string)) == null) continue;
            return note;
        }
        return null;
    }

    public TGNote getNote(TGVoice voice, int string) {
        for (TGNote note : voice.getNotes()) {
            if (note.getString() != string) continue;
            return note;
        }
        return null;
    }

    public TGNote getNextNote(TGMeasure measure, long start, int voiceIndex, int string) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            TGBeat next = this.getNextBeat(measure.getBeats(), beat);
            while (next != null) {
                TGVoice voice = next.getVoice(voiceIndex);
                if (!voice.isEmpty()) {
                    for (int i = 0; i < voice.countNotes(); ++i) {
                        TGNote current = voice.getNote(i);
                        if (current.getString() != string) continue;
                        return current;
                    }
                }
                next = this.getNextBeat(measure.getBeats(), next);
            }
        }
        return null;
    }

    public TGDuration getMinimumDuration(TGBeat beat) {
        TGDuration minimumDuration = null;
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGVoice voice = beat.getVoice(v);
            if (voice.isEmpty() || minimumDuration != null && voice.getDuration().compareTo(minimumDuration) >= 0) continue;
            minimumDuration = voice.getDuration();
        }
        return minimumDuration;
    }

    public TGDuration getMaximumDuration(TGBeat beat) {
        TGDuration maximumDuration = null;
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGVoice voice = beat.getVoice(v);
            if (voice.isEmpty() || maximumDuration != null && voice.getDuration().compareTo(maximumDuration) <= 0) continue;
            maximumDuration = voice.getDuration();
        }
        return maximumDuration;
    }

    public TGBeat getBeatPrecise(TGTrack track, long preciseStart) {
        Iterator<TGMeasure> measures = track.getMeasures();
        while (measures.hasNext()) {
            TGMeasure measure = measures.next();
            for (TGBeat beat : measure.getBeats()) {
                if (beat.getPreciseStart() != preciseStart) continue;
                return beat;
            }
        }
        return null;
    }

    public TGBeat getBeat(TGMeasure measure, long start) {
        for (TGBeat beat : measure.getBeats()) {
            if (beat.getStart() != start) continue;
            return beat;
        }
        return null;
    }

    public TGBeat getBeatPrecise(TGMeasure measure, long preciseStart) {
        for (TGBeat beat : measure.getBeats()) {
            if (beat.getPreciseStart() != preciseStart) continue;
            return beat;
        }
        return null;
    }

    public TGBeat getBeatIn(TGMeasure measure, long start) {
        TGBeat beatIn = null;
        for (TGBeat beat : measure.getBeats()) {
            TGDuration duration = this.getMinimumDuration(beat);
            if (beat.getStart() > start || beat.getStart() + duration.getTime() <= start || beatIn != null && beat.getStart() <= beatIn.getStart()) continue;
            beatIn = beat;
        }
        return beatIn;
    }

    public TGVoice getVoiceIn(TGMeasure measure, long start, int voiceIndex) {
        for (TGBeat beat : measure.getBeats()) {
            TGVoice voice = beat.getVoice(voiceIndex);
            if (voice.isEmpty() || beat.getStart() > start || beat.getStart() + voice.getDuration().getTime() <= start) continue;
            return voice;
        }
        return null;
    }

    public TGBeat getNextBeat(List<TGBeat> beats, TGBeat beat) {
        TGBeat next = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (current.getStart() <= beat.getStart()) continue;
            if (next == null) {
                next = current;
                continue;
            }
            if (current.getStart() >= next.getStart()) continue;
            next = current;
        }
        return next;
    }

    public TGBeat getPreviousBeat(List<TGBeat> beats, TGBeat beat) {
        TGBeat previous = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (current.getStart() >= beat.getStart()) continue;
            if (previous == null) {
                previous = current;
                continue;
            }
            if (current.getStart() <= previous.getStart()) continue;
            previous = current;
        }
        return previous;
    }

    public TGBeat getFirstBeat(List<TGBeat> components) {
        TGBeat first = null;
        for (int i = 0; i < components.size(); ++i) {
            TGBeat component = components.get(i);
            if (first != null && component.getStart() >= first.getStart()) continue;
            first = component;
        }
        return first;
    }

    public TGBeat getLastBeat(List<TGBeat> components) {
        TGBeat last = null;
        for (int i = 0; i < components.size(); ++i) {
            TGBeat component = components.get(i);
            if (last != null && last.getStart() >= component.getStart()) continue;
            last = component;
        }
        return last;
    }

    public List<TGBeat> getBeatsBeforeEnd(List<TGBeat> beats, long fromStart) {
        ArrayList<TGBeat> list = new ArrayList<TGBeat>();
        for (TGBeat current : beats) {
            if (current.getStart() < fromStart) continue;
            list.add(current);
        }
        return list;
    }

    public List<TGBeat> getBeatsBeforeEndPrecise(List<TGBeat> beats, long fromPreciseStart) {
        ArrayList<TGBeat> list = new ArrayList<TGBeat>();
        for (TGBeat current : beats) {
            if (current.getPreciseStart() < fromPreciseStart) continue;
            list.add(current);
        }
        return list;
    }

    public List<TGBeat> getBeatsBeetween(List<TGBeat> beats, long p1, long p2) {
        ArrayList<TGBeat> list = new ArrayList<TGBeat>();
        for (TGBeat current : beats) {
            if (current.getStart() < p1 || current.getStart() >= p2) continue;
            list.add(current);
        }
        return list;
    }

    private void locateBeat(TGBeat beat, TGTrack track, boolean newMeasureAlsoForRestBeats) {
        TGMeasure newMeasure;
        if (beat.getMeasure() != null) {
            beat.getMeasure().removeBeat(beat);
            beat.setMeasure(null);
        }
        if ((newMeasure = this.getSongManager().getTrackManager().getMeasureAtPreciseStart(track, beat.getPreciseStart())) == null) {
            boolean createNewMeasure = newMeasureAlsoForRestBeats;
            if (!createNewMeasure) {
                boolean bl = createNewMeasure = !beat.isRestBeat() || beat.isTextBeat();
            }
            if (createNewMeasure) {
                while (newMeasure == null && beat.getStart() >= 960L) {
                    this.getSongManager().addNewMeasureBeforeEnd(track.getSong());
                    newMeasure = this.getSongManager().getTrackManager().getMeasureAtPreciseStart(track, beat.getPreciseStart());
                }
            }
        }
        if (newMeasure != null) {
            long mPreciseStart = newMeasure.getPreciseStart();
            long mPreciseLength = newMeasure.getPreciseLength();
            long bPreciseStart = beat.getPreciseStart();
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                long vPreciseDuration = voice.getDuration().getPreciseTime();
                if (voice.isEmpty() || bPreciseStart + vPreciseDuration <= mPreciseStart + mPreciseLength) continue;
                long toSplitInsideMeasure = mPreciseStart + mPreciseLength - bPreciseStart;
                List<TGDuration> durations = TGDuration.splitPreciseDuration(toSplitInsideMeasure, TGDuration.WHOLE_PRECISE_DURATION, this.getSongManager().getFactory());
                boolean ok = durations != null;
                long remainder = vPreciseDuration - toSplitInsideMeasure;
                while (ok && remainder > 0L) {
                    long toSplit = Math.min(remainder, mPreciseLength);
                    List<TGDuration> split = TGDuration.splitPreciseDuration(toSplit, TGDuration.WHOLE_PRECISE_DURATION, this.getSongManager().getFactory());
                    if (!(ok &= split != null)) continue;
                    durations.addAll(split);
                    remainder -= toSplit;
                }
                if (!ok) continue;
                long newBeatPreciseStart = bPreciseStart;
                voice.getDuration().copyFrom(durations.get(0));
                newBeatPreciseStart = bPreciseStart + voice.getDuration().getPreciseTime();
                for (int d = 1; d < durations.size(); ++d) {
                    TGBeat newBeat = this.getBeatPrecise(track, newBeatPreciseStart);
                    if (newBeat == null) {
                        newBeat = this.getSongManager().getFactory().newBeat();
                        newBeat.setPreciseStart(newBeatPreciseStart);
                    }
                    TGVoice newVoice = newBeat.getVoice(v);
                    for (int n = 0; n < voice.countNotes(); ++n) {
                        TGNote note = voice.getNote(n);
                        TGNote newNote = this.getSongManager().getFactory().newNote();
                        newNote.setTiedNote(true);
                        newNote.setValue(note.getValue());
                        newNote.setString(note.getString());
                        newNote.setVelocity(note.getVelocity());
                        newVoice.addNote(newNote);
                    }
                    newVoice.setEmpty(false);
                    newVoice.getDuration().copyFrom(durations.get(d));
                    this.locateBeat(newBeat, track, newMeasureAlsoForRestBeats);
                    newBeatPreciseStart += durations.get(d).getPreciseTime();
                }
            }
            newMeasure.addBeat(beat);
        }
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGMeasure measure) {
        this.moveOutOfBoundsBeatsToNewMeasure(measure, true);
    }

    public void moveOutOfBoundsBeatsToNewMeasure(TGMeasure measure, boolean newMeasureAlsoForRestBeats) {
        ArrayList<TGBeat> beats = new ArrayList<TGBeat>();
        long mStart = measure.getStart();
        long mLength = measure.getLength();
        for (int i = 0; i < measure.countBeats(); ++i) {
            TGBeat beat = measure.getBeat(i);
            if (beat.getStart() < mStart || beat.getStart() >= mStart + mLength) {
                beats.add(beat);
                continue;
            }
            long bStart = beat.getStart();
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                long vDuration = voice.getDuration().getTime();
                if (voice.isEmpty() || bStart + vDuration <= mStart + mLength) continue;
                beats.add(beat);
            }
        }
        while (!beats.isEmpty()) {
            TGBeat beat = (TGBeat)beats.get(0);
            if (beat.getMeasure() != null) {
                beat.getMeasure().removeBeat(beat);
                beat.setMeasure(null);
            }
            this.locateBeat(beat, measure.getTrack(), newMeasureAlsoForRestBeats);
            beats.remove(0);
        }
    }

    public boolean moveBeatsInMeasurePrecise(TGMeasure measure, long preciseStart, long thePreciseMove, TGDuration fillDuration) {
        if (thePreciseMove == 0L) {
            return false;
        }
        boolean success = true;
        long measurePreciseStart = measure.getPreciseStart();
        long measurePreciseEnd = measurePreciseStart + measure.getPreciseLength();
        List<TGBeat> beatsToMove = this.getBeatsBeforeEndPrecise(measure.getBeats(), preciseStart);
        this.moveBeatsPrecise(beatsToMove, thePreciseMove);
        if (success) {
            TGDuration lastDuration;
            ArrayList<TGBeat> beatsToRemove = new ArrayList<TGBeat>();
            ArrayList<TGBeat> beats = new ArrayList<TGBeat>(measure.getBeats());
            TGBeat first = this.getFirstBeat(beats);
            while (first != null && first.isRestBeat() && !first.isTextBeat() && first.getPreciseStart() < measurePreciseStart) {
                beats.remove(first);
                beatsToRemove.add(first);
                first = this.getNextBeat(beats, first);
            }
            TGBeat last = this.getLastBeat(beats);
            TGDuration tGDuration = lastDuration = last != null ? this.getMinimumDuration(last) : null;
            while (last != null && lastDuration != null && last.isRestBeat() && !last.isTextBeat() && last.getPreciseStart() + lastDuration.getPreciseTime() > measurePreciseEnd) {
                beats.remove(last);
                beatsToRemove.add(last);
                last = this.getPreviousBeat(beats, last);
                lastDuration = last != null ? this.getMinimumDuration(last) : null;
            }
            if (first != null && last != null && lastDuration != null && (first.getPreciseStart() < measurePreciseStart || last.getPreciseStart() + lastDuration.getPreciseTime() > measurePreciseEnd)) {
                success = false;
            }
            if (success) {
                for (TGBeat beat : beatsToRemove) {
                    this.removeBeat(beat);
                }
                if (fillDuration != null) {
                    TGBeat beat;
                    if (thePreciseMove < 0L) {
                        last = this.getLastBeat(measure.getBeats());
                        lastDuration = last != null ? this.getMinimumDuration(last) : null;
                        beat = this.getSongManager().getFactory().newBeat();
                        beat.setPreciseStart(last != null && lastDuration != null ? last.getPreciseStart() + lastDuration.getPreciseTime() : preciseStart);
                        if (beat.getPreciseStart() + fillDuration.getPreciseTime() <= measurePreciseEnd) {
                            for (int v = 0; v < beat.countVoices(); ++v) {
                                TGVoice voice = beat.getVoice(v);
                                voice.setEmpty(false);
                                voice.getDuration().copyFrom(fillDuration);
                            }
                            this.addBeat(measure, beat);
                        }
                    } else {
                        first = this.getFirstBeat(this.getBeatsBeforeEndPrecise(measure.getBeats(), preciseStart));
                        beat = this.getSongManager().getFactory().newBeat();
                        beat.setPreciseStart(preciseStart);
                        if (beat.getPreciseStart() + fillDuration.getPreciseTime() <= (first != null ? first.getPreciseStart() : measurePreciseEnd)) {
                            for (int v = 0; v < beat.countVoices(); ++v) {
                                TGVoice voice = beat.getVoice(v);
                                voice.setEmpty(false);
                                voice.getDuration().copyFrom(fillDuration);
                            }
                            this.addBeat(measure, beat);
                        }
                    }
                }
            }
        }
        if (!success) {
            this.moveBeatsPrecise(beatsToMove, -thePreciseMove);
        }
        return success;
    }

    public void moveAllBeats(TGMeasure measure, long theMove) {
        this.moveBeats(measure.getBeats(), theMove);
        this.updateBeatsPreciseStart(measure);
    }

    public void moveBeats(TGMeasure measure, long start, long theMove) {
        this.moveBeats(this.getBeatsBeforeEnd(measure.getBeats(), start), theMove);
        this.updateBeatsPreciseStart(measure);
    }

    private void moveBeats(List<TGBeat> beats, long theMove) {
        for (TGBeat beat : beats) {
            this.moveBeat(beat, theMove);
        }
    }

    private void moveBeatsPrecise(List<TGBeat> beats, long thePreciseMove) {
        for (TGBeat beat : beats) {
            this.moveBeatPrecise(beat, thePreciseMove);
        }
    }

    private void moveBeat(TGBeat beat, long theMove) {
        long start = beat.getStart();
        beat.setStart(start + theMove);
    }

    private void moveBeatPrecise(TGBeat beat, long thePreciseMove) {
        long preciseStart = beat.getPreciseStart();
        beat.setPreciseStart(preciseStart + thePreciseMove);
    }

    public void cleanBeat(TGBeat beat) {
        beat.getStroke().setDirection(0);
        beat.getPickStroke().setDirection(0);
        if (beat.getText() != null) {
            beat.removeText();
        }
        if (beat.getChord() != null) {
            beat.removeChord();
        }
        this.cleanBeatNotes(beat);
    }

    public void cleanBeatNotes(TGBeat beat) {
        for (int v = 0; v < beat.countVoices(); ++v) {
            this.cleanVoiceNotes(beat.getVoice(v));
        }
    }

    public void cleanVoiceNotes(TGVoice voice) {
        if (!voice.isEmpty()) {
            while (voice.countNotes() > 0) {
                TGNote note = voice.getNote(0);
                this.removeNote(note);
            }
        }
    }

    public void addChord(TGBeat beat, TGChord chord) {
        beat.removeChord();
        beat.setChord(chord);
    }

    public TGChord getChord(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            return beat.getChord();
        }
        return null;
    }

    public void removeChord(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            beat.removeChord();
        }
    }

    public void addText(TGBeat beat, TGText text) {
        beat.removeText();
        if (!text.isEmpty()) {
            beat.setText(text);
        }
    }

    public void removeText(TGBeat beat) {
        beat.removeText();
    }

    public void cleanMeasure(TGMeasure measure) {
        while (measure.countBeats() > 0) {
            this.removeBeat(measure.getBeat(0));
        }
    }

    public void updateBeatsPreciseStart(TGMeasure measure) {
        ArrayList<TGBeat> beatsToDelete = new ArrayList<TGBeat>();
        Collections.sort(measure.getBeats());
        long[] voiceEnd = new long[2];
        boolean isFirstBeat = true;
        for (TGBeat beat : measure.getBeats()) {
            int v;
            if (isFirstBeat) {
                beat.setPreciseStart(beat.getMeasure().getPreciseStart());
                long minVoiceEnd = 0L;
                for (v = 0; v < 2; ++v) {
                    if (beat.getVoice(v).isEmpty()) continue;
                    voiceEnd[v] = beat.getPreciseStart() + beat.getVoice(v).getDuration().getPreciseTime();
                    if (minVoiceEnd != 0L && voiceEnd[v] >= minVoiceEnd) continue;
                    minVoiceEnd = voiceEnd[v];
                }
                for (v = 0; v < 2; ++v) {
                    voiceEnd[v] = Math.max(voiceEnd[v], minVoiceEnd);
                }
            } else {
                long beatPreciseStart = 0L;
                for (v = 0; v < 2; ++v) {
                    if (beat.getVoice(v).isEmpty() || beatPreciseStart != 0L && voiceEnd[v] <= beatPreciseStart) continue;
                    beatPreciseStart = voiceEnd[v];
                }
                if (beatPreciseStart == 0L) {
                    beatsToDelete.add(beat);
                } else {
                    beat.setPreciseStart(beatPreciseStart);
                    for (v = 0; v < 2; ++v) {
                        if (beat.getVoice(v).isEmpty()) continue;
                        voiceEnd[v] = beat.getPreciseStart() + beat.getVoice(v).getDuration().getPreciseTime();
                    }
                }
            }
            isFirstBeat = false;
        }
        for (TGBeat beat : beatsToDelete) {
            this.removeBeat(beat);
        }
    }

    public int shiftNoteUp(TGMeasure measure, long start, int string) {
        return this.shiftNote(measure, start, string, -1);
    }

    public int shiftNoteDown(TGMeasure measure, long start, int string) {
        return this.shiftNote(measure, start, string, 1);
    }

    private int shiftNote(TGMeasure measure, long start, int string, int move) {
        TGNote note = this.getNote(measure, start, string);
        if (note != null) {
            int nextStringNumber = note.getString() + move;
            TGTrack track = measure.getTrack();
            if (this.getNote(measure, start, nextStringNumber) == null && nextStringNumber >= 1 && nextStringNumber <= track.stringCount()) {
                TGString currentString = track.getString(note.getString());
                TGString nextString = track.getString(nextStringNumber);
                int noteValue = note.getValue() + currentString.getValue();
                boolean canMove = noteValue >= nextString.getValue();
                canMove &= nextString.getValue() + track.getMaxFret() >= noteValue || track.isPercussion();
                int graceValue = 0;
                if (note.getEffect().isGrace()) {
                    graceValue = note.getEffect().getGrace().getFret() + currentString.getValue();
                    canMove &= graceValue >= nextString.getValue();
                    canMove &= nextString.getValue() + track.getMaxFret() >= graceValue || track.isPercussion();
                }
                if (canMove) {
                    note.setValue(noteValue - nextString.getValue());
                    note.setString(nextString.getNumber());
                    if (note.getEffect().isGrace()) {
                        note.getEffect().getGrace().setFret(graceValue - nextString.getValue());
                    }
                    return note.getString();
                }
            }
        }
        return 0;
    }

    public boolean canMoveSemitoneUp(TGMeasure measure, long start, int string) {
        return this.moveSemitone(measure, start, string, 1, false);
    }

    public boolean moveSemitoneUp(TGMeasure measure, long start, int string) {
        return this.moveSemitone(measure, start, string, 1, true);
    }

    public boolean canMoveSemitoneDown(TGMeasure measure, long start, int string) {
        return this.moveSemitone(measure, start, string, -1, false);
    }

    public boolean moveSemitoneDown(TGMeasure measure, long start, int string) {
        return this.moveSemitone(measure, start, string, -1, true);
    }

    private boolean moveSemitone(TGMeasure measure, long start, int string, int semitones, boolean doAction) {
        int newValue;
        TGNote note = this.getNote(measure, start, string);
        if (note != null && (newValue = note.getValue() + semitones) >= 0 && (newValue <= measure.getTrack().getMaxFret() || measure.getTrack().isPercussion())) {
            if (doAction) {
                note.setValue(newValue);
            }
            return true;
        }
        return false;
    }

    public boolean setStroke(TGMeasure measure, long start, int value, int direction) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            beat.getStroke().setValue(value);
            beat.getStroke().setDirection(direction);
            return true;
        }
        return false;
    }

    public boolean changePickStrokeUp(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            if (beat.getPickStroke().getDirection() != 1) {
                beat.getPickStroke().setDirection(1);
            } else {
                beat.getPickStroke().setDirection(0);
            }
            return true;
        }
        return false;
    }

    public boolean changePickStrokeDown(TGMeasure measure, long start) {
        TGBeat beat = this.getBeat(measure, start);
        if (beat != null) {
            if (beat.getPickStroke().getDirection() != -1) {
                beat.getPickStroke().setDirection(-1);
            } else {
                beat.getPickStroke().setDirection(0);
            }
            return true;
        }
        return false;
    }

    public void autoCompleteSilences(TGMeasure measure) {
        int v;
        TGBeat beat = this.getFirstBeat(measure.getBeats());
        if (beat == null) {
            this.createSilences(measure, measure.getPreciseStart(), measure.getPreciseLength(), 0);
            return;
        }
        boolean hasVoices = false;
        for (int v2 = 0; v2 < 2; ++v2) {
            TGVoice voice = this.getFirstVoice(measure.getBeats(), v2);
            if (voice != null && voice.getBeat().getPreciseStart() > measure.getPreciseStart()) {
                this.createSilences(measure, measure.getPreciseStart(), voice.getBeat().getPreciseStart() - measure.getPreciseStart(), v2);
            }
            hasVoices = hasVoices || voice != null;
        }
        if (!hasVoices) {
            this.createSilences(measure, measure.getPreciseStart(), measure.getPreciseLength(), 0);
            return;
        }
        long[] start = new long[beat.countVoices()];
        long[] uncompletedLength = new long[beat.countVoices()];
        for (v = 0; v < uncompletedLength.length; ++v) {
            start[v] = 0L;
            uncompletedLength[v] = 0L;
        }
        while (beat != null) {
            for (v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                if (voice.isEmpty()) continue;
                long voiceEnd = beat.getPreciseStart() + voice.getDuration().getPreciseTime();
                long nextPosition = measure.getPreciseStart() + measure.getPreciseLength();
                TGVoice nextVoice = this.getNextVoice(measure.getBeats(), beat, voice.getIndex());
                if (nextVoice != null) {
                    nextPosition = nextVoice.getBeat().getPreciseStart();
                }
                if (voiceEnd >= nextPosition) continue;
                start[v] = voiceEnd;
                uncompletedLength[v] = nextPosition - voiceEnd;
            }
            for (v = 0; v < uncompletedLength.length; ++v) {
                if (uncompletedLength[v] > 0L) {
                    this.createSilences(measure, start[v], uncompletedLength[v], v);
                }
                start[v] = 0L;
                uncompletedLength[v] = 0L;
            }
            beat = this.getNextBeat(measure.getBeats(), beat);
        }
    }

    public List<TGMeasureError> getMeasureErrors(TGMeasure measure) {
        ArrayList<TGMeasureError> list = new ArrayList<TGMeasureError>();
        for (int voiceIndex = 0; voiceIndex < 2; ++voiceIndex) {
            int errCode = 0;
            boolean isEmpty = true;
            long firstPreciseStart = -1L;
            long lastPreciseEnd = -1L;
            for (TGBeat beat : measure.getBeats()) {
                long beatPreciseStart = beat.getPreciseStart();
                TGVoice voice = beat.getVoice(voiceIndex);
                for (TGNote note : voice.getNotes()) {
                    if (!note.isTiedNote() || this.getSongManager().getTrackManager().getPreviousNoteForTie(note) != null) continue;
                    list.add(new TGMeasureError(measure, note));
                }
                if (voice.isEmpty()) continue;
                isEmpty = false;
                if (firstPreciseStart < 0L) {
                    if (beatPreciseStart < measure.getPreciseStart()) {
                        errCode |= 4;
                    }
                    firstPreciseStart = beat.getPreciseStart();
                } else if (beatPreciseStart < lastPreciseEnd) {
                    errCode |= 2;
                } else if (beatPreciseStart > lastPreciseEnd) {
                    errCode |= 1;
                }
                lastPreciseEnd = beatPreciseStart + voice.getDuration().getPreciseTime();
            }
            if (!isEmpty) {
                long measurePreciseEnd = measure.getPreciseStart() + measure.getPreciseLength();
                if (lastPreciseEnd < measurePreciseEnd) {
                    errCode |= 8;
                } else if (lastPreciseEnd > measurePreciseEnd) {
                    errCode |= 0x10;
                }
            }
            if (errCode == 0) continue;
            list.add(new TGMeasureError(measure, voiceIndex, errCode));
        }
        return list;
    }

    public boolean isMeasureDurationValid(TGMeasure measure) {
        for (TGMeasureError err : this.getMeasureErrors(measure)) {
            if (err.getErrorType() != 1) continue;
            return false;
        }
        return true;
    }

    public void fixVoice(TGMeasure measure, int voiceIndex, int errCode) {
        if ((errCode & 2) != 0) {
            this.fixVoiceOverlap(measure, voiceIndex);
        }
        if ((errCode & 0x10) != 0 || (errCode & 8) != 0) {
            this.fixVoiceLongShort(measure, voiceIndex);
        }
    }

    public void fixVoiceOverlap(TGMeasure measure, int voiceIndex) {
        boolean overlap = true;
        block2: while (overlap) {
            overlap = false;
            TGVoice previousVoice = null;
            for (TGBeat beat : measure.getBeats()) {
                long voiceStart;
                long previousVoiceEnd;
                long overlapTime;
                TGVoice voice = beat.getVoice(voiceIndex);
                if (voice.isEmpty()) continue;
                if (previousVoice != null && (overlapTime = (previousVoiceEnd = previousVoice.getBeat().getPreciseStart() + previousVoice.getDuration().getPreciseTime()) - (voiceStart = voice.getBeat().getPreciseStart().longValue())) > 0L) {
                    overlap = true;
                    long fixedPreviousPreciseTime = previousVoice.getDuration().getPreciseTime() - overlapTime;
                    TGDuration fixedDuration = this.getSongManager().getFactory().newDuration();
                    try {
                        fixedDuration.setPreciseValue(fixedPreviousPreciseTime);
                    }
                    catch (IllegalArgumentException e) {
                        overlap = false;
                    }
                    if (overlap) {
                        previousVoice.setDuration(fixedDuration);
                        this.updateBeatsPreciseStart(measure);
                        continue block2;
                    }
                }
                previousVoice = voice;
            }
        }
    }

    public void fixVoiceLongShort(TGMeasure measure, int voiceIndex) {
        List<TGBeat> beats = measure.getBeats();
        long measurePreciseEnd = measure.getPreciseStart() + measure.getPreciseLength();
        for (int nBeat = beats.size() - 1; nBeat >= 0 && beats.get(nBeat).getPreciseStart() >= measurePreciseEnd; --nBeat) {
            this.removeVoice(beats.get(nBeat).getVoice(voiceIndex));
        }
        beats = measure.getBeats();
        TGVoice voice = this.getLastVoice(beats, voiceIndex);
        if (voice.getBeat().getPreciseStart() + voice.getDuration().getPreciseTime() > measurePreciseEnd) {
            long correctDurationPreciseTime = measurePreciseEnd - voice.getBeat().getPreciseStart();
            TGDuration duration = this.getSongManager().getFactory().newDuration();
            try {
                duration.setPreciseValue(correctDurationPreciseTime);
                voice.setDuration(duration);
            }
            catch (IllegalArgumentException e) {
                this.removeVoice(voice);
            }
        }
        beats = measure.getBeats();
        voice = this.getLastVoice(beats, voiceIndex);
        long gapToFill = measurePreciseEnd - voice.getBeat().getPreciseStart() - voice.getDuration().getPreciseTime();
        while (gapToFill > 0L) {
            List<TGDuration> listDurations = TGDuration.splitPreciseDuration(gapToFill, TGDuration.WHOLE_PRECISE_DURATION, this.getSongManager().getFactory());
            if (listDurations != null) {
                this.autoCompleteSilences(measure);
                gapToFill = 0L;
                continue;
            }
            long durationToFill = measurePreciseEnd - voice.getBeat().getPreciseStart();
            listDurations = TGDuration.splitPreciseDuration(durationToFill, TGDuration.WHOLE_PRECISE_DURATION, this.getSongManager().getFactory());
            if (listDurations != null && listDurations.size() == 1) {
                voice.setDuration(listDurations.get(0).clone(this.getSongManager().getFactory()));
                gapToFill = 0L;
                continue;
            }
            this.removeVoice(voice);
            voice = this.getLastVoice(beats, voiceIndex);
            gapToFill = measurePreciseEnd - voice.getBeat().getPreciseStart() - voice.getDuration().getPreciseTime();
        }
    }

    private void createSilences(TGMeasure measure, long preciseStart, long preciseLength, int voiceIndex) {
        this.createSilences(measure, preciseStart, preciseLength, measure.getPreciseLength(), voiceIndex);
    }

    private void createSilences(TGMeasure measure, long preciseStart, long preciseLength, long maxPreciseLength, int voiceIndex) {
        this.createSilences(measure, preciseStart, preciseLength, maxPreciseLength, null, voiceIndex);
    }

    private void createSilences(TGMeasure measure, long preciseStart, long preciseLength, long maxPreciseLength, TGDuration preferredDuration, int voiceIndex) {
        long nextStart = preciseStart;
        List<TGDuration> durations = TGDuration.splitPreciseDuration(preciseLength, maxPreciseLength, preferredDuration, this.getSongManager().getFactory());
        if (durations == null) {
            return;
        }
        for (TGDuration duration : durations) {
            boolean isNew = false;
            TGBeat beat = this.getBeatPrecise(measure, nextStart);
            if (beat == null) {
                beat = this.getSongManager().getFactory().newBeat();
                beat.setPreciseStart(nextStart);
                isNew = true;
            }
            TGVoice voice = beat.getVoice(voiceIndex);
            voice.setEmpty(false);
            voice.getDuration().copyFrom(duration);
            if (isNew) {
                this.addBeat(measure, beat);
            }
            nextStart += duration.getPreciseTime();
        }
    }

    public void changeTieNote(TGNote note) {
        boolean isValid;
        boolean bl = isValid = note.isTiedNote() || this.getSongManager().isFreeEditionMode(note.getVoice().getBeat().getMeasure());
        if (!isValid) {
            boolean bl2 = isValid = this.getSongManager().getTrackManager().getPreviousNoteForTie(note) != null;
        }
        if (isValid) {
            note.setTiedNote(!note.isTiedNote());
            note.getEffect().setDeadNote(false);
        }
    }

    public void setVibrato(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setVibrato(value);
        }
    }

    public void changeDeadNote(TGNote note) {
        note.getEffect().setDeadNote(!note.getEffect().isDeadNote());
        note.setTiedNote(false);
    }

    public void setDeadNote(TGNote note, boolean value) {
        boolean oldValue = note.getEffect().isDeadNote();
        note.getEffect().setDeadNote(value);
        if (value != oldValue) {
            note.setTiedNote(false);
        }
    }

    public void setSlideNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setSlide(value);
        }
    }

    public void setHammerNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setHammer(value);
        }
    }

    public void setPalmMute(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setPalmMute(value);
        }
    }

    public void setStaccato(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setStaccato(value);
        }
    }

    public void setLetRing(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setLetRing(value);
        }
    }

    public void setTapping(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setTapping(value);
        }
    }

    public void setSlapping(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setSlapping(value);
        }
    }

    public void setPopping(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setPopping(value);
        }
    }

    public void setBendNote(TGNote note, TGEffectBend bend) {
        if (note != null) {
            note.getEffect().setBend(bend);
        }
    }

    public void setTremoloBar(TGNote note, TGEffectTremoloBar tremoloBar) {
        if (note != null) {
            note.getEffect().setTremoloBar(tremoloBar);
        }
    }

    public void setGhostNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setGhostNote(value);
        }
    }

    public void setAccentuatedNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setAccentuatedNote(value);
        }
    }

    public void setHeavyAccentuatedNote(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setHeavyAccentuatedNote(value);
        }
    }

    public void setHarmonicNote(TGNote note, TGEffectHarmonic harmonic) {
        if (note != null) {
            note.getEffect().setHarmonic(harmonic);
        }
    }

    public void setGraceNote(TGNote note, TGEffectGrace grace) {
        if (note != null) {
            note.getEffect().setGrace(grace);
        }
    }

    public void setTrillNote(TGNote note, TGEffectTrill trill) {
        if (note != null) {
            note.getEffect().setTrill(trill);
        }
    }

    public void setTremoloPicking(TGNote note, TGEffectTremoloPicking tremoloPicking) {
        if (note != null) {
            note.getEffect().setTremoloPicking(tremoloPicking);
        }
    }

    public void setFadeIn(TGNote note, boolean value) {
        if (note != null) {
            note.getEffect().setFadeIn(value);
        }
    }

    public void changeVelocity(int velocity, TGNote note) {
        if (note != null) {
            note.setVelocity(velocity);
        }
    }

    public TGVoice getNextVoice(List<TGBeat> beats, TGBeat beat, int index) {
        TGVoice next = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (current.getPreciseStart() <= beat.getPreciseStart() || current.getVoice(index).isEmpty()) continue;
            if (next == null) {
                next = current.getVoice(index);
                continue;
            }
            if (current.getPreciseStart() >= next.getBeat().getPreciseStart()) continue;
            next = current.getVoice(index);
        }
        return next;
    }

    public TGVoice getPreviousVoice(List<TGBeat> beats, TGBeat beat, int index) {
        TGVoice previous = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (current.getStart() >= beat.getStart() || current.getVoice(index).isEmpty()) continue;
            if (previous == null) {
                previous = current.getVoice(index);
                continue;
            }
            if (current.getStart() <= previous.getBeat().getStart()) continue;
            previous = current.getVoice(index);
        }
        return previous;
    }

    public TGVoice getFirstVoice(List<TGBeat> beats, int index) {
        TGVoice first = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (first != null && current.getStart() >= first.getBeat().getStart() || current.getVoice(index).isEmpty()) continue;
            first = current.getVoice(index);
        }
        return first;
    }

    public TGVoice getLastVoice(List<TGBeat> beats, int index) {
        TGVoice last = null;
        for (int i = 0; i < beats.size(); ++i) {
            TGBeat current = beats.get(i);
            if (last != null && last.getBeat().getStart() >= current.getStart() || current.getVoice(index).isEmpty()) continue;
            last = current.getVoice(index);
        }
        return last;
    }

    public TGVoice getNextRestVoice(List<TGBeat> beats, TGVoice voice) {
        TGVoice next = this.getNextVoice(beats, voice.getBeat(), voice.getIndex());
        while (next != null && !next.isRestVoice()) {
            next = this.getNextVoice(beats, next.getBeat(), next.getIndex());
        }
        return next;
    }

    public List<TGVoice> getVoicesBeforeEndPrecise(List<TGBeat> beats, long fromPreciseStart, int index) {
        ArrayList<TGVoice> list = new ArrayList<TGVoice>();
        for (TGBeat beat : beats) {
            TGVoice voice;
            if (beat.getPreciseStart() < fromPreciseStart || (voice = beat.getVoice(index)).isEmpty()) continue;
            list.add(voice);
        }
        return list;
    }

    public void addSilence(TGBeat beat, TGDuration duration, int voice) {
        this.addSilence(beat, duration, beat.getStart(), voice);
    }

    public void addSilence(TGBeat beat, TGDuration duration, long start, int voice) {
        boolean emptyVoice = beat.getVoice(voice).isEmpty();
        if (emptyVoice) {
            beat.getVoice(voice).setEmpty(false);
        }
        if (this.validateDuration(beat.getMeasure(), beat, voice, duration, true, true)) {
            TGVoice beatIn;
            beat.getVoice(voice).getDuration().copyFrom(duration);
            this.tryChangeSilenceAfter(beat.getMeasure(), beat.getVoice(voice));
            TGVoice realVoice = beat.getVoice(voice);
            if (realVoice.getBeat().getStart() != start && (beatIn = this.getVoiceIn(realVoice.getBeat().getMeasure(), start, voice)) != null) {
                realVoice = beatIn;
            }
            realVoice.setEmpty(false);
        } else {
            beat.getVoice(voice).setEmpty(emptyVoice);
        }
    }

    public void insertRestBeatWithoutControl(TGBeat fromBeat, int voiceIndex) {
        if (fromBeat.getVoice(voiceIndex).isEmpty()) {
            return;
        }
        TGMeasure measure = fromBeat.getMeasure();
        TGBeat newBeat = this.getSongManager().getFactory().newBeat();
        newBeat.setPreciseStart(fromBeat.getPreciseStart());
        long preciseDurationTime = fromBeat.getVoice(voiceIndex).getDuration().getPreciseTime();
        for (TGBeat beat : measure.getBeats()) {
            if (beat.getPreciseStart() < fromBeat.getPreciseStart()) continue;
            beat.setPreciseStart(beat.getPreciseStart() + preciseDurationTime);
        }
        newBeat.getVoice(voiceIndex).setEmpty(false);
        newBeat.getVoice(voiceIndex).getDuration().copyFrom(fromBeat.getVoice(voiceIndex).getDuration());
        newBeat.setMeasure(measure);
        measure.getBeats().add(newBeat);
        this.orderBeats(measure);
    }

    public void removeVoice(TGVoice voice) {
        voice.setEmpty(true);
        TGBeat beat = voice.getBeat();
        for (int i = 0; i < beat.countVoices(); ++i) {
            if (beat.getVoice(i).isEmpty()) continue;
            return;
        }
        this.removeBeat(beat);
    }

    public void removeVoice(TGVoice voice, boolean moveNextVoices) {
        this.removeVoice(voice);
        if (moveNextVoices) {
            long preciseStart = voice.getBeat().getPreciseStart();
            long preciseLength = voice.getDuration().getPreciseTime();
            TGVoice next = this.getNextVoice(voice.getBeat().getMeasure().getBeats(), voice.getBeat(), voice.getIndex());
            if (next != null) {
                preciseLength = next.getBeat().getPreciseStart() - preciseStart;
            }
            this.moveVoicesPrecise(voice.getBeat().getMeasure(), preciseStart + preciseLength, -preciseLength, voice.getIndex(), voice.getDuration());
        }
    }

    public void removeVoicesOutOfTime(TGMeasure measure) {
        ArrayList<TGVoice> voicesToRemove = new ArrayList<TGVoice>();
        long mStart = measure.getStart();
        long mEnd = mStart + measure.getLength();
        for (TGBeat beat : measure.getBeats()) {
            for (int v = 0; v < beat.countVoices(); ++v) {
                TGVoice voice = beat.getVoice(v);
                if (voice.isEmpty() || beat.getStart() >= mStart && beat.getStart() + voice.getDuration().getTime() <= mEnd) continue;
                voicesToRemove.add(voice);
            }
        }
        for (TGVoice voice : voicesToRemove) {
            this.removeVoice(voice);
        }
    }

    public void removeMeasureVoices(TGMeasure measure, int index) {
        boolean hasNotes = false;
        ArrayList<TGVoice> voices = new ArrayList<TGVoice>();
        for (TGBeat beat : measure.getBeats()) {
            TGVoice voice = beat.getVoice(index);
            if (voice.isRestVoice()) {
                voices.add(voice);
                continue;
            }
            if (voice.isEmpty()) continue;
            hasNotes = true;
            break;
        }
        if (!hasNotes) {
            for (TGVoice voice : voices) {
                this.removeVoice(voice);
            }
        }
    }

    public void changeVoiceDirection(TGVoice voice, int direction) {
        voice.setDirection(direction);
    }

    public void changeDuration(TGMeasure measure, TGBeat beat, TGDuration duration, int voiceIndex, boolean tryMove) {
        if (this.getSongManager().isFreeEditionMode(measure)) {
            beat.getVoice(voiceIndex).getDuration().copyFrom(duration);
            this.updateBeatsPreciseStart(measure);
        } else {
            TGDuration oldDuration = beat.getVoice(voiceIndex).getDuration().clone(this.getSongManager().getFactory());
            if (this.validateDuration(measure, beat, voiceIndex, duration, tryMove, false)) {
                beat.getVoice(voiceIndex).setDuration(duration.clone(this.getSongManager().getFactory()));
                this.tryChangeSilenceAfter(measure, beat.getVoice(voiceIndex));
            } else {
                beat.getVoice(voiceIndex).getDuration().copyFrom(oldDuration);
            }
        }
        if (this.getSongManager().isFreeEditionMode(measure)) {
            this.updateBeatsPreciseStart(measure);
        }
    }

    public void tryChangeSilenceAfter(TGMeasure measure, TGVoice voice) {
        ArrayList<TGBeat> beatsToDelete = new ArrayList<TGBeat>();
        long endInterval = measure.getPreciseStart() + measure.getPreciseLength();
        long beatStart = voice.getBeat().getPreciseStart();
        for (TGBeat b : measure.getBeats()) {
            TGVoice tmpVoice;
            if (b.getPreciseStart() <= beatStart || (tmpVoice = b.getVoice(voice.getIndex())) == null || tmpVoice.isEmpty()) continue;
            if (tmpVoice.isRestVoice()) {
                tmpVoice.setEmpty(true);
                boolean isEmptyBeat = true;
                for (int v = 0; v < b.countVoices(); ++v) {
                    isEmptyBeat &= b.getVoice(v).isEmpty();
                }
                if (!isEmptyBeat) continue;
                beatsToDelete.add(b);
                continue;
            }
            endInterval = b.getPreciseStart();
            break;
        }
        while (!beatsToDelete.isEmpty()) {
            measure.removeBeat((TGBeat)beatsToDelete.get(0));
            beatsToDelete.remove(0);
        }
        long start = beatStart + voice.getDuration().getPreciseTime();
        long length = endInterval - start;
        this.createSilences(measure, start, length, measure.getPreciseLength(), voice.getDuration(), voice.getIndex());
    }

    private void moveVoicesPrecise(List<TGVoice> voices, long thePreciseMove) {
        int count = voices.size();
        for (int i = 0; i < count; ++i) {
            TGVoice voice = voices.get(thePreciseMove < 0L ? i : count - 1 - i);
            this.moveVoicePrecise(voice, thePreciseMove);
        }
    }

    public void moveVoicePrecise(TGVoice voice, long thePreciseMove) {
        long newStart = voice.getBeat().getPreciseStart() + thePreciseMove;
        TGBeat newBeat = this.getBeatPrecise(voice.getBeat().getMeasure(), newStart);
        if (newBeat == null) {
            newBeat = this.getSongManager().getFactory().newBeat();
            newBeat.setPreciseStart(newStart);
            this.addBeat(voice.getBeat().getMeasure(), newBeat);
        }
        this.moveVoice(voice, newBeat);
    }

    public void moveVoice(TGVoice voice, TGBeat beat) {
        TGBeat currentBeat = voice.getBeat();
        if (!currentBeat.equals(beat)) {
            if (currentBeat.getVoice(voice.getIndex()).equals(voice)) {
                if (currentBeat.isTextBeat() && this.isUniqueVoice(voice, false)) {
                    beat.setText(currentBeat.getText());
                    currentBeat.removeText();
                }
                if (this.isUniqueVoice(voice, true)) {
                    if (currentBeat.isChordBeat()) {
                        beat.setChord(currentBeat.getChord());
                        currentBeat.removeChord();
                    }
                    if (currentBeat.getStroke().getDirection() != 0) {
                        beat.getStroke().copyFrom(currentBeat.getStroke());
                        currentBeat.getStroke().setDirection(0);
                    }
                    if (currentBeat.getPickStroke().getDirection() != 0) {
                        beat.getPickStroke().copyFrom(currentBeat.getPickStroke());
                        currentBeat.getPickStroke().setDirection(0);
                    }
                }
                TGVoice newVoice = this.getSongManager().getFactory().newVoice(voice.getIndex());
                currentBeat.setVoice(voice.getIndex(), newVoice);
                this.removeVoice(newVoice);
            }
            beat.setVoice(voice.getIndex(), voice);
        }
    }

    public boolean validateDuration(TGMeasure measure, TGBeat beat, int voiceIndex, TGDuration duration, boolean moveNextBeats, boolean setCurrentDuration) {
        long measurePreciseStart = measure.getPreciseStart();
        long measurePreciseEnd = measurePreciseStart + measure.getPreciseLength();
        long beatPreciseStart = beat.getPreciseStart();
        long beatPreciseLength = duration.getPreciseTime();
        long beatPreciseEnd = beatPreciseStart + beatPreciseLength;
        List<TGBeat> beats = measure.getBeats();
        TGBeat currentBeat = this.getBeatPrecise(measure, beatPreciseStart);
        TGVoice currentVoice = null;
        if (currentBeat != null && !(currentVoice = currentBeat.getVoice(voiceIndex)).isEmpty() && beatPreciseLength <= currentVoice.getDuration().getPreciseTime()) {
            long toFillPrecise;
            boolean ok = true;
            long intervalPreciseEnd = measure.getPreciseStart() + measure.getPreciseLength();
            for (TGBeat b : measure.getBeats()) {
                TGVoice voice;
                if (b.getPreciseStart() <= beat.getPreciseStart() || (voice = b.getVoice(voiceIndex)) == null || voice.isEmpty() || voice.isRestVoice()) continue;
                intervalPreciseEnd = b.getPreciseStart();
                break;
            }
            if ((toFillPrecise = intervalPreciseEnd - (beatPreciseStart + duration.getPreciseTime())) > 0L) {
                ok = TGDuration.splitPreciseDuration(toFillPrecise, measure.getPreciseLength(), this.getSongManager().getFactory()) != null;
            }
            return ok;
        }
        TGVoice nextVoice = this.getNextVoice(beats, beat, voiceIndex);
        if (currentVoice == null || currentVoice.isEmpty()) {
            if ((nextVoice == null || nextVoice.isEmpty()) && beatPreciseEnd <= measurePreciseEnd) {
                return true;
            }
            if (nextVoice != null && !nextVoice.isEmpty() && beatPreciseEnd <= nextVoice.getBeat().getPreciseStart()) {
                return true;
            }
        }
        if (nextVoice != null && !nextVoice.isEmpty() && nextVoice.isRestVoice()) {
            long nextBeatPreciseEnd = 0L;
            ArrayList<TGVoice> nextBeats = new ArrayList<TGVoice>();
            while (nextVoice != null && !nextVoice.isEmpty() && nextVoice.isRestVoice() && !nextVoice.getBeat().isTextBeat()) {
                nextBeats.add(nextVoice);
                nextBeatPreciseEnd = nextVoice.getBeat().getPreciseStart() + nextVoice.getDuration().getPreciseTime();
                nextVoice = this.getNextVoice(beats, nextVoice.getBeat(), voiceIndex);
            }
            if (nextVoice == null || nextVoice.isEmpty()) {
                nextBeatPreciseEnd = measurePreciseEnd;
            } else if (!nextVoice.isRestVoice() || nextVoice.getBeat().isTextBeat()) {
                nextBeatPreciseEnd = nextVoice.getBeat().getPreciseStart();
            }
            if (beatPreciseEnd <= nextBeatPreciseEnd) {
                while (!nextBeats.isEmpty()) {
                    TGVoice currVoice = (TGVoice)nextBeats.get(0);
                    nextBeats.remove(currVoice);
                    this.removeVoice(currVoice, false);
                }
                return true;
            }
        }
        if (moveNextBeats && (nextVoice = this.getNextVoice(beats, beat, voiceIndex)) != null) {
            long requiredPreciseLength = beatPreciseLength - (nextVoice.getBeat().getPreciseStart() - beatPreciseStart);
            long nextSilencePreciseLength = 0L;
            TGVoice nextRestBeat = this.getNextRestVoice(beats, beat.getVoice(voiceIndex));
            while (nextRestBeat != null) {
                nextSilencePreciseLength += nextRestBeat.getDuration().getPreciseTime();
                nextRestBeat = this.getNextRestVoice(beats, nextRestBeat);
            }
            if (requiredPreciseLength <= nextSilencePreciseLength) {
                List<TGVoice> voices = this.getVoicesBeforeEndPrecise(measure.getBeats(), nextVoice.getBeat().getPreciseStart(), voiceIndex);
                while (!voices.isEmpty()) {
                    TGVoice currVoice = voices.get(0);
                    if (currVoice.isRestVoice()) {
                        requiredPreciseLength -= currVoice.getDuration().getPreciseTime();
                        this.removeVoice(currVoice, false);
                    } else if (requiredPreciseLength > 0L) {
                        this.moveVoicePrecise(currVoice, requiredPreciseLength);
                    }
                    voices.remove(0);
                }
                return true;
            }
        }
        if (setCurrentDuration && currentVoice != null && !currentVoice.isEmpty()) {
            duration.copyFrom(currentVoice.getDuration());
            return true;
        }
        return false;
    }

    public boolean moveVoicesPrecise(TGMeasure measure, long preciseStart, long thePreciseMove, int voiceIndex, TGDuration fillDuration) {
        TGDuration lastDuration;
        if (thePreciseMove == 0L) {
            return false;
        }
        boolean success = true;
        long measurePreciseStart = measure.getPreciseStart();
        long measurePreciseEnd = measurePreciseStart + measure.getPreciseLength();
        List<TGVoice> voicesToMove = this.getVoicesBeforeEndPrecise(measure.getBeats(), preciseStart, voiceIndex);
        ArrayList<TGVoice> voicesToRemove = new ArrayList<TGVoice>();
        List<TGBeat> currentBeats = this.getBeatsBeforeEndPrecise(measure.getBeats(), preciseStart);
        TGVoice first = this.getFirstVoice(currentBeats, voiceIndex);
        while (!(first == null || !first.isRestVoice() || first.getBeat().isTextBeat() && this.isUniqueVoice(first, false) || first.getBeat().getPreciseStart() + thePreciseMove >= measurePreciseStart)) {
            currentBeats.remove(first.getBeat());
            voicesToRemove.add(first);
            first = this.getNextVoice(currentBeats, first.getBeat(), voiceIndex);
        }
        TGVoice last = this.getLastVoice(currentBeats, voiceIndex);
        TGDuration tGDuration = lastDuration = last != null ? last.getDuration() : null;
        while (!(last == null || lastDuration == null || !last.isRestVoice() || last.getBeat().isTextBeat() && this.isUniqueVoice(last, false) || last.getBeat().getPreciseStart() + lastDuration.getPreciseTime() + thePreciseMove <= measurePreciseEnd)) {
            currentBeats.remove(last.getBeat());
            voicesToRemove.add(last);
            last = this.getPreviousVoice(currentBeats, last.getBeat(), voiceIndex);
            lastDuration = last != null ? last.getDuration() : null;
        }
        if (first != null && last != null && lastDuration != null && (first.getBeat().getPreciseStart() + thePreciseMove < measurePreciseStart || last.getBeat().getPreciseStart() + lastDuration.getPreciseTime() + thePreciseMove > measurePreciseEnd)) {
            success = false;
        }
        if (success) {
            this.moveVoicesPrecise(voicesToMove, thePreciseMove);
            for (TGVoice beat : voicesToRemove) {
                this.removeVoice(beat);
            }
            if (fillDuration != null) {
                if (thePreciseMove < 0L) {
                    long beatPreciseStart;
                    last = this.getLastVoice(measure.getBeats(), voiceIndex);
                    lastDuration = last != null ? last.getDuration() : null;
                    long l = beatPreciseStart = last != null && lastDuration != null ? last.getBeat().getPreciseStart() + lastDuration.getPreciseTime() : preciseStart;
                    if (beatPreciseStart + fillDuration.getPreciseTime() <= measurePreciseEnd) {
                        boolean beatNew = false;
                        TGBeat beat = this.getBeatPrecise(measure, beatPreciseStart);
                        if (beat == null) {
                            beat = this.getSongManager().getFactory().newBeat();
                            beat.setPreciseStart(beatPreciseStart);
                            beatNew = true;
                        }
                        TGVoice voice = beat.getVoice(voiceIndex);
                        voice.setEmpty(false);
                        voice.getDuration().copyFrom(fillDuration);
                        if (beatNew) {
                            this.addBeat(measure, beat);
                        }
                    }
                } else {
                    first = this.getFirstVoice(this.getBeatsBeforeEndPrecise(measure.getBeats(), preciseStart), voiceIndex);
                    if (preciseStart + fillDuration.getPreciseTime() <= (first != null ? first.getBeat().getPreciseStart() : measurePreciseEnd)) {
                        boolean beatNew = false;
                        TGBeat beat = this.getBeatPrecise(measure, preciseStart);
                        if (beat == null) {
                            beat = this.getSongManager().getFactory().newBeat();
                            beat.setPreciseStart(preciseStart);
                            beatNew = true;
                        }
                        TGVoice voice = beat.getVoice(voiceIndex);
                        voice.setEmpty(false);
                        voice.getDuration().copyFrom(fillDuration);
                        if (beatNew) {
                            this.addBeat(measure, beat);
                        }
                    }
                }
            }
            this.removeEmptyBeats(measure);
        }
        return success;
    }

    public boolean isUniqueVoice(TGVoice voice, boolean ignoreRests) {
        TGBeat beat = voice.getBeat();
        for (int v = 0; v < beat.countVoices(); ++v) {
            TGVoice currentVoice;
            if (v == voice.getIndex() || (currentVoice = beat.getVoice(v)).isEmpty() || ignoreRests && currentVoice.isRestVoice()) continue;
            return false;
        }
        return true;
    }

    public void transposeNotes(TGMeasure measure, int transposition, boolean tryKeepString, boolean applyToChords, int applyToString) {
        TGTrack track;
        if (transposition != 0 && measure != null && (track = measure.getTrack()) != null) {
            List<TGString> strings = this.getSortedStringsByValue(track, transposition > 0 ? 1 : -1);
            for (int i = 0; i < measure.countBeats(); ++i) {
                TGBeat beat = measure.getBeat(i);
                this.transposeNotes(beat, strings, transposition, tryKeepString, applyToChords, applyToString, track.getMaxFret());
            }
        }
    }

    public void transposeNotes(TGMeasure measure, int[] transpositionStrings, boolean tryKeepString, boolean applyToChords) {
        TGTrack track;
        if (transpositionStrings != null && transpositionStrings.length > 0 && measure != null && (track = measure.getTrack()) != null) {
            TGNote[] notes = new TGNote[transpositionStrings.length];
            for (int b = 0; b < measure.countBeats(); ++b) {
                TGBeat beat = measure.getBeat(b);
                for (int n = 0; n < notes.length; ++n) {
                    notes[n] = this.getNote(beat, n + 1);
                }
                for (int i = 0; i < notes.length; ++i) {
                    int transposition;
                    if (notes[i] == null || (transposition = transpositionStrings[i]) == 0) continue;
                    int applyToString = notes[i].getString();
                    List<TGString> strings = this.getSortedStringsByValue(track, transposition > 0 ? 1 : -1);
                    this.transposeNotes(beat, strings, transposition, tryKeepString, applyToChords, applyToString, track.getMaxFret());
                }
            }
        }
    }

    public void transposeNotes(TGBeat beat, List<TGString> strings, int transposition, boolean tryKeepString, boolean applyToChord, int applyToString, int maxFret) {
        if (transposition != 0) {
            List<TGNote> notes = this.getNotes(beat);
            int stringCount = strings.size();
            for (int i = 0; i < stringCount; ++i) {
                int chordString;
                TGChord chord;
                TGString string = strings.get(stringCount - i - 1);
                if (applyToString != -1 && string.getNumber() != applyToString) continue;
                TGNote note = null;
                for (int n = 0; n < notes.size(); ++n) {
                    TGNote current = notes.get(n);
                    if (current.getString() != string.getNumber()) continue;
                    note = current;
                }
                if (note != null) {
                    this.transposeNote(note, notes, strings, transposition, tryKeepString, false, maxFret);
                }
                if (!applyToChord || !beat.isChordBeat() || (chord = beat.getChord()).getFretValue(chordString = string.getNumber() - 1) < 0) continue;
                this.transposeChordNote(chord, chordString, strings, transposition, tryKeepString, false, maxFret);
            }
            if (applyToChord && beat.isChordBeat()) {
                TGChord chord = beat.getChord();
                chord.setFirstFret(-1);
                chord.setName("");
            }
        }
    }

    private boolean transposeNote(TGNote note, List<TGNote> notes, List<TGString> strings, int transposition, boolean tryKeepString, boolean forceChangeString, int maxFret) {
        boolean canTransposeFret = false;
        int transposedFret = note.getValue() + transposition;
        if (transposedFret >= 0 && transposedFret <= maxFret) {
            if (!forceChangeString && tryKeepString) {
                note.setValue(transposedFret);
                return true;
            }
            canTransposeFret = true;
        }
        int stringIndex = -1;
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = strings.get(i);
            if (string.getNumber() != note.getString()) continue;
            stringIndex = i;
            break;
        }
        TGString string = strings.get(stringIndex);
        int transposedValue = string.getValue() + note.getValue() + transposition;
        for (int nextStringIndex = stringIndex + 1; nextStringIndex >= 0 && nextStringIndex < strings.size(); ++nextStringIndex) {
            TGString nextString = strings.get(nextStringIndex);
            TGNote nextOwner = null;
            for (int i = 0; i < notes.size(); ++i) {
                TGNote nextNote = notes.get(i);
                if (nextNote.getString() != nextString.getNumber()) continue;
                nextOwner = nextNote;
            }
            int transposedStringFret = transposedValue - nextString.getValue();
            if (transposedStringFret < 0 || transposedStringFret > maxFret) continue;
            if (nextOwner != null && !this.transposeNote(nextOwner, notes, strings, 0, tryKeepString, !canTransposeFret, maxFret)) {
                nextOwner = null;
            }
            if (nextOwner != null && nextOwner.getString() == nextString.getNumber()) continue;
            note.setValue(transposedStringFret);
            note.setString(nextString.getNumber());
            return true;
        }
        if (!forceChangeString && canTransposeFret) {
            note.setValue(transposedFret);
            return true;
        }
        notes.remove(note);
        this.removeNote(note);
        return false;
    }

    private boolean transposeChordNote(TGChord chord, int chordString, List<TGString> strings, int transposition, boolean tryKeepString, boolean forceChangeString, int maximumFret) {
        boolean canTransposeFret = false;
        int noteValue = chord.getFretValue(chordString);
        int noteString = chordString + 1;
        int transposedFret = noteValue + transposition;
        if (transposedFret >= 0 && transposedFret <= maximumFret) {
            if (!forceChangeString && tryKeepString) {
                chord.addFretValue(chordString, transposedFret);
                return true;
            }
            canTransposeFret = true;
        }
        int stringIndex = -1;
        for (int i = 0; i < strings.size(); ++i) {
            TGString string = strings.get(i);
            if (string.getNumber() != noteString) continue;
            stringIndex = i;
            break;
        }
        TGString string = strings.get(stringIndex);
        int transposedValue = string.getValue() + noteValue + transposition;
        for (int nextStringIndex = stringIndex + 1; nextStringIndex >= 0 && nextStringIndex < strings.size(); ++nextStringIndex) {
            TGString nextString = strings.get(nextStringIndex);
            int nextChordString = -1;
            for (int i = 0; i < chord.countStrings(); ++i) {
                if (i + 1 != nextString.getNumber() || chord.getFretValue(i) < 0) continue;
                nextChordString = i;
            }
            int transposedStringFret = transposedValue - nextString.getValue();
            if (transposedStringFret < 0 || transposedStringFret > maximumFret) continue;
            if (nextChordString >= 0) {
                this.transposeChordNote(chord, nextChordString, strings, 0, tryKeepString, !canTransposeFret, maximumFret);
            }
            if (nextChordString >= 0 && chord.getFretValue(nextChordString) >= 0) continue;
            chord.addFretValue(chordString, -1);
            chord.addFretValue(nextString.getNumber() - 1, transposedStringFret);
            return true;
        }
        if (!forceChangeString && canTransposeFret) {
            chord.addFretValue(chordString, transposedFret);
            return true;
        }
        chord.addFretValue(chordString, -1);
        return false;
    }

    public List<TGString> getSortedStringsByValue(TGTrack track, final int direction) {
        ArrayList<TGString> strings = new ArrayList<TGString>();
        for (int number = 1; number <= track.stringCount(); ++number) {
            strings.add(track.getString(number));
        }
        Collections.sort(strings, new Comparator<TGString>(){

            @Override
            public int compare(TGString s1, TGString s2) {
                if (s1 != null && s2 != null) {
                    int status = s1.getValue() - s2.getValue();
                    if (status == 0) {
                        return 0;
                    }
                    return status * direction > 0 ? 1 : -1;
                }
                return 0;
            }
        });
        return strings;
    }

    public int getRealNoteValue(TGNote note) {
        TGString string;
        TGTrack track;
        TGMeasure measure;
        TGBeat beat;
        int value = note.getValue();
        TGVoice voice = note.getVoice();
        if (voice != null && (beat = voice.getBeat()) != null && (measure = beat.getMeasure()) != null && (track = measure.getTrack()) != null && (string = track.getString(note.getString())) != null) {
            value += string.getValue();
        }
        return value;
    }

    public void removeOverlappingRestBeats(TGMeasure measure) {
        ArrayList<TGBeat> beatsToRemove = new ArrayList<TGBeat>();
        for (TGBeat refBeat : measure.getBeats()) {
            for (TGBeat beat : measure.getBeats()) {
                long beatPreciseEnd = beat.getPreciseStart() + this.getMaximumDuration(beat).getPreciseTime();
                long refBeatPreciseEnd = refBeat.getPreciseStart() + this.getMaximumDuration(refBeat).getPreciseTime();
                if (!beat.isRestBeat() || refBeat.isRestBeat() || beatsToRemove.contains(beat) || beatPreciseEnd <= refBeat.getPreciseStart() || beat.getPreciseStart() >= refBeatPreciseEnd) continue;
                beatsToRemove.add(beat);
            }
        }
        while (beatsToRemove.size() > 0) {
            this.removeBeat((TGBeat)beatsToRemove.get(0));
            beatsToRemove.remove(0);
        }
    }
}

