/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.models;

import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGPickStroke;
import app.tuxguitar.song.models.TGStroke;
import app.tuxguitar.song.models.TGText;
import app.tuxguitar.song.models.TGVoice;

public abstract class TGBeat
implements Comparable<TGBeat> {
    public static final int MAX_VOICES = 2;
    private long start;
    private Long preciseStart = TGDuration.getPreciseStartingPoint();
    private TGMeasure measure;
    private TGChord chord;
    private TGText text;
    private TGVoice[] voices;
    private TGStroke stroke;
    private TGPickStroke pickStroke;

    public TGBeat(TGFactory factory) {
        this.start = TGDuration.getStartingPoint();
        this.stroke = factory.newStroke();
        this.pickStroke = factory.newPickStroke();
        this.voices = new TGVoice[2];
        for (int i = 0; i < 2; ++i) {
            this.setVoice(i, factory.newVoice(i));
        }
    }

    public TGMeasure getMeasure() {
        return this.measure;
    }

    public void setMeasure(TGMeasure measure) {
        this.measure = measure;
    }

    public long getStart() {
        if (this.preciseStart != null) {
            return TGDuration.toTime(this.preciseStart);
        }
        return this.start;
    }

    public Long getPreciseStart() {
        return this.preciseStart;
    }

    @Deprecated
    public void setStart(long start) {
        this.start = start;
        this.preciseStart = null;
    }

    public void setPreciseStart(long pStart) {
        this.preciseStart = pStart;
        this.start = TGDuration.toTime(pStart);
    }

    public void setVoice(int index, TGVoice voice) {
        if (index >= 0 && index < this.voices.length) {
            this.voices[index] = voice;
            this.voices[index].setBeat(this);
        }
    }

    public TGVoice getVoice(int index) {
        if (index >= 0 && index < this.voices.length) {
            return this.voices[index];
        }
        return null;
    }

    public int getHighestFret() {
        int highestFret = -1;
        for (int i = 0; i < this.countVoices(); ++i) {
            int voiceHighestFret = this.getVoice(i).getHighestFret();
            highestFret = voiceHighestFret > highestFret ? voiceHighestFret : highestFret;
        }
        return highestFret;
    }

    public int countVoices() {
        return this.voices.length;
    }

    public void setChord(TGChord chord) {
        this.chord = chord;
        this.chord.setBeat(this);
    }

    public TGChord getChord() {
        return this.chord;
    }

    public void removeChord() {
        this.chord = null;
    }

    public TGText getText() {
        return this.text;
    }

    public void setText(TGText text) {
        this.text = text;
        this.text.setBeat(this);
    }

    public void removeText() {
        this.text = null;
    }

    public boolean isChordBeat() {
        return this.chord != null;
    }

    public boolean isTextBeat() {
        return this.text != null;
    }

    public TGStroke getStroke() {
        return this.stroke;
    }

    public TGPickStroke getPickStroke() {
        return this.pickStroke;
    }

    public boolean isPickStroke() {
        return this.pickStroke.getDirection() != 0;
    }

    public boolean isRestBeat() {
        for (int v = 0; v < this.countVoices(); ++v) {
            TGVoice voice = this.getVoice(v);
            if (voice.isEmpty() || voice.isRestVoice()) continue;
            return false;
        }
        return true;
    }

    public void resetAltEnharmonic() {
        for (int v = 0; v < this.countVoices(); ++v) {
            TGVoice voice = this.getVoice(v);
            voice.resetAltEnharmonic();
        }
    }

    public void copyFrom(TGBeat beat, TGFactory factory) {
        if (beat.getPreciseStart() != null) {
            this.setPreciseStart(beat.getPreciseStart());
        } else {
            this.setStart(beat.getStart());
        }
        this.getStroke().copyFrom(beat.getStroke());
        this.getPickStroke().copyFrom(beat.getPickStroke());
        for (int i = 0; i < beat.voices.length; ++i) {
            this.setVoice(i, beat.voices[i].clone(factory));
        }
        if (beat.chord != null) {
            this.setChord(beat.chord.clone(factory));
        }
        if (beat.text != null) {
            this.setText(beat.text.clone(factory));
        }
    }

    public TGBeat clone(TGFactory factory) {
        TGBeat beat = factory.newBeat();
        beat.copyFrom(this, factory);
        return beat;
    }

    @Override
    public int compareTo(TGBeat beat) {
        if (beat == null) {
            return 1;
        }
        if (this.preciseStart != null && beat.getPreciseStart() != null) {
            return Long.valueOf(this.preciseStart).compareTo((long)beat.getPreciseStart());
        }
        return Long.valueOf(this.getStart()).compareTo(beat.getStart());
    }
}

