/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.models;

import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGNoteEffect;
import app.tuxguitar.song.models.TGVoice;

public abstract class TGNote
implements Comparable<TGNote> {
    private int value = 0;
    private int velocity = 95;
    private int string = 1;
    private boolean tiedNote = false;
    private TGNoteEffect effect;
    private TGVoice voice;
    private boolean altEnharmonic;

    public TGNote(TGFactory factory) {
        this.effect = factory.newEffect();
        this.altEnharmonic = false;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
    }

    public int getString() {
        return this.string;
    }

    public void setString(int string) {
        this.string = string;
    }

    public boolean isTiedNote() {
        return this.tiedNote;
    }

    public void setTiedNote(boolean tiedNote) {
        this.tiedNote = tiedNote;
    }

    public TGNoteEffect getEffect() {
        return this.effect;
    }

    public void setEffect(TGNoteEffect effect) {
        this.effect = effect;
    }

    public TGVoice getVoice() {
        return this.voice;
    }

    public void setVoice(TGVoice voice) {
        this.voice = voice;
    }

    public boolean isAltEnharmonic() {
        return this.altEnharmonic;
    }

    public void toggleAltEnharmonic() {
        this.altEnharmonic = !this.altEnharmonic;
    }

    public void resetAltEnharmonic() {
        this.altEnharmonic = false;
    }

    public TGNote clone(TGFactory factory) {
        TGNote note = factory.newNote();
        note.setValue(this.getValue());
        note.setVelocity(this.getVelocity());
        note.setString(this.getString());
        note.setTiedNote(this.isTiedNote());
        note.setEffect(this.getEffect().clone(factory));
        note.altEnharmonic = this.isAltEnharmonic();
        return note;
    }

    @Override
    public int compareTo(TGNote note) {
        return Integer.valueOf(this.value).compareTo(note.getValue());
    }
}

