/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.util;

import app.tuxguitar.util.TGContext;
import app.tuxguitar.util.error.TGErrorManager;
import app.tuxguitar.util.singleton.TGSingletonFactory;
import app.tuxguitar.util.singleton.TGSingletonUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class TGLibraryLoader {
    private TGContext context;

    private TGLibraryLoader(TGContext context) {
        this.context = context;
    }

    public void loadLibrary(File file) {
        try {
            System.out.println("Loading: " + file.getAbsolutePath());
            System.load(file.getAbsolutePath());
        }
        catch (Throwable throwable) {
            TGErrorManager.getInstance(this.context).handleError(throwable);
        }
    }

    public void loadLibraries(File folder, String prefix, String extension) {
        if (folder != null && folder.exists()) {
            List<String> libraries = this.findLibrariesToLoad(folder, prefix, extension);
            for (int i = 0; i < libraries.size(); ++i) {
                String library = libraries.get(i);
                File file = new File(this.getLibraryFileName(folder, library));
                if (!file.exists() || file.isDirectory()) continue;
                this.loadLibrary(file);
            }
        }
    }

    private String getLibraryFileName(File folder, String library) {
        return folder.getAbsolutePath() + File.separator + library;
    }

    private String getLibraryDependenciesFileName(File folder, String library) {
        return this.getLibraryFileName(folder, library) + ".deps";
    }

    private List<String> findLibrariesToLoad(File folder, String prefix, String extension) {
        ArrayList<String> libraries = new ArrayList<String>();
        String[] files = folder.list(this.createFilenameFilter(prefix, extension));
        String library = null;
        while ((library = this.findNextLibraryToLoad(libraries, folder, files)) != null) {
            libraries.add(library);
        }
        return libraries;
    }

    private String findNextLibraryToLoad(List<String> libraries, File folder, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            if (libraries.contains(files[i])) continue;
            return this.findNextLibraryToLoad(libraries, folder, files, files[i]);
        }
        return null;
    }

    private String findNextLibraryToLoad(List<String> libraries, File folder, String[] files, String expectedLib) {
        List<String> dependencies = this.findDependencyLibraries(folder, expectedLib);
        if (dependencies != null) {
            for (String dependency : dependencies) {
                if (libraries.contains(dependency)) continue;
                for (int i = 0; i < files.length; ++i) {
                    if (!dependency.equals(files[i])) continue;
                    return this.findNextLibraryToLoad(libraries, folder, files, dependency);
                }
            }
        }
        return expectedLib;
    }

    private List<String> findDependencyLibraries(File folder, String library) {
        return this.findDependencyLibraries(new File(this.getLibraryDependenciesFileName(folder, library)));
    }

    private List<String> findDependencyLibraries(File file) {
        try {
            ArrayList<String> libraries = new ArrayList<String>();
            if (file.exists()) {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String library = null;
                while ((library = reader.readLine()) != null) {
                    libraries.add(library.trim());
                }
                reader.close();
            }
            return libraries;
        }
        catch (UnsupportedEncodingException e) {
            TGErrorManager.getInstance(this.context).handleError(e);
        }
        catch (IOException e) {
            TGErrorManager.getInstance(this.context).handleError(e);
        }
        return null;
    }

    private FilenameFilter createFilenameFilter(final String prefix, final String extension) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                int index;
                if (name == null) {
                    return false;
                }
                if (prefix != null && prefix.length() > 0 && (index = name.indexOf(prefix)) != 0) {
                    return false;
                }
                return extension == null || extension.length() <= 0 || (index = name.indexOf(extension)) == name.length() - extension.length();
            }
        };
    }

    public static TGLibraryLoader getInstance(TGContext context) {
        return TGSingletonUtil.getInstance(context, TGLibraryLoader.class.getName(), new TGSingletonFactory<TGLibraryLoader>(){

            @Override
            public TGLibraryLoader createInstance(TGContext context) {
                return new TGLibraryLoader(context);
            }
        });
    }
}

