/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.util;

import app.tuxguitar.song.models.TGScale;
import java.util.ArrayList;

public class TGMusicKeyUtils {
    public static final int MIN_MIDI_NOTE = 12;
    public static final int MAX_MIDI_NOTE = 127;
    public static final String[] sharpKeyNames = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    public static final String[] flatKeyNames = new String[]{"C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B"};
    private static final int[] indexesSharp = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6};
    private static final int[] indexes6Sharp = new int[]{0, 0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6};
    private static final int[] indexes7Sharp = new int[]{6, 0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6};
    private static final int[] indexesFlat = new int[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6};
    private static final int[] indexes6Flat = new int[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 0};
    private static final int[] indexes7Flat = new int[]{0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6, 0};
    private static final int[][] tableIndex = new int[][]{indexesSharp, indexes6Sharp, indexes7Sharp, indexesFlat, indexes6Flat, indexes7Flat};
    private static final int[] indexKeySignature = new int[]{0, 0, 0, 0, 0, 0, 1, 2, 3, 3, 3, 3, 3, 4, 5};
    private static final int[] sharps = new int[]{3, 0, 4, 1, 5, 2, 6};
    private static final String[] names = new String[]{"C", "D", "E", "F", "G", "A", "B"};
    public static final int NONE = 0;
    public static final int NATURAL = 1;
    public static final int SHARP = 2;
    public static final int FLAT = 3;
    private static boolean[] naturalNote = new boolean[]{true, false, true, false, true, true, false, true, false, true, false, true};

    public static String sharpNoteName(int midiNote) {
        if (midiNote < 12 || midiNote > 127) {
            return null;
        }
        return sharpKeyNames[midiNote % 12];
    }

    public static String flatNoteName(int midiNote) {
        if (midiNote < 12 || midiNote > 127) {
            return null;
        }
        return flatKeyNames[midiNote % 12];
    }

    public static int noteOctave(int midiNote) {
        return TGMusicKeyUtils.noteOctave(midiNote, 0);
    }

    public static String sharpNoteFullName(int midiNote) {
        if (midiNote < 12 || midiNote > 127) {
            return null;
        }
        return TGMusicKeyUtils.sharpNoteName(midiNote) + String.valueOf(TGMusicKeyUtils.noteOctave(midiNote));
    }

    public static boolean isNaturalNote(int midiNote) {
        return naturalNote[midiNote % 12];
    }

    public static String noteFullName(int midiNote, int keySignature) {
        if (midiNote < 12 || midiNote > 127) {
            return null;
        }
        if (keySignature < 0 || keySignature > 14) {
            return null;
        }
        return TGMusicKeyUtils.noteName(midiNote, keySignature) + String.valueOf(TGMusicKeyUtils.noteOctave(midiNote, keySignature));
    }

    public static String noteName(int midiNote, int keySignature) {
        if (midiNote < 12 || midiNote > 127) {
            return null;
        }
        if (keySignature < 0 || keySignature > 14) {
            return null;
        }
        int alteration = TGMusicKeyUtils.noteAlteration(midiNote, keySignature);
        String alterationString = alteration == 2 ? "#" : (alteration == 3 ? "b" : "");
        return TGMusicKeyUtils.noteShortName(midiNote, keySignature) + alterationString;
    }

    public static String noteShortName(int midiNote, int keySignature) {
        if (midiNote < 12 || midiNote > 127) {
            return null;
        }
        if (keySignature < 0 || keySignature > 14) {
            return null;
        }
        return names[TGMusicKeyUtils.noteIndex(midiNote, keySignature)];
    }

    public static int noteOctave(int midiNote, int keySignature) {
        if (midiNote < 12 || midiNote > 127) {
            return 0;
        }
        if (keySignature < 0 || keySignature > 14) {
            return 0;
        }
        int octave = midiNote / 12 - 1;
        if (keySignature == 7 && midiNote % 12 == 0) {
            --octave;
        } else if (keySignature >= 13 && midiNote % 12 == 11) {
            ++octave;
        }
        return octave;
    }

    public static int noteIndex(int midiNote, int keySignature) {
        if (keySignature < 0 || keySignature > 14) {
            return 0;
        }
        return tableIndex[indexKeySignature[keySignature]][midiNote % 12];
    }

    public static int noteAlteration(int midiNote, int keySignature) {
        int alteration = 1;
        int index = TGMusicKeyUtils.noteIndex(midiNote, keySignature);
        int indexFlat = TGMusicKeyUtils.noteIndex(midiNote, 8);
        if ((7 + indexFlat - index) % 7 == 1) {
            alteration = 2;
        } else {
            int indexSharp = TGMusicKeyUtils.noteIndex(midiNote, 0);
            if ((7 + indexSharp - index) % 7 == 6) {
                alteration = 3;
            }
        }
        return alteration;
    }

    public static int noteAccidental(int midiNote, int keySignature) {
        int index;
        int alteration = TGMusicKeyUtils.noteAlteration(midiNote, keySignature);
        return alteration == TGMusicKeyUtils.noteIndexAlteration(index = TGMusicKeyUtils.noteIndex(midiNote, keySignature), keySignature) ? 0 : alteration;
    }

    public static int noteIndexAlteration(int noteIndex, int keySignature) {
        if (keySignature == 0) {
            return 1;
        }
        if (keySignature <= 7) {
            for (int i = 1; i <= keySignature; ++i) {
                if (noteIndex != sharps[i - 1]) continue;
                return 2;
            }
        } else {
            for (int i = 8; i <= keySignature; ++i) {
                if (noteIndex != sharps[14 - i]) continue;
                return 3;
            }
        }
        return 1;
    }

    public static String noteName(int midiNote, int keySignature, boolean altEnharmonic) {
        String normalName = TGMusicKeyUtils.noteName(midiNote, keySignature);
        if (!altEnharmonic) {
            return normalName;
        }
        String name = TGMusicKeyUtils.noteName(midiNote, 7);
        if (!name.equals(normalName)) {
            return name;
        }
        return TGMusicKeyUtils.noteName(midiNote, 14);
    }

    public static String noteShortName(int midiNote, int keySignature, boolean altEnharmonic) {
        String normalShortName = TGMusicKeyUtils.noteShortName(midiNote, keySignature);
        if (!altEnharmonic) {
            return normalShortName;
        }
        String shortName = TGMusicKeyUtils.noteShortName(midiNote, 7);
        if (!shortName.equals(normalShortName)) {
            return shortName;
        }
        return TGMusicKeyUtils.noteShortName(midiNote, 14);
    }

    public static int noteOctave(int midiNote, int keySignature, boolean altEnharmonic) {
        int normalOctave = TGMusicKeyUtils.noteOctave(midiNote, keySignature);
        if (!altEnharmonic) {
            return normalOctave;
        }
        int octave = TGMusicKeyUtils.noteOctave(midiNote, 7);
        if (octave != normalOctave) {
            return octave;
        }
        return TGMusicKeyUtils.noteOctave(midiNote, 14);
    }

    public static int noteIndex(int midiNote, int keySignature, boolean altEnharmonic) {
        int normalIndex = TGMusicKeyUtils.noteIndex(midiNote, keySignature);
        if (!altEnharmonic) {
            return normalIndex;
        }
        int index = TGMusicKeyUtils.noteIndex(midiNote, 7);
        if (index != normalIndex) {
            return index;
        }
        return TGMusicKeyUtils.noteIndex(midiNote, 14);
    }

    public static int noteAccidental(int midiNote, int keySignature, boolean altEnharmonic) {
        int normalAccidental = TGMusicKeyUtils.noteAccidental(midiNote, keySignature);
        if (!altEnharmonic) {
            return normalAccidental;
        }
        int index = TGMusicKeyUtils.noteIndex(midiNote, keySignature);
        if (TGMusicKeyUtils.noteIndex(midiNote, 7) != index) {
            int accidental = TGMusicKeyUtils.noteAlteration(midiNote, 7);
            return accidental == 0 ? 2 : accidental;
        }
        if (TGMusicKeyUtils.noteIndex(midiNote, 14) != index) {
            int accidental = TGMusicKeyUtils.noteAlteration(midiNote, 14);
            return accidental == 0 ? 3 : accidental;
        }
        return normalAccidental;
    }

    public static int noteIndexAddInterval(int noteIndex, int offset) {
        int index = (noteIndex + offset) % 7;
        if (index < 0) {
            index += 7;
        }
        return index;
    }

    public static int noteOctaveAddInterval(int noteIndex, int octave, int offset) {
        return octave + (int)Math.floor((float)(noteIndex + offset) / 7.0f);
    }

    public static int midiNote(int noteIndex, int octave) {
        int[] semiTonesToC = new int[]{0, 2, 4, 5, 7, 9, 11};
        return 12 * (1 + octave) + semiTonesToC[noteIndex];
    }

    private static int getNbAccidentals(TGScale scale, int keySignature) {
        if (scale.getAlteration() == 2 && keySignature > 7) {
            return -1;
        }
        if (scale.getAlteration() == 3 && keySignature <= 7) {
            return -1;
        }
        ArrayList<String> notesNames = new ArrayList<String>();
        int nbAccidentals = 0;
        for (int i = 0; i < 12; ++i) {
            int value = 12 + scale.getKey() + i;
            if (!scale.getNote(value)) continue;
            String shortName = TGMusicKeyUtils.noteShortName(value, keySignature);
            if (notesNames.contains(shortName)) {
                return -1;
            }
            notesNames.add(shortName);
            if (TGMusicKeyUtils.noteAccidental(value, keySignature) == 0) continue;
            ++nbAccidentals;
        }
        return nbAccidentals;
    }

    public static int getKeySignature(TGScale scale) {
        if (TGMusicKeyUtils.getNbAccidentals(scale, 0) == 0) {
            return 0;
        }
        int bestKeySignature = 0;
        int nbAccidentalsMin = 8;
        for (int i = 7; i > 0; --i) {
            for (int j = 7; j >= 0; j -= 7) {
                int keySignature = i + j;
                int nbAccidentals = TGMusicKeyUtils.getNbAccidentals(scale, keySignature);
                if (nbAccidentals < 0 || nbAccidentals > nbAccidentalsMin) continue;
                nbAccidentalsMin = nbAccidentals;
                bestKeySignature = keySignature;
            }
        }
        return bestKeySignature;
    }
}

