/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.ui.swt.widget;

import app.tuxguitar.ui.event.UISelectionListener;
import app.tuxguitar.ui.swt.event.SWTSelectionListenerManager;
import app.tuxguitar.ui.swt.widget.SWTContainer;
import app.tuxguitar.ui.swt.widget.SWTControl;
import app.tuxguitar.ui.widget.UIDropDownSelect;
import app.tuxguitar.ui.widget.UISelectItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class SWTDropDownSelectLight<T>
extends SWTControl<Combo>
implements UIDropDownSelect<T> {
    private List<UISelectItem<T>> uiItems = new ArrayList<UISelectItem<T>>();
    private SWTDropDownComboEventListener selectionListener = new SWTDropDownComboEventListener(this);
    private int currentIndex;

    public SWTDropDownSelectLight(SWTContainer<? extends Composite> parent) {
        super(new Combo(parent.getControl(), 4), parent);
        this.setCurrentIndex(-1);
        ((Combo)this.getControl()).addModifyListener((ModifyListener)this.selectionListener);
        ((Combo)this.getControl()).addSelectionListener((SelectionListener)this.selectionListener);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public T getSelectedValue() {
        UISelectItem<T> selectedItem = this.getSelectedItem();
        return (T)(selectedItem != null ? selectedItem.getValue() : null);
    }

    public void setSelectedValue(T value) {
        this.setSelectedItem(new UISelectItem(null, value));
    }

    public UISelectItem<T> getSelectedItem() {
        int index = ((Combo)this.getControl()).getSelectionIndex();
        return index >= 0 && index < this.uiItems.size() ? this.uiItems.get(index) : null;
    }

    public void setSelectedItem(UISelectItem<T> item) {
        this.setCurrentIndex(item != null ? this.uiItems.indexOf(item) : -1);
        if (this.getCurrentIndex() != ((Combo)this.getControl()).getSelectionIndex()) {
            ((Combo)this.getControl()).select(this.getCurrentIndex());
        }
    }

    public void addItem(UISelectItem<T> item) {
        this.uiItems.add(item);
        ((Combo)this.getControl()).add(item.getText());
    }

    public void removeItem(UISelectItem<T> item) {
        int index;
        int n = index = item != null ? this.uiItems.indexOf(item) : -1;
        if (index >= 0 && index < this.uiItems.size()) {
            ((Combo)this.getControl()).remove(index);
            this.uiItems.remove(item);
        }
    }

    public void removeItems() {
        ArrayList<UISelectItem<T>> uiItems = new ArrayList<UISelectItem<T>>(this.uiItems);
        for (UISelectItem uISelectItem : uiItems) {
            this.removeItem(uISelectItem);
        }
    }

    public int getItemCount() {
        return this.uiItems.size();
    }

    public void addSelectionListener(UISelectionListener listener) {
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
    }

    private static class SWTDropDownComboEventListener
    extends SWTSelectionListenerManager
    implements ModifyListener {
        public SWTDropDownComboEventListener(SWTDropDownSelectLight<?> control) {
            super(control);
        }

        @Override
        public void widgetSelected(SelectionEvent e) {
            this.getDropDownControl().setCurrentIndex(((Combo)this.getDropDownControl().getControl()).getSelectionIndex());
            super.widgetSelected(e);
        }

        public void modifyText(ModifyEvent e) {
            SWTDropDownSelectLight<?> control = this.getDropDownControl();
            if (((Combo)control.getControl()).getSelectionIndex() == -1) {
                ((Combo)control.getControl()).select(control.getCurrentIndex());
            }
        }

        public SWTDropDownSelectLight<?> getDropDownControl() {
            return (SWTDropDownSelectLight)this.getControl();
        }
    }
}

