/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.ascii;

import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.effects.TGEffectBend;
import java.io.PrintStream;
import java.io.PrintWriter;

public class ASCIIOutputStream {
    private PrintWriter writer;
    private int x;
    private int y;

    public ASCIIOutputStream(PrintStream stream) {
        this.writer = new PrintWriter(stream);
    }

    public int drawChord(TGChord chord) {
        String chordName = chord != null ? chord.getName() : "";
        this.writer.print(chordName);
        this.movePoint(this.getPosX() + chordName.length(), this.getPosY());
        return chordName.length();
    }

    public int drawNote(TGNote note, TGNote nextNote, boolean printNote) {
        StringBuffer noteString = new StringBuffer();
        if (note != null) {
            TGEffectBend bend;
            int fret = note.getValue();
            if (note.getEffect().isDeadNote()) {
                noteString.append("X");
            } else if (note.getEffect().isBend() && note.getEffect().getBend().getMovements().size() == 0) {
                noteString.append("H");
            } else {
                noteString.append(fret);
            }
            if (note.getEffect().isHammer() && nextNote != null) {
                if (nextNote.getValue() > fret) {
                    noteString.append("h");
                } else {
                    noteString.append("p");
                }
            }
            if (note.getEffect().isSlide() && nextNote != null) {
                if (nextNote.getValue() > fret) {
                    noteString.append("/");
                } else {
                    noteString.append("\\");
                }
            }
            if (note.getEffect().isBend() && (bend = note.getEffect().getBend()).getMovements().size() > 0) {
                int movement = (Integer)bend.getMovements().get(0);
                int bendNote = fret + Math.abs(movement) / 2;
                if (movement < 0) {
                    noteString.insert(0, "r");
                    noteString.insert(0, bendNote);
                } else {
                    noteString.append("b");
                    noteString.append(bendNote);
                }
            }
            if (printNote) {
                this.writer.print(noteString.toString());
                this.movePoint(this.getPosX() + noteString.length(), this.getPosY());
            }
        }
        return noteString.length();
    }

    public void drawStringSegments(int count) {
        if (count < 0) {
            count = 0;
        }
        this.movePoint(this.getPosX() + count, this.getPosY());
        for (int i = 0; i < count; ++i) {
            this.writer.print("-");
        }
    }

    public void drawTuneSegment(String tune, int maxLength) {
        for (int i = tune.length(); i < maxLength; ++i) {
            this.drawSpace();
        }
        this.movePoint(this.getPosX() + tune.length(), this.getPosY());
        this.writer.print(tune);
    }

    public void drawBarSegment() {
        this.movePoint(this.getPosX() + 1, this.getPosY());
        this.writer.print("|");
    }

    public void nextLine() {
        this.movePoint(0, this.getPosY() + 1);
        this.writer.println("");
    }

    public void drawStringLine(String s) {
        this.movePoint(0, this.getPosY() + 1);
        this.writer.println(s);
    }

    public void drawSpace(int numSpaces) {
        this.movePoint(this.getPosX() + numSpaces, this.getPosY());
        for (int i = 0; i < numSpaces; ++i) {
            this.writer.print(' ');
        }
    }

    public void drawSpace() {
        this.drawSpace(1);
    }

    private void movePoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }
}

